/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

abstract class CaptureDataSeries<T extends CaptureObject>
implements DataSeries<CaptureDurationData<T>> {
    @NotNull
    protected final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    @NotNull
    protected final Common.Session mySession;
    @NotNull
    protected final FeatureTracker myFeatureTracker;

    protected CaptureDataSeries(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, @NotNull FeatureTracker featureTracker) {
        this.myClient = client;
        this.mySession = session;
        this.myFeatureTracker = featureTracker;
    }

    protected static long getHostTime(long timeNs) {
        return TimeUnit.NANOSECONDS.toMicros(timeNs);
    }

    protected static long getDurationUs(long startTimeNs, long endTimeNs) {
        return endTimeNs == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.NANOSECONDS.toMicros(endTimeNs) - TimeUnit.NANOSECONDS.toMicros(startTimeNs);
    }
}

