/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.memory.AllocStatsDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryUsage;
import org.jetbrains.annotations.NotNull;

public class DetailedMemoryUsage
extends MemoryUsage {
    private static final String JAVA_MEM = "Java";
    private static final String NATIVE_MEM = "Native";
    private static final String GRAPHICS_MEM = "Graphics";
    private static final String STACK_MEM = "Stack";
    private static final String CODE_MEM = "Code";
    private static final String OTHERS_MEM = "Others";
    private static final String ALLOCATED = "Allocated";
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Range myObjectsRange;
    @NotNull
    private final RangedContinuousSeries myJavaSeries;
    @NotNull
    private final RangedContinuousSeries myNativeSeries;
    @NotNull
    private final RangedContinuousSeries myGraphicsSeries;
    @NotNull
    private final RangedContinuousSeries myStackSeries;
    @NotNull
    private final RangedContinuousSeries myCodeSeries;
    @NotNull
    private final RangedContinuousSeries myOtherSeries;
    @NotNull
    private final RangedContinuousSeries myObjectsSeries;
    @NotNull
    private final DurationDataModel<GcDurationData> myGcDurations;
    @NotNull
    private final DurationDataModel<AllocationSamplingRateDurationData> myAllocationSamplingRateDurations;

    public DetailedMemoryUsage(@NotNull StudioProfilers profilers, @NotNull MemoryProfilerStage memoryProfilerStage) {
        super(profilers);
        this.myProfilers = profilers;
        this.myObjectsRange = new Range(0.0, 0.0);
        if (profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            this.myJavaSeries = this.createRangedSeries(profilers, JAVA_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> e.getMemoryUsage().getJavaMem()));
            this.myNativeSeries = this.createRangedSeries(profilers, NATIVE_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> e.getMemoryUsage().getNativeMem()));
            this.myGraphicsSeries = this.createRangedSeries(profilers, GRAPHICS_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> e.getMemoryUsage().getGraphicsMem()));
            this.myStackSeries = this.createRangedSeries(profilers, STACK_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> e.getMemoryUsage().getStackMem()));
            this.myCodeSeries = this.createRangedSeries(profilers, CODE_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> e.getMemoryUsage().getCodeMem()));
            this.myOtherSeries = this.createRangedSeries(profilers, OTHERS_MEM, this.getMemoryRange(), 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> e.getMemoryUsage().getOthersMem()));
        } else {
            this.myJavaSeries = this.createLegacyRangedSeries(profilers, JAVA_MEM, this.getMemoryRange(), sample -> sample.getMemoryUsage().getJavaMem());
            this.myNativeSeries = this.createLegacyRangedSeries(profilers, NATIVE_MEM, this.getMemoryRange(), sample -> sample.getMemoryUsage().getNativeMem());
            this.myGraphicsSeries = this.createLegacyRangedSeries(profilers, GRAPHICS_MEM, this.getMemoryRange(), sample -> sample.getMemoryUsage().getGraphicsMem());
            this.myStackSeries = this.createLegacyRangedSeries(profilers, STACK_MEM, this.getMemoryRange(), sample -> sample.getMemoryUsage().getStackMem());
            this.myCodeSeries = this.createLegacyRangedSeries(profilers, CODE_MEM, this.getMemoryRange(), sample -> sample.getMemoryUsage().getCodeMem());
            this.myOtherSeries = this.createLegacyRangedSeries(profilers, OTHERS_MEM, this.getMemoryRange(), sample -> sample.getMemoryUsage().getOthersMem());
        }
        MemoryServiceGrpc.MemoryServiceBlockingStub client = profilers.getClient().getMemoryClient();
        AllocStatsDataSeries series = new AllocStatsDataSeries(this.myProfilers, client, sample -> sample.getJavaAllocationCount() - sample.getJavaFreeCount());
        this.myObjectsSeries = new RangedContinuousSeries(ALLOCATED, profilers.getTimeline().getViewRange(), this.getObjectsRange(), (DataSeries)series);
        this.myGcDurations = memoryProfilerStage.getGcStatsModel();
        this.myAllocationSamplingRateDurations = memoryProfilerStage.getAllocationSamplingRateDurations();
        this.add(this.myJavaSeries);
        this.add(this.myNativeSeries);
        this.add(this.myGraphicsSeries);
        this.add(this.myStackSeries);
        this.add(this.myCodeSeries);
        this.add(this.myOtherSeries);
        this.add(this.myObjectsSeries);
    }

    @NotNull
    public Range getObjectsRange() {
        return this.myObjectsRange;
    }

    @NotNull
    public RangedContinuousSeries getJavaSeries() {
        return this.myJavaSeries;
    }

    @NotNull
    public RangedContinuousSeries getNativeSeries() {
        return this.myNativeSeries;
    }

    @NotNull
    public RangedContinuousSeries getGraphicsSeries() {
        return this.myGraphicsSeries;
    }

    @NotNull
    public RangedContinuousSeries getStackSeries() {
        return this.myStackSeries;
    }

    @NotNull
    public RangedContinuousSeries getCodeSeries() {
        return this.myCodeSeries;
    }

    @NotNull
    public RangedContinuousSeries getOtherSeries() {
        return this.myOtherSeries;
    }

    @NotNull
    public RangedContinuousSeries getObjectsSeries() {
        return this.myObjectsSeries;
    }

    @NotNull
    public DurationDataModel<GcDurationData> getGcDurations() {
        return this.myGcDurations;
    }

    @NotNull
    public DurationDataModel<AllocationSamplingRateDurationData> getAllocationSamplingRateDurations() {
        return this.myAllocationSamplingRateDurations;
    }

    @Override
    protected String getTotalSeriesLabel() {
        return "Total";
    }
}

