/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.sessions.SessionArtifact;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class HprofSessionArtifact
implements SessionArtifact<MemoryProfiler.HeapDumpInfo> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Common.SessionMetaData mySessionMetaData;
    @NotNull
    private final MemoryProfiler.HeapDumpInfo myInfo;

    public HprofSessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData, @NotNull MemoryProfiler.HeapDumpInfo info) {
        this.myProfilers = profilers;
        this.mySession = session;
        this.mySessionMetaData = sessionMetaData;
        this.myInfo = info;
    }

    @Override
    @NotNull
    public MemoryProfiler.HeapDumpInfo getArtifactProto() {
        return this.myInfo;
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        return this.myProfilers;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.mySession;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        return this.mySessionMetaData;
    }

    @Override
    @NotNull
    public String getName() {
        return "Heap Dump";
    }

    @NotNull
    public String getSubtitle() {
        if (this.mySessionMetaData.getType() == Common.SessionMetaData.SessionType.MEMORY_CAPTURE) {
            return TimeFormatter.getLocalizedDateTime((long)TimeUnit.NANOSECONDS.toMillis(this.mySession.getStartTimestamp()));
        }
        return this.isOngoing() ? "Recording..." : TimeFormatter.getFullClockString((long)TimeUnit.NANOSECONDS.toMicros(this.getTimestampNs()));
    }

    @Override
    public long getTimestampNs() {
        return this.myInfo.getStartTime() - this.mySession.getStartTimestamp();
    }

    @Override
    public boolean isOngoing() {
        return this.myInfo.getEndTime() == Long.MAX_VALUE;
    }

    @Override
    public boolean canExport() {
        return !this.isOngoing();
    }

    @Override
    public void onSelect() {
        boolean needsToOpenMemoryProfiler;
        boolean needsToChangeSession;
        boolean bl = needsToChangeSession = this.mySession != this.myProfilers.getSession();
        if (needsToChangeSession) {
            this.myProfilers.getSessionsManager().setSession(this.mySession);
        }
        boolean bl2 = needsToOpenMemoryProfiler = !(this.myProfilers.getStage() instanceof MemoryProfilerStage);
        if (needsToOpenMemoryProfiler) {
            this.myProfilers.setStage(new MemoryProfilerStage(this.myProfilers));
        }
        long startTimestamp = TimeUnit.NANOSECONDS.toMicros(this.myInfo.getStartTime());
        long endTimestamp = TimeUnit.NANOSECONDS.toMicros(this.myInfo.getEndTime());
        if (this.isOngoing()) {
            SessionArtifact.navigateTimelineToOngoingCapture(this.myProfilers.getTimeline(), startTimestamp);
        } else {
            assert (this.myProfilers.getStage() instanceof MemoryProfilerStage);
            MemoryProfilerStage stage = (MemoryProfilerStage)this.myProfilers.getStage();
            Range captureRange = new Range((double)startTimestamp, (double)endTimestamp);
            this.myProfilers.getTimeline().adjustRangeCloseToMiddleView(captureRange);
            stage.getSelectionModel().set(captureRange.getMin(), captureRange.getMax());
        }
        this.myProfilers.getIdeServices().getFeatureTracker().trackSessionArtifactSelected(this, this.myProfilers.getSessionsManager().isSessionAlive());
    }

    @Override
    public void export(@NotNull OutputStream outputStream) {
        assert (this.canExport());
        MemoryProfiler.saveHeapDumpToFile(this.myProfilers.getClient().getMemoryClient(), this.mySession, this.myInfo, outputStream, this.myProfilers.getIdeServices().getFeatureTracker());
    }

    public static List<SessionArtifact> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData) {
        MemoryProfiler.ListHeapDumpInfosResponse response = profilers.getClient().getMemoryClient().listHeapDumpInfos(MemoryProfiler.ListDumpInfosRequest.newBuilder().setSession(session).setStartTime(session.getStartTimestamp()).setEndTime(session.getEndTimestamp()).build());
        ArrayList<SessionArtifact> artifacts = new ArrayList<SessionArtifact>();
        for (MemoryProfiler.HeapDumpInfo info : response.getInfosList()) {
            artifacts.add(new HprofSessionArtifact(profilers, session, sessionMetaData, info));
        }
        return artifacts;
    }
}

