/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.ProfilerCombobox;
import com.android.tools.profilers.ProfilerComboboxCellRenderer;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import java.util.Collection;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryHeapView
extends AspectObserver {
    @NotNull
    private final MemoryProfilerStage myStage;
    @NotNull
    private JComboBox<HeapSet> myComboBox = new ProfilerCombobox();
    @Nullable
    private CaptureObject myCaptureObject = null;

    MemoryHeapView(@NotNull MemoryProfilerStage stage) {
        this.myStage = stage;
        this.myStage.getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADING_CAPTURE, this::setNewCapture).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE, this::updateCaptureState).onChange((Enum)MemoryProfilerAspect.CURRENT_HEAP, this::refreshHeap);
        this.myComboBox.addActionListener(e -> {
            Object item = this.myComboBox.getSelectedItem();
            if (item instanceof HeapSet) {
                this.myStage.selectHeapSet((HeapSet)item);
            }
        });
        this.setNewCapture();
        this.refreshHeap();
    }

    @NotNull
    JComboBox<HeapSet> getComponent() {
        return this.myComboBox;
    }

    private void setNewCapture() {
        this.myCaptureObject = this.myStage.getSelectedCapture();
        this.myComboBox.setModel(new DefaultComboBoxModel());
        this.myComboBox.setRenderer((ListCellRenderer<HeapSet>)((Object)new HeapListCellRenderer()));
        this.myStage.selectHeapSet(null);
    }

    private void updateCaptureState() {
        CaptureObject captureObject = this.myStage.getSelectedCapture();
        if (this.myCaptureObject != captureObject) {
            return;
        }
        this.myCaptureObject = captureObject;
        if (this.myCaptureObject == null) {
            return;
        }
        Collection<HeapSet> heaps = this.myCaptureObject.getHeapSets();
        HeapSet[] heapsArray = heaps.toArray(new HeapSet[heaps.size()]);
        DefaultComboBoxModel<HeapSet> comboBoxModel = new DefaultComboBoxModel<HeapSet>(heapsArray);
        this.myComboBox.setModel(comboBoxModel);
    }

    void refreshHeap() {
        Object selectedObject;
        HeapSet heapSet = this.myStage.getSelectedHeapSet();
        if (!Objects.equals(heapSet, selectedObject = this.myComboBox.getSelectedItem())) {
            this.myComboBox.setSelectedItem(heapSet);
        }
    }

    private static final class HeapListCellRenderer
    extends ProfilerComboboxCellRenderer<HeapSet> {
        private HeapListCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends HeapSet> list, HeapSet value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                this.append(value.getName() + " heap");
            }
        }
    }
}

