/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryObjectTreeNode<T extends MemoryObject>
implements MutableTreeNode {
    @Nullable
    protected MemoryObjectTreeNode<T> myParent;
    @NotNull
    protected List<MemoryObjectTreeNode<T>> myChildren = new ArrayList<MemoryObjectTreeNode<T>>();
    @Nullable
    protected Comparator<MemoryObjectTreeNode<T>> myComparator = null;
    @NotNull
    private final T myAdapter;
    private boolean myChildrenChanged;
    private boolean myComparatorChanged;

    public MemoryObjectTreeNode(@NotNull T adapter) {
        this.myAdapter = adapter;
    }

    @Override
    public TreeNode getChildAt(int i) {
        this.ensureOrder();
        return this.myChildren.get(i);
    }

    @Override
    public int getChildCount() {
        return this.myChildren.size();
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        assert (treeNode instanceof MemoryObjectTreeNode);
        this.ensureOrder();
        return this.myChildren.indexOf(treeNode);
    }

    @Override
    public boolean isLeaf() {
        return this.myChildren.isEmpty();
    }

    public Enumeration children() {
        this.ensureOrder();
        return Collections.enumeration(this.myChildren);
    }

    @NotNull
    public ImmutableList<MemoryObjectTreeNode<T>> getChildren() {
        this.ensureOrder();
        return ContainerUtil.immutableList(this.myChildren);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    public void add(@NotNull MemoryObjectTreeNode child) {
        this.insert(child, this.myChildren.size());
        this.myChildrenChanged = true;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        assert (newChild instanceof MemoryObjectTreeNode);
        MemoryObjectTreeNode child = (MemoryObjectTreeNode)newChild;
        if (child.myParent != null && child.myParent != this) {
            child.myParent.remove(child);
        }
        child.setParent(this);
        this.myChildren.add(childIndex, child);
        this.myChildrenChanged = true;
    }

    @Override
    public void setParent(@Nullable MutableTreeNode newParent) {
        assert (newParent == null || newParent instanceof MemoryObjectTreeNode);
        this.myParent = (MemoryObjectTreeNode)newParent;
    }

    @Override
    public void remove(int childIndex) {
        MemoryObjectTreeNode<T> child = this.myChildren.get(childIndex);
        this.myChildren.remove(childIndex);
        child.setParent(null);
        this.myChildrenChanged = true;
    }

    @Override
    public void remove(MutableTreeNode node) {
        assert (node instanceof MemoryObjectTreeNode);
        this.remove(this.myChildren.indexOf(node));
        this.myChildrenChanged = true;
    }

    @Override
    public void removeFromParent() {
        if (this.myParent != null) {
            this.myParent.remove(this);
            this.myParent = null;
        }
    }

    public void removeAll() {
        this.myChildren.forEach(child -> {
            child.myParent = null;
        });
        this.myChildren.clear();
        this.myChildrenChanged = true;
    }

    @Override
    public void setUserObject(Object object) {
        throw new RuntimeException("Not implemented, use setData/getAdapter instead.");
    }

    @NotNull
    public T getAdapter() {
        return this.myAdapter;
    }

    public void sort(@NotNull Comparator<MemoryObjectTreeNode<T>> comparator) {
        assert (this.myParent == null);
        if (this.myComparator != comparator) {
            this.myComparator = comparator;
            this.myComparatorChanged = true;
            this.ensureOrder();
        }
    }

    @Nullable
    public Comparator<MemoryObjectTreeNode<T>> getComparator() {
        return this.myComparator;
    }

    @NotNull
    public List<MemoryObjectTreeNode<T>> getPathToRoot() {
        ArrayList<MemoryObjectTreeNode<T>> path = new ArrayList<MemoryObjectTreeNode<T>>();
        MemoryObjectTreeNode<T> currentNode = this;
        MemoryObjectTreeNode<T> cycleDetector = this;
        while (currentNode != null) {
            for (int i = 0; i < 2 && cycleDetector != null; ++i) {
                assert (cycleDetector.myParent != currentNode);
                cycleDetector = cycleDetector.myParent;
            }
            path.add(currentNode);
            currentNode = currentNode.myParent;
        }
        Collections.reverse(path);
        return path;
    }

    protected void ensureOrder() {
        if (this.orderNeedsUpdating()) {
            Comparator<MemoryObjectTreeNode<MemoryObjectTreeNode<T>>> comparator = this.myComparator = this.myParent != null ? this.myParent.myComparator : this.myComparator;
            if (this.myComparator != null) {
                this.myChildren.sort(this.myComparator);
            }
            this.myComparatorChanged = false;
            this.myChildrenChanged = false;
        }
    }

    @VisibleForTesting
    boolean orderNeedsUpdating() {
        return this.myParent != null && this.myParent.myComparator != this.myComparator || this.myComparatorChanged || this.myChildrenChanged;
    }

    public void select() {
    }
}

