/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import org.jetbrains.annotations.NotNull;

public class MemoryProfilerConfiguration {
    @NotNull
    private final MemoryProfilerStage myStage;
    private ClassGrouping myClassGrouping = ClassGrouping.ARRANGE_BY_CLASS;

    MemoryProfilerConfiguration(@NotNull MemoryProfilerStage stage) {
        this.myStage = stage;
    }

    public void setClassGrouping(ClassGrouping classGrouping) {
        if (this.myClassGrouping != classGrouping) {
            this.myClassGrouping = classGrouping;
            this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackChangeClassArrangment();
            this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CLASS_GROUPING);
            this.myStage.getFilterHandler().refreshFilterContent();
        }
    }

    @NotNull
    public ClassGrouping getClassGrouping() {
        return this.myClassGrouping;
    }

    public static enum ClassGrouping {
        ARRANGE_BY_CLASS("Arrange by class"),
        ARRANGE_BY_PACKAGE("Arrange by package"),
        ARRANGE_BY_CALLSTACK("Arrange by callstack");

        @NotNull
        String myLabel;

        private ClassGrouping(String label) {
            this.myLabel = label;
        }

        public String toString() {
            return this.myLabel;
        }
    }
}

