/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.FilterComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.SelectionComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.chart.linechart.OverlayComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.instructions.IconInstruction;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.ProfilerAction;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerCombobox;
import com.android.tools.profilers.ProfilerComboboxCellRenderer;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.MemoryCaptureView;
import com.android.tools.profilers.memory.MemoryClassGrouping;
import com.android.tools.profilers.memory.MemoryClassSetView;
import com.android.tools.profilers.memory.MemoryClassifierView;
import com.android.tools.profilers.memory.MemoryHeapView;
import com.android.tools.profilers.memory.MemoryInstanceDetailsView;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryUsageTooltip;
import com.android.tools.profilers.memory.MemoryUsageTooltipView;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ReferenceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.Gray;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfilerStageView
extends StageView<MemoryProfilerStage> {
    private static final String RECORD_TEXT = "Record";
    private static final String STOP_TEXT = "Stop";
    @NotNull
    private final MemoryCaptureView myCaptureView = new MemoryCaptureView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
    @NotNull
    private final MemoryHeapView myHeapView = new MemoryHeapView((MemoryProfilerStage)this.getStage());
    @NotNull
    private final MemoryClassifierView myClassifierView = new MemoryClassifierView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
    @NotNull
    private final MemoryClassGrouping myClassGrouping = new MemoryClassGrouping((MemoryProfilerStage)this.getStage());
    @NotNull
    private final MemoryClassSetView myClassSetView = new MemoryClassSetView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
    @NotNull
    private final MemoryInstanceDetailsView myInstanceDetailsView = new MemoryInstanceDetailsView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
    @Nullable
    private SelectionComponent mySelectionComponent;
    @Nullable
    private CaptureObject myCaptureObject = null;
    @NotNull
    private final JBSplitter myMainSplitter = new JBSplitter(false);
    @NotNull
    private final JBSplitter myChartCaptureSplitter = new JBSplitter(true);
    @NotNull
    private final JPanel myCapturePanel;
    @Nullable
    private LoadingPanel myCaptureLoadingPanel;
    @NotNull
    private final JBSplitter myInstanceDetailsSplitter = new JBSplitter(true);
    @NotNull
    private JButton myForceGarbageCollectionButton;
    @NotNull
    private JButton myHeapDumpButton;
    @NotNull
    private JButton myAllocationButton;
    @NotNull
    private JComboBox myAllocationSamplingRateDropDown;
    @NotNull
    private ProfilerAction myForceGarbageCollectionAction;
    @NotNull
    private ProfilerAction myHeapDumpAction;
    @NotNull
    private ProfilerAction myAllocationAction;
    @NotNull
    private ProfilerAction myStopAllocationAction;
    @NotNull
    private final JLabel myCaptureElapsedTime;
    @NotNull
    private final JLabel myCaptureInfoMessage;
    @NotNull
    private final JLabel myAllocationSamplingRateLabel;
    @NotNull
    private DurationDataRenderer<GcDurationData> myGcDurationDataRenderer;
    @NotNull
    private DurationDataRenderer<AllocationSamplingRateDurationData> myAllocationSamplingRateRenderer;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryProfilerStageView.class);
    }

    public MemoryProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull MemoryProfilerStage stage) {
        super(profilersView, stage);
        ((MemoryProfilerStage)this.getStage()).enableSelectLatestCapture(true, SwingUtilities::invokeLater);
        this.getTooltipBinder().bind(MemoryUsageTooltip.class, MemoryUsageTooltipView::new);
        this.getTooltipBinder().bind(LifecycleTooltip.class, LifecycleTooltipView::new);
        this.getTooltipBinder().bind(UserEventTooltip.class, UserEventTooltipView::new);
        this.myMainSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_VERTICAL_BORDERS);
        this.myChartCaptureSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        this.myInstanceDetailsSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        if (!((MemoryProfilerStage)this.getStage()).isMemoryCaptureOnly()) {
            this.myChartCaptureSplitter.setFirstComponent((JComponent)this.buildMonitorUi());
        }
        this.myCaptureInfoMessage = new JLabel(StudioIcons.Common.WARNING);
        this.myCaptureInfoMessage.setBorder(ProfilerLayout.TOOLBAR_ICON_BORDER);
        this.myCaptureInfoMessage.setMinimumSize(this.myCaptureInfoMessage.getPreferredSize());
        this.myCaptureInfoMessage.setVisible(false);
        this.myCapturePanel = this.buildCaptureUi();
        this.myInstanceDetailsSplitter.setOpaque(true);
        this.myInstanceDetailsSplitter.setFirstComponent(this.myClassSetView.getComponent());
        this.myInstanceDetailsSplitter.setSecondComponent(this.myInstanceDetailsView.getComponent());
        this.myMainSplitter.setFirstComponent((JComponent)this.myChartCaptureSplitter);
        this.myMainSplitter.setSecondComponent((JComponent)this.myInstanceDetailsSplitter);
        this.myMainSplitter.setProportion(0.6f);
        this.getComponent().add((Component)this.myMainSplitter, "Center");
        this.myForceGarbageCollectionButton = new CommonButton(StudioIcons.Profiler.Toolbar.FORCE_GARBAGE_COLLECTION);
        this.myForceGarbageCollectionButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.FORCE_GARBAGE_COLLECTION));
        this.myForceGarbageCollectionButton.addActionListener(e -> {
            ((MemoryProfilerStage)this.getStage()).forceGarbageCollection();
            ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackForceGc();
        });
        this.myForceGarbageCollectionAction = new ProfilerAction.Builder("Force garbage collection").setContainerComponent(this.getComponent()).setIcon(this.myForceGarbageCollectionButton.getIcon()).setActionRunnable(() -> this.myForceGarbageCollectionButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(71, AdtUiUtils.getActionMask())).build();
        this.myForceGarbageCollectionButton.setToolTipText(this.myForceGarbageCollectionAction.getDefaultToolTipText());
        this.myHeapDumpButton = new CommonButton(StudioIcons.Profiler.Toolbar.HEAP_DUMP);
        this.myHeapDumpButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.HEAP_DUMP));
        this.myHeapDumpButton.addActionListener(e -> {
            ((MemoryProfilerStage)this.getStage()).requestHeapDump();
            ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackDumpHeap();
        });
        this.myHeapDumpAction = new ProfilerAction.Builder("Dump Java heap").setContainerComponent(this.getComponent()).setIcon(this.myHeapDumpButton.getIcon()).setActionRunnable(() -> this.myHeapDumpButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(68, AdtUiUtils.getActionMask())).build();
        this.myHeapDumpButton.setToolTipText(this.myHeapDumpAction.getDefaultToolTipText());
        this.myCaptureElapsedTime = new JLabel("");
        this.myCaptureElapsedTime.setFont(ProfilerFonts.STANDARD_FONT);
        this.myCaptureElapsedTime.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.myCaptureElapsedTime.setForeground(ProfilerColors.CPU_CAPTURE_STATUS);
        this.myAllocationButton = new JButton(RECORD_TEXT);
        this.myAllocationButton.setPreferredSize(this.myAllocationButton.getPreferredSize());
        this.myAllocationButton.addActionListener(e -> {
            if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations()) {
                ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackRecordAllocations();
            }
            ((MemoryProfilerStage)this.getStage()).trackAllocations(!((MemoryProfilerStage)this.getStage()).isTrackingAllocations());
        });
        this.myAllocationButton.setVisible(!((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking());
        this.myAllocationAction = new ProfilerAction.Builder("Record allocations").setIcon(StudioIcons.Profiler.Toolbar.RECORD).setContainerComponent(this.getComponent()).setEnableBooleanSupplier(() -> !((MemoryProfilerStage)this.getStage()).isTrackingAllocations()).setActionRunnable(() -> this.myAllocationButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(82, AdtUiUtils.getActionMask())).build();
        this.myStopAllocationAction = new ProfilerAction.Builder("Stop recording").setIcon(StudioIcons.Profiler.Toolbar.STOP_RECORDING).setContainerComponent(this.getComponent()).setEnableBooleanSupplier(() -> ((MemoryProfilerStage)this.getStage()).isTrackingAllocations()).setActionRunnable(() -> this.myAllocationButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(83, AdtUiUtils.getActionMask())).build();
        this.myAllocationSamplingRateLabel = new JLabel("Allocation Tracking");
        this.myAllocationSamplingRateLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
        this.myAllocationSamplingRateDropDown = new ProfilerCombobox();
        ((MemoryProfilerStage)this.getStage()).getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADING_CAPTURE, this::captureObjectChanged).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE, this::captureObjectFinishedLoading).onChange((Enum)MemoryProfilerAspect.TRACKING_ENABLED, this::allocationTrackingChanged).onChange((Enum)MemoryProfilerAspect.CURRENT_CAPTURE_ELAPSED_TIME, this::updateCaptureElapsedTime).onChange((Enum)MemoryProfilerAspect.CURRENT_HEAP_CONTENTS, this::updateCaptureInfoMessage);
        this.captureObjectChanged();
        this.allocationTrackingChanged();
        this.buildContextMenu();
    }

    @Override
    public boolean isToolbarVisible() {
        return !((MemoryProfilerStage)this.getStage()).isMemoryCaptureOnly();
    }

    @VisibleForTesting
    JButton getGarbageCollectionButtion() {
        return this.myForceGarbageCollectionButton;
    }

    @VisibleForTesting
    JButton getHeapDumpButton() {
        return this.myHeapDumpButton;
    }

    @VisibleForTesting
    JButton getAllocationButton() {
        return this.myAllocationButton;
    }

    @VisibleForTesting
    JLabel getAllocationCaptureElaspedTimeLabel() {
        return this.myCaptureElapsedTime;
    }

    @VisibleForTesting
    JComboBox getAllocationSamplingRateDropDown() {
        return this.myAllocationSamplingRateDropDown;
    }

    @VisibleForTesting
    JLabel getAllocationSamplingRateLabel() {
        return this.myAllocationSamplingRateLabel;
    }

    @VisibleForTesting
    DurationDataRenderer<GcDurationData> getGcDurationDataRenderer() {
        return this.myGcDurationDataRenderer;
    }

    @VisibleForTesting
    DurationDataRenderer<AllocationSamplingRateDurationData> getAllocationSamplingRateRenderer() {
        return this.myAllocationSamplingRateRenderer;
    }

    @Override
    public JComponent getToolbar() {
        JPanel toolBar = new JPanel(ProfilerLayout.createToolbarLayout());
        toolBar.add(this.myForceGarbageCollectionButton);
        toolBar.add(this.myHeapDumpButton);
        if (((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking() && ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isLiveAllocationsSamplingEnabled()) {
            JComboBoxView<MemoryProfilerStage.LiveAllocationSamplingMode, MemoryProfilerAspect> sampleRateComboView = new JComboBoxView<MemoryProfilerStage.LiveAllocationSamplingMode, MemoryProfilerAspect>(this.myAllocationSamplingRateDropDown, ((MemoryProfilerStage)this.getStage()).getAspect(), MemoryProfilerAspect.LIVE_ALLOCATION_SAMPLING_MODE, ((MemoryProfilerStage)this.getStage())::getSupportedLiveAllocationSamplingMode, ((MemoryProfilerStage)this.getStage())::getLiveAllocationSamplingMode, ((MemoryProfilerStage)this.getStage())::requestLiveAllocationSamplingModeUpdate);
            sampleRateComboView.bind();
            this.myAllocationSamplingRateDropDown.setRenderer(new LiveAllocationSamplingModeRenderer());
            toolBar.add(this.myAllocationSamplingRateLabel);
            toolBar.add(this.myAllocationSamplingRateDropDown);
        } else {
            toolBar.add(this.myAllocationButton);
            toolBar.add(this.myCaptureElapsedTime);
        }
        StudioProfilers profilers = ((MemoryProfilerStage)this.getStage()).getStudioProfilers();
        Runnable toggleButtons = () -> {
            boolean isAlive = profilers.getSessionsManager().isSessionAlive();
            this.myForceGarbageCollectionButton.setEnabled(isAlive);
            this.myHeapDumpButton.setEnabled(isAlive);
            this.myAllocationButton.setEnabled(isAlive);
            this.myAllocationSamplingRateDropDown.setEnabled(isAlive);
        };
        profilers.getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, toggleButtons);
        toggleButtons.run();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolBar, "West");
        return panel;
    }

    @VisibleForTesting
    @NotNull
    public Splitter getMainSplitter() {
        return this.myMainSplitter;
    }

    @VisibleForTesting
    @NotNull
    public Splitter getChartCaptureSplitter() {
        return this.myChartCaptureSplitter;
    }

    @VisibleForTesting
    @NotNull
    public JPanel getCapturePanel() {
        return this.myCapturePanel;
    }

    @VisibleForTesting
    @NotNull
    MemoryCaptureView getCaptureView() {
        return this.myCaptureView;
    }

    @VisibleForTesting
    @NotNull
    MemoryHeapView getHeapView() {
        return this.myHeapView;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassGrouping getClassGrouping() {
        return this.myClassGrouping;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassifierView getClassifierView() {
        return this.myClassifierView;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassSetView getClassSetView() {
        return this.myClassSetView;
    }

    @VisibleForTesting
    @NotNull
    MemoryInstanceDetailsView getInstanceDetailsView() {
        return this.myInstanceDetailsView;
    }

    @VisibleForTesting
    @Nullable
    SelectionComponent getSelectionComponent() {
        return this.mySelectionComponent;
    }

    @VisibleForTesting
    @NotNull
    JLabel getCaptureElapsedTimeLabel() {
        return this.myCaptureElapsedTime;
    }

    @VisibleForTesting
    @NotNull
    JLabel getCaptureInfoMessage() {
        return this.myCaptureInfoMessage;
    }

    private void allocationTrackingChanged() {
        if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations()) {
            this.myAllocationButton.setText(STOP_TEXT);
            this.myAllocationButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.STOP_RECORDING));
            this.myAllocationButton.setToolTipText("Stop recording");
            this.myCaptureElapsedTime.setText(TimeFormatter.getSemiSimplifiedClockString((long)0L));
        } else {
            this.myCaptureElapsedTime.setText("");
            this.myAllocationButton.setText(RECORD_TEXT);
            this.myAllocationButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.RECORD));
            this.myAllocationButton.setToolTipText("Record memory allocations");
        }
    }

    private void updateCaptureElapsedTime() {
        if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations() && !((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            long elapsedTimeUs = TimeUnit.NANOSECONDS.toMicros(((MemoryProfilerStage)this.getStage()).getAllocationTrackingElapsedTimeNs());
            this.myCaptureElapsedTime.setText(TimeFormatter.getSemiSimplifiedClockString((long)elapsedTimeUs));
        }
    }

    private void updateCaptureInfoMessage() {
        String infoMessage;
        CaptureObject capture = ((MemoryProfilerStage)this.getStage()).getSelectedCapture();
        String string = infoMessage = capture == null ? null : capture.getInfoMessage();
        if (infoMessage != null) {
            this.myCaptureInfoMessage.setVisible(true);
            this.myCaptureInfoMessage.setText(infoMessage);
            this.myCaptureInfoMessage.setToolTipText(infoMessage);
        } else {
            this.myCaptureInfoMessage.setVisible(false);
        }
    }

    @NotNull
    private JPanel buildMonitorUi() {
        StudioProfilers profilers = ((MemoryProfilerStage)this.getStage()).getStudioProfilers();
        ProfilerTimeline timeline = profilers.getTimeline();
        Range viewRange = this.getTimeline().getViewRange();
        this.mySelectionComponent = new SelectionComponent(((MemoryProfilerStage)this.getStage()).getSelectionModel(), timeline.getViewRange());
        this.mySelectionComponent.setCursorSetter(ProfilerLayeredPane::setCursorOnProfilerLayeredPane);
        RangeTooltipComponent tooltip = new RangeTooltipComponent(timeline.getTooltipRange(), timeline.getViewRange(), timeline.getDataRange(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> this.mySelectionComponent.shouldShowSeekComponent());
        TabularLayout layout = new TabularLayout("*");
        JBPanel panel = new JBPanel((LayoutManager)layout);
        panel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        panel.add((Component)tooltip, new TabularLayout.Constraint(0, 0, 2, 1));
        ProfilerScrollbar sb = new ProfilerScrollbar(timeline, (JComponent)panel);
        panel.add((Component)((Object)sb), new TabularLayout.Constraint(3, 0));
        JComponent timeAxis = this.buildTimeAxis(profilers);
        panel.add((Component)timeAxis, new TabularLayout.Constraint(2, 0));
        EventMonitorView eventsView = new EventMonitorView(this.getProfilersView(), ((MemoryProfilerStage)this.getStage()).getEventMonitor());
        panel.add((Component)eventsView.getComponent(), new TabularLayout.Constraint(0, 0));
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
        JLabel label = new JLabel(((MemoryProfilerStage)this.getStage()).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        DetailedMemoryUsage memoryUsage = ((MemoryProfilerStage)this.getStage()).getDetailedMemoryUsage();
        LineChart lineChart = new LineChart((LineChartModel)memoryUsage);
        if (((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_JAVA_CAPTURED, memoryUsage.getJavaSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_NATIVE_CAPTURED, memoryUsage.getNativeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_GRAPHICS_CAPTURED, memoryUsage.getGraphicsSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_STACK_CAPTURED, memoryUsage.getStackSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_CODE_CAPTURED, memoryUsage.getCodeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_OTHERS_CAPTURED, memoryUsage.getOtherSeries());
            lineChart.configure(memoryUsage.getObjectsSeries(), new LineConfig(ProfilerColors.MEMORY_OBJECTS_CAPTURED).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        } else {
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_JAVA, memoryUsage.getJavaSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_NATIVE, memoryUsage.getNativeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_GRAPHICS, memoryUsage.getGraphicsSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_STACK, memoryUsage.getStackSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_CODE, memoryUsage.getCodeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_OTHERS, memoryUsage.getOtherSeries());
            lineChart.configure(memoryUsage.getObjectsSeries(), new LineConfig(ProfilerColors.MEMORY_OBJECTS).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        }
        lineChart.configure(memoryUsage.getTotalMemorySeries(), new LineConfig(new Color(0, 0, 0, 0)));
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChart.setTopPadding(ProfilerLayout.Y_AXIS_TOP_MARGIN);
        lineChart.setFillEndGap(true);
        this.myGcDurationDataRenderer = new DurationDataRenderer.Builder(memoryUsage.getGcDurations(), Color.BLACK).setIcon(StudioIcons.Profiler.Events.GARBAGE_EVENT).setLabelOffsets((float)(-StudioIcons.Profiler.Events.GARBAGE_EVENT.getIconWidth()) / 2.0f, (float)StudioIcons.Profiler.Events.GARBAGE_EVENT.getIconHeight() / 2.0f).setHostInsets(new Insets(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0)).setHoverHandler(arg_0 -> ((MemoryProfilerStage)this.getStage()).getTooltipLegends().getGcDurationLegend().setPickData(arg_0)).setClickRegionPadding(0, 0).build();
        lineChart.addCustomRenderer(this.myGcDurationDataRenderer);
        JBPanel overlayPanel = new JBPanel((LayoutManager)new BorderLayout());
        overlayPanel.setOpaque(false);
        overlayPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        OverlayComponent overlay = new OverlayComponent((Component)this.mySelectionComponent);
        overlay.addDurationDataRenderer(this.myGcDurationDataRenderer);
        overlayPanel.add((Component)overlay, "Center");
        if (!((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            DurationDataRenderer allocationRenderer = new DurationDataRenderer.Builder(((MemoryProfilerStage)this.getStage()).getAllocationInfosDurations(), Color.LIGHT_GRAY).setDurationBg(ProfilerColors.MEMORY_ALLOC_BG).setLabelColors(Color.DARK_GRAY, Color.GRAY, Color.lightGray, Color.WHITE).setLabelProvider(data -> String.format("Allocation record (%s)", data.getDurationUs() == Long.MAX_VALUE ? "in progress" : TimeAxisFormatter.DEFAULT.getFormattedString(viewRange.getLength(), (double)data.getDurationUs(), true))).build();
            allocationRenderer.addCustomLineConfig(memoryUsage.getJavaSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getJavaSeries())).setColor(ProfilerColors.MEMORY_JAVA_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getNativeSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getNativeSeries())).setColor(ProfilerColors.MEMORY_NATIVE_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getGraphicsSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getGraphicsSeries())).setColor(ProfilerColors.MEMORY_GRAPHICS_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getStackSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getStackSeries())).setColor(ProfilerColors.MEMORY_STACK_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getCodeSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getCodeSeries())).setColor(ProfilerColors.MEMORY_CODE_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getOtherSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getOtherSeries())).setColor(ProfilerColors.MEMORY_OTHERS_CAPTURED));
            lineChart.addCustomRenderer((LineChartCustomRenderer)allocationRenderer);
            overlay.addDurationDataRenderer(allocationRenderer);
        } else if (((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isLiveAllocationsSamplingEnabled()) {
            this.myAllocationSamplingRateRenderer = new DurationDataRenderer.Builder(((MemoryProfilerStage)this.getStage()).getAllocationSamplingRateDurations(), Color.BLACK).setDurationBg(ProfilerColors.DEFAULT_STAGE_BACKGROUND).setIconMapper(durationData -> {
                MemoryProfilerStage.LiveAllocationSamplingMode mode = MemoryProfilerStage.LiveAllocationSamplingMode.getModeFromFrequency(durationData.getCurrentRateEvent().getSamplingRate().getSamplingNumInterval());
                return MemoryProfilerStageView.getIconForSamplingMode(mode);
            }).setLabelOffsets((float)(-StudioIcons.Profiler.Events.ALLOCATION_TRACKING_NONE.getIconWidth()) / 2.0f, (float)StudioIcons.Profiler.Events.ALLOCATION_TRACKING_NONE.getIconHeight() / 2.0f).setHostInsets(new Insets(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0)).setClickRegionPadding(0, 0).setHoverHandler(arg_0 -> ((MemoryProfilerStage)this.getStage()).getTooltipLegends().getSamplingRateDurationLegend().setPickData(arg_0)).build();
            lineChart.addCustomRenderer(this.myAllocationSamplingRateRenderer);
            overlay.addDurationDataRenderer(this.myAllocationSamplingRateRenderer);
        }
        DurationDataRenderer heapDumpRenderer = new DurationDataRenderer.Builder(((MemoryProfilerStage)this.getStage()).getHeapDumpSampleDurations(), Color.DARK_GRAY).setDurationBg(ProfilerColors.MEMORY_HEAP_DUMP_BG).setLabelColors(Color.DARK_GRAY, Color.GRAY, Color.lightGray, Color.WHITE).setLabelProvider(data -> String.format("Dump (%s)", data.getDurationUs() == Long.MAX_VALUE ? "in progress" : TimeAxisFormatter.DEFAULT.getFormattedString(viewRange.getLength(), (double)data.getDurationUs(), true))).build();
        for (RangedContinuousSeries series : memoryUsage.getSeries()) {
            LineConfig config = lineChart.getLineConfig(series);
            int gray = (config.getColor().getBlue() + config.getColor().getRed() + config.getColor().getGreen()) / 3;
            LineConfig newConfig = LineConfig.copyOf((LineConfig)config).setColor((Color)Gray.get((int)gray));
            heapDumpRenderer.addCustomLineConfig(series, newConfig);
        }
        lineChart.addCustomRenderer((LineChartCustomRenderer)heapDumpRenderer);
        overlay.addDurationDataRenderer(heapDumpRenderer);
        overlay.addMouseListener((MouseListener)new ProfilerTooltipMouseAdapter((Stage)((Object)this.getStage()), () -> new MemoryUsageTooltip((MemoryProfilerStage)this.getStage())));
        overlayPanel.addMouseListener(new ProfilerTooltipMouseAdapter((Stage)((Object)this.getStage()), () -> new MemoryUsageTooltip((MemoryProfilerStage)this.getStage())));
        eventsView.registerTooltip(tooltip, (Stage)((Object)this.getStage()));
        tooltip.registerListenersOn((JComponent)overlay);
        tooltip.registerListenersOn((JComponent)overlayPanel);
        lineChartPanel.add((Component)lineChart, "Center");
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent memoryAxis = new AxisComponent(((MemoryProfilerStage)this.getStage()).getMemoryAxis(), AxisComponent.AxisOrientation.RIGHT);
        memoryAxis.setShowAxisLine(false);
        memoryAxis.setShowMax(true);
        memoryAxis.setShowUnitAtMax(true);
        memoryAxis.setHideTickAtMin(true);
        memoryAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        memoryAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)memoryAxis, "West");
        AxisComponent rightAxis = new AxisComponent(((MemoryProfilerStage)this.getStage()).getObjectsAxis(), AxisComponent.AxisOrientation.LEFT);
        rightAxis.setShowAxisLine(false);
        rightAxis.setShowMax(true);
        rightAxis.setShowUnitAtMax(true);
        rightAxis.setHideTickAtMin(true);
        rightAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        rightAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)rightAxis, "East");
        MemoryProfilerStage.MemoryStageLegends legends = ((MemoryProfilerStage)this.getStage()).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.configure((Legend)legends.getJavaLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getJavaSeries())));
        legend.configure((Legend)legends.getNativeLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getNativeSeries())));
        legend.configure((Legend)legends.getGraphicsLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getGraphicsSeries())));
        legend.configure((Legend)legends.getStackLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getStackSeries())));
        legend.configure((Legend)legends.getCodeLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getCodeSeries())));
        legend.configure((Legend)legends.getOtherLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getOtherSeries())));
        legend.configure((Legend)legends.getTotalLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getTotalMemorySeries())));
        legend.configure((Legend)legends.getObjectsLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getObjectsSeries())));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        legendPanel.add((Component)legend, "East");
        if (!((MemoryProfilerStage)this.getStage()).hasUserUsedMemoryCapture()) {
            this.installProfilingInstructions((JPanel)monitorPanel);
        }
        monitorPanel.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)overlayPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)this.mySelectionComponent, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)axisPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
        layout.setRowSizing(1, "*");
        panel.add((Component)monitorPanel, new TabularLayout.Constraint(1, 0));
        return panel;
    }

    static Icon getIconForSamplingMode(MemoryProfilerStage.LiveAllocationSamplingMode mode) {
        switch (mode) {
            case FULL: {
                return StudioIcons.Profiler.Events.ALLOCATION_TRACKING_FULL;
            }
            case SAMPLED: {
                return StudioIcons.Profiler.Events.ALLOCATION_TRACKING_SAMPLED;
            }
            case NONE: {
                return StudioIcons.Profiler.Events.ALLOCATION_TRACKING_NONE;
            }
        }
        throw new AssertionError((Object)("Unhandled sampling mode: " + (Object)((Object)mode)));
    }

    private void buildContextMenu() {
        if (this.mySelectionComponent == null) {
            return;
        }
        IdeProfilerComponents ideProfilerComponents = this.getIdeComponents();
        ContextMenuInstaller contextMenuInstaller = ideProfilerComponents.createContextMenuInstaller();
        ProfilerAction exportHeapDumpAction = new ProfilerAction.Builder("Export...").setIcon(AllIcons.ToolbarDecorator.Export).build();
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, exportHeapDumpAction, x -> this.getCaptureIntersectingWithMouseX(x) != null && this.getCaptureIntersectingWithMouseX(x).isExportable(), x -> this.getIdeComponents().createExportDialog().open(() -> "Export capture to file", () -> MemoryProfiler.generateCaptureFileName(), () -> this.getCaptureIntersectingWithMouseX(x).getExportableExtension(), file -> ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().saveFile((File)file, output -> {
            try {
                this.getCaptureIntersectingWithMouseX(x).saveToFile((OutputStream)output);
            }
            catch (IOException e) {
                MemoryProfilerStageView.getLogger().warn((Throwable)e);
            }
        }, null)));
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, ContextMenuItem.SEPARATOR);
        if (!((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, this.myAllocationAction);
            contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, this.myStopAllocationAction);
        }
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, this.myForceGarbageCollectionAction);
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, ContextMenuItem.SEPARATOR);
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, this.myHeapDumpAction);
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, ContextMenuItem.SEPARATOR);
        this.getProfilersView().installCommonMenuItems((JComponent)this.mySelectionComponent);
    }

    @Nullable
    private CaptureObject getCaptureIntersectingWithMouseX(int mouseXLocation) {
        assert (this.mySelectionComponent != null);
        Range range = this.getTimeline().getViewRange();
        double pos = (double)mouseXLocation / this.mySelectionComponent.getSize().getWidth() * range.getLength() + range.getMin();
        CaptureDurationData<? extends CaptureObject> durationData = ((MemoryProfilerStage)this.getStage()).getIntersectingCaptureDuration(new Range(pos, pos));
        return durationData == null ? null : durationData.getCaptureEntry().getCaptureObject();
    }

    private void installProfilingInstructions(@NotNull JPanel parent) {
        RenderInstruction[] instructions;
        assert (parent.getLayout().getClass() == TabularLayout.class);
        Icon heapDumpIcon = UIUtil.isUnderDarcula() ? IconUtil.darker((Icon)StudioIcons.Profiler.Toolbar.HEAP_DUMP, (int)6) : IconUtil.brighter((Icon)StudioIcons.Profiler.Toolbar.HEAP_DUMP, (int)6);
        FontMetrics metrics = UIUtilities.getFontMetrics((JComponent)parent, (Font)ProfilerFonts.H2_FONT);
        if (((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            RenderInstruction[] liveAllocInstructions;
            instructions = liveAllocInstructions = new RenderInstruction[]{new TextInstruction(metrics, "Select a range to inspect allocations"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(metrics, "or click "), new IconInstruction(heapDumpIcon, ProfilerLayout.PROFILING_INSTRUCTIONS_ICON_PADDING, null), new TextInstruction(metrics, " for a heap dump")};
        } else {
            RenderInstruction[] legacyInstructions = new RenderInstruction[]{new TextInstruction(metrics, "Click the record button to inspect allocations"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(metrics, "or "), new IconInstruction(heapDumpIcon, ProfilerLayout.PROFILING_INSTRUCTIONS_ICON_PADDING, null), new TextInstruction(metrics, " for a heap dump")};
            instructions = legacyInstructions;
        }
        InstructionsPanel panel = new InstructionsPanel.Builder(instructions).setEaseOut(((MemoryProfilerStage)this.getStage()).getInstructionsEaseOutModel(), instructionsPanel -> parent.remove((Component)instructionsPanel)).setBackgroundCornerRadius(ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER, ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER).build();
        parent.add((Component)panel, new TabularLayout.Constraint(0, 0));
    }

    @NotNull
    private JPanel buildCaptureUi() {
        JPanel capturePanel = new JPanel(new BorderLayout());
        JPanel toolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        toolbar.add(this.myCaptureView.getComponent());
        toolbar.add(this.myHeapView.getComponent());
        toolbar.add(this.myClassGrouping.getComponent());
        if (((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isLiveAllocationsSamplingEnabled()) {
            toolbar.add(this.myCaptureInfoMessage);
        }
        JPanel headingPanel = new JPanel(new BorderLayout());
        JPanel buttonToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        buttonToolbar.setBorder((Border)new JBEmptyBorder(3, 0, 0, 0));
        if (!((MemoryProfilerStage)this.getStage()).isMemoryCaptureOnly()) {
            buttonToolbar.add(this.getSelectionTimeLabel());
        }
        if (((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isMemoryCaptureFilterEnabled()) {
            CommonToggleButton button = FilterComponent.createFilterToggleButton();
            buttonToolbar.add((Component)new FlatSeparator());
            buttonToolbar.add((Component)button);
            FilterComponent filterComponent = new FilterComponent(ProfilerLayout.FILTER_TEXT_FIELD_WIDTH, 5, 250);
            filterComponent.getModel().setFilterHandler(((MemoryProfilerStage)this.getStage()).getFilterHandler());
            headingPanel.add((Component)filterComponent, "South");
            filterComponent.setVisible(false);
            filterComponent.setBorder((Border)new JBEmptyBorder(0, 4, 0, 0));
            FilterComponent.configureKeyBindingAndFocusBehaviors((JComponent)capturePanel, (FilterComponent)filterComponent, (JToggleButton)button);
        }
        headingPanel.add((Component)buttonToolbar, "East");
        headingPanel.add((Component)toolbar, "West");
        capturePanel.add((Component)headingPanel, "First");
        capturePanel.add((Component)this.myClassifierView.getComponent(), "Center");
        return capturePanel;
    }

    private void captureObjectChanged() {
        this.stopLoadingUi();
        this.myCaptureObject = ((MemoryProfilerStage)this.getStage()).getSelectedCapture();
        if (this.myCaptureObject == null) {
            boolean isAlive = ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getSessionsManager().isSessionAlive();
            this.myAllocationButton.setEnabled(isAlive);
            this.myHeapDumpButton.setEnabled(isAlive);
            this.myChartCaptureSplitter.setSecondComponent(null);
            return;
        }
        if (this.myCaptureObject.isDoneLoading()) {
            this.captureObjectFinishedLoading();
        } else {
            this.myAllocationButton.setEnabled(false);
            this.myHeapDumpButton.setEnabled(false);
            this.myCaptureLoadingPanel = this.getProfilersView().getIdeProfilerComponents().createLoadingPanel(-1);
            this.myCaptureLoadingPanel.setLoadingText("Fetching results");
            this.myCaptureLoadingPanel.startLoading();
            this.myChartCaptureSplitter.setSecondComponent(this.myCaptureLoadingPanel.getComponent());
        }
    }

    private void captureObjectFinishedLoading() {
        boolean isAlive = ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getSessionsManager().isSessionAlive();
        this.myAllocationButton.setEnabled(isAlive);
        if (this.mySelectionComponent != null) {
            this.mySelectionComponent.requestFocus();
        }
        this.myHeapDumpButton.setEnabled(isAlive);
        if (this.myCaptureObject != ((MemoryProfilerStage)this.getStage()).getSelectedCapture() || this.myCaptureObject == null) {
            return;
        }
        this.stopLoadingUi();
        this.myChartCaptureSplitter.setSecondComponent((JComponent)this.myCapturePanel);
    }

    private void stopLoadingUi() {
        if (this.myCaptureObject == null || this.myCaptureLoadingPanel == null) {
            return;
        }
        this.myCaptureLoadingPanel.stopLoading();
        this.myCaptureLoadingPanel = null;
        this.myChartCaptureSplitter.setSecondComponent(null);
    }

    private static void configureStackedFilledLine(LineChart chart, Color color, RangedContinuousSeries series) {
        chart.configure(series, new LineConfig(color).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
    }

    @NotNull
    static Icon getValueObjectIcon(@NotNull ValueObject valueObject) {
        if (valueObject instanceof FieldObject) {
            FieldObject field = (FieldObject)valueObject;
            if (field.getValueType() == ValueObject.ValueType.ARRAY) {
                return MemoryProfilerStageView.getStackedIcon(field.getAsInstance(), StudioIcons.Profiler.Overlays.ARRAY_STACK, AllIcons.Debugger.Db_array);
            }
            if (field.getValueType().getIsPrimitive()) {
                return AllIcons.Debugger.Db_primitive;
            }
            return MemoryProfilerStageView.getStackedIcon(field.getAsInstance(), StudioIcons.Profiler.Overlays.FIELD_STACK, PlatformIcons.FIELD_ICON);
        }
        if (valueObject instanceof ReferenceObject) {
            ReferenceObject referrer = (ReferenceObject)valueObject;
            if (referrer.getReferenceInstance().getIsRoot()) {
                return AllIcons.Hierarchy.Subtypes;
            }
            if (referrer.getReferenceInstance().getValueType() == ValueObject.ValueType.ARRAY) {
                return MemoryProfilerStageView.getStackedIcon(referrer.getReferenceInstance(), StudioIcons.Profiler.Overlays.ARRAY_STACK, AllIcons.Debugger.Db_array);
            }
            return MemoryProfilerStageView.getStackedIcon(referrer.getReferenceInstance(), StudioIcons.Profiler.Overlays.FIELD_STACK, PlatformIcons.FIELD_ICON);
        }
        if (valueObject instanceof InstanceObject) {
            return MemoryProfilerStageView.getStackedIcon((InstanceObject)valueObject, StudioIcons.Profiler.Overlays.INTERFACE_STACK, PlatformIcons.INTERFACE_ICON);
        }
        return PlatformIcons.INTERFACE_ICON;
    }

    private static Icon getStackedIcon(@Nullable InstanceObject instance, @NotNull Icon stackedIcon, @NotNull Icon nonStackedIcon) {
        return instance == null || instance.getCallStackDepth() == 0 ? nonStackedIcon : stackedIcon;
    }

    @VisibleForTesting
    static class LiveAllocationSamplingModeRenderer
    extends ProfilerComboboxCellRenderer<MemoryProfilerStage.LiveAllocationSamplingMode> {
        LiveAllocationSamplingModeRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, MemoryProfilerStage.LiveAllocationSamplingMode value, int index, boolean selected, boolean hasFocus) {
            this.append(value.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

