/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.memory.MemoryDataSeries;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class MemoryUsage
extends LineChartModel {
    @NotNull
    private final Range myMemoryRange = new Range(0.0, 0.0);
    @NotNull
    private final RangedContinuousSeries myTotalMemorySeries;

    public MemoryUsage(@NotNull StudioProfilers profilers) {
        this.myTotalMemorySeries = profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled() ? this.createRangedSeries(profilers, this.getTotalSeriesLabel(), this.myMemoryRange, 0, UnifiedEventDataSeries.fromFieldToDataExtractor(e -> e.getMemoryUsage().getTotalMem())) : this.createLegacyRangedSeries(profilers, this.getTotalSeriesLabel(), this.myMemoryRange, sample -> sample.getMemoryUsage().getTotalMem());
        this.add(this.myTotalMemorySeries);
    }

    protected RangedContinuousSeries createLegacyRangedSeries(@NotNull StudioProfilers profilers, @NotNull String name, @NotNull Range range, @NotNull Function<MemoryProfiler.MemoryData.MemorySample, Long> getter) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = profilers.getClient().getMemoryClient();
        MemoryDataSeries series = new MemoryDataSeries(client, profilers.getSession(), getter);
        return new RangedContinuousSeries(name, profilers.getTimeline().getViewRange(), range, (DataSeries)series);
    }

    protected RangedContinuousSeries createRangedSeries(@NotNull StudioProfilers profilers, @NotNull String name, @NotNull Range range, int groupId, Function<List<Common.Event>, Stream<SeriesData<Long>>> dataExtractor) {
        TransportServiceGrpc.TransportServiceBlockingStub client = profilers.getClient().getTransportClient();
        UnifiedEventDataSeries series = new UnifiedEventDataSeries(client, profilers.getSession().getStreamId(), profilers.getSession().getPid(), Common.Event.Kind.MEMORY_USAGE, groupId, dataExtractor);
        return new RangedContinuousSeries(name, profilers.getTimeline().getViewRange(), range, (DataSeries)series);
    }

    @NotNull
    public Range getMemoryRange() {
        return this.myMemoryRange;
    }

    @NotNull
    public RangedContinuousSeries getTotalMemorySeries() {
        return this.myTotalMemorySeries;
    }

    protected String getTotalSeriesLabel() {
        return "";
    }
}

