/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfilerStageView;
import com.android.tools.profilers.memory.MemoryUsageTooltip;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class MemoryUsageTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final MemoryUsageTooltip myTooltip;

    MemoryUsageTooltipView(@NotNull MemoryProfilerStageView view, @NotNull MemoryUsageTooltip tooltip) {
        super(view.getTimeline());
        this.myTooltip = tooltip;
    }

    @Override
    @NotNull
    protected JComponent createTooltip() {
        MemoryProfilerStage.MemoryStageLegends legends = this.myTooltip.getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setVerticalPadding(0).setOrientation(LegendComponent.Orientation.VERTICAL).build();
        if (this.myTooltip.useLiveAllocationTracking()) {
            legend.configure((Legend)legends.getJavaLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_JAVA_CAPTURED));
            legend.configure((Legend)legends.getNativeLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_NATIVE_CAPTURED));
            legend.configure((Legend)legends.getGraphicsLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_GRAPHICS_CAPTURED));
            legend.configure((Legend)legends.getStackLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_STACK_CAPTURED));
            legend.configure((Legend)legends.getCodeLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_CODE_CAPTURED));
            legend.configure((Legend)legends.getOtherLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_OTHERS_CAPTURED));
            legend.configure((Legend)legends.getObjectsLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.MEMORY_OBJECTS_CAPTURED));
            legend.configure(legends.getGcDurationLegend(), new LegendConfig(LegendConfig.IconType.NONE, ProfilerColors.MEMORY_OBJECTS_CAPTURED));
            legend.configure(legends.getSamplingRateDurationLegend(), new LegendConfig(legendStr -> MemoryProfilerStageView.getIconForSamplingMode(MemoryProfilerStage.LiveAllocationSamplingMode.getModeFromDisplayName(legendStr)), ProfilerColors.TRANSPARENT_COLOR));
        } else {
            legend.configure((Legend)legends.getJavaLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_JAVA));
            legend.configure((Legend)legends.getNativeLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_NATIVE));
            legend.configure((Legend)legends.getGraphicsLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_GRAPHICS));
            legend.configure((Legend)legends.getStackLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_STACK));
            legend.configure((Legend)legends.getCodeLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_CODE));
            legend.configure((Legend)legends.getOtherLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.MEMORY_OTHERS));
            legend.configure((Legend)legends.getObjectsLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.MEMORY_OBJECTS));
        }
        legend.configure((Legend)legends.getTotalLegend(), new LegendConfig(LegendConfig.IconType.NONE, ProfilerColors.DEFAULT_STAGE_BACKGROUND));
        return legend;
    }
}

