/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ClassDb {
    public static final String JAVA_LANG_STRING = "java.lang.String";
    public static final String JAVA_LANG_CLASS = "java.lang.Class";
    private final Map<Long, Map<String, ClassEntry>> myClassEntries = new HashMap<Long, Map<String, ClassEntry>>();
    private final Map<Long, ClassEntry> myTagMap = new HashMap<Long, ClassEntry>();

    public void clear() {
        this.myClassEntries.clear();
        this.myTagMap.clear();
    }

    @NotNull
    public ClassEntry registerClass(long classLoaderId, @NotNull String className) {
        return this.myClassEntries.computeIfAbsent(classLoaderId, id -> new HashMap()).computeIfAbsent(className, ClassEntry::new);
    }

    @NotNull
    public ClassEntry registerClass(long classLoaderId, @NotNull String className, long tag) {
        ClassEntry entry = this.registerClass(classLoaderId, className);
        this.myTagMap.put(tag, entry);
        return entry;
    }

    public boolean containsClassEntry(long classLoaderId, @NotNull String className) {
        return this.myClassEntries.containsKey(classLoaderId) && this.myClassEntries.get(classLoaderId).containsKey(className);
    }

    @NotNull
    public ClassEntry getEntry(long tag) {
        assert (this.myTagMap.containsKey(tag));
        return this.myTagMap.get(tag);
    }

    public static class ClassEntry {
        @NotNull
        private final String myClassName;
        @NotNull
        private final String myPackageName;
        @NotNull
        private final String mySimpleClassName;
        @NotNull
        private final String[] mySplitPackageName;

        public ClassEntry(@NotNull String className) {
            this.myClassName = className;
            int lastIndexOfDot = this.myClassName.lastIndexOf(46);
            this.myPackageName = lastIndexOfDot > 0 ? this.myClassName.substring(0, lastIndexOfDot) : "";
            this.mySimpleClassName = this.myClassName.substring(lastIndexOfDot + 1);
            this.mySplitPackageName = this.myPackageName.isEmpty() ? new String[]{} : this.myPackageName.split("\\.");
        }

        @NotNull
        public String getClassName() {
            return this.myClassName;
        }

        @NotNull
        public String getPackageName() {
            return this.myPackageName;
        }

        @NotNull
        public String[] getSplitPackageName() {
            return this.mySplitPackageName;
        }

        @NotNull
        public String getSimpleClassName() {
            return this.mySimpleClassName;
        }

        public int hashCode() {
            return this.myClassName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ClassEntry && this.myClassName.equals(((ClassEntry)obj).myClassName);
        }
    }
}

