/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassSet
extends ClassifierSet {
    public static final ClassSet EMPTY_SET = new ClassSet(new ClassDb.ClassEntry("null"));
    @NotNull
    private final ClassDb.ClassEntry myClassEntry;

    @NotNull
    public static ClassifierSet.Classifier createDefaultClassifier() {
        return new ClassClassifier();
    }

    public ClassSet(@NotNull ClassDb.ClassEntry classEntry) {
        super(classEntry.getSimpleClassName());
        this.myClassEntry = classEntry;
    }

    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        return this.myClassEntry;
    }

    @Override
    @NotNull
    public ClassifierSet.Classifier createSubClassifier() {
        return ClassifierSet.Classifier.IDENTITY_CLASSIFIER;
    }

    @Override
    protected void applyFilter(@NotNull Filter filter, boolean hasMatchedAncestor, boolean filterChanged) {
        if (!filterChanged && !this.myNeedsRefiltering) {
            return;
        }
        this.myIsMatched = this.matches(filter);
        this.myFilterMatchCount = this.myIsMatched ? 1 : 0;
        this.myIsFiltered = filter != null && !this.myIsMatched && !hasMatchedAncestor;
        this.myNeedsRefiltering = false;
    }

    @Override
    protected boolean matches(@NotNull Filter filter) {
        return filter.matches(this.myClassEntry.getClassName());
    }

    private static final class ClassClassifier
    extends ClassifierSet.Classifier {
        @NotNull
        private final Map<ClassDb.ClassEntry, ClassSet> myClassMap = new LinkedHashMap<ClassDb.ClassEntry, ClassSet>();

        private ClassClassifier() {
        }

        @Override
        @Nullable
        public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
            ClassDb.ClassEntry classEntry = instance.getClassEntry();
            ClassSet classSet = this.myClassMap.get(classEntry);
            if (classSet == null && createIfAbsent) {
                classSet = new ClassSet(classEntry);
                this.myClassMap.put(classEntry, classSet);
            }
            return classSet;
        }

        @Override
        @NotNull
        public List<ClassifierSet> getFilteredClassifierSets() {
            return this.myClassMap.values().stream().filter(child -> !child.getIsFiltered()).collect(Collectors.toList());
        }

        @Override
        @NotNull
        protected List<ClassifierSet> getAllClassifierSets() {
            return this.myClassMap.values().stream().collect(Collectors.toList());
        }
    }
}

