/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public abstract class ClassifierSet
implements MemoryObject {
    @Nullable
    private String myName;
    @Nullable
    private Supplier<String> myNameSupplier = null;
    @NotNull
    protected final Set<InstanceObject> mySnapshotInstances = new LinkedHashSet<InstanceObject>(0);
    @NotNull
    protected final Set<InstanceObject> myDeltaInstances = new LinkedHashSet<InstanceObject>(0);
    @Nullable
    protected Classifier myClassifier = null;
    private int myObjectSetCount = 0;
    private int myFilteredObjectSetCount = 0;
    private int mySnapshotObjectCount = 0;
    private int myDeltaAllocations = 0;
    private int myDeltaDeallocations = 0;
    private long myTotalNativeSize = 0L;
    private long myTotalShallowSize = 0L;
    private long myTotalRetainedSize = 0L;
    private int myInstancesWithStackInfoCount = 0;
    protected int myFilterMatchCount = 0;
    protected boolean myIsFiltered;
    protected boolean myIsMatched;
    protected boolean myNeedsRefiltering;

    public ClassifierSet(@NotNull String name) {
        this.myName = name;
    }

    public ClassifierSet(@NotNull Supplier<String> nameSupplier) {
        this.myNameSupplier = nameSupplier;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            assert (this.myNameSupplier != null);
            this.myName = this.myNameSupplier.get();
        }
        return this.myName;
    }

    public boolean isEmpty() {
        return this.mySnapshotObjectCount == 0 && this.myDeltaAllocations == 0 && this.myDeltaDeallocations == 0;
    }

    public int getTotalObjectCount() {
        return this.mySnapshotObjectCount + this.myDeltaAllocations - this.myDeltaDeallocations;
    }

    public int getTotalObjectSetCount() {
        return this.myObjectSetCount;
    }

    public int getFilteredObjectSetCount() {
        return this.myFilteredObjectSetCount;
    }

    public int getDeltaAllocationCount() {
        return this.myDeltaAllocations;
    }

    public int getDeltaDeallocationCount() {
        return this.myDeltaDeallocations;
    }

    public long getTotalRetainedSize() {
        return this.myTotalRetainedSize;
    }

    public long getTotalShallowSize() {
        return this.myTotalShallowSize;
    }

    public long getTotalNativeSize() {
        return this.myTotalNativeSize;
    }

    public int getFilterMatchCount() {
        return this.myFilterMatchCount;
    }

    public void addSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            this.myClassifier.getClassifierSet(instanceObject, true).addSnapshotInstanceObject(instanceObject);
        } else {
            assert (!this.mySnapshotInstances.contains(instanceObject));
            this.mySnapshotInstances.add(instanceObject);
        }
        ++this.mySnapshotObjectCount;
        this.myTotalNativeSize += instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize();
        this.myTotalShallowSize += instanceObject.getShallowSize() == -1 ? 0L : (long)instanceObject.getShallowSize();
        this.myTotalRetainedSize += instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize();
        if (instanceObject.getCallStackDepth() > 0) {
            ++this.myInstancesWithStackInfoCount;
        }
        this.myNeedsRefiltering = true;
    }

    public void removeSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            ClassifierSet classifierSet = this.myClassifier.getClassifierSet(instanceObject, false);
            assert (classifierSet != null);
            classifierSet.removeSnapshotInstanceObject(instanceObject);
        } else {
            assert (this.mySnapshotInstances.contains(instanceObject));
            this.mySnapshotInstances.remove(instanceObject);
        }
        --this.mySnapshotObjectCount;
        this.myTotalNativeSize -= instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize();
        this.myTotalShallowSize -= instanceObject.getShallowSize() == -1 ? 0L : (long)instanceObject.getShallowSize();
        this.myTotalRetainedSize -= instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize();
        if (instanceObject.getCallStackDepth() > 0) {
            --this.myInstancesWithStackInfoCount;
        }
        this.myNeedsRefiltering = true;
    }

    public boolean addDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.addDeltaInstanceInformation(instanceObject, true);
    }

    public boolean freeDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.addDeltaInstanceInformation(instanceObject, false);
    }

    public boolean removeAddedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.removeDeltaInstanceInformation(instanceObject, true);
    }

    public boolean removeFreedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.removeDeltaInstanceInformation(instanceObject, false);
    }

    private boolean addDeltaInstanceInformation(@NotNull InstanceObject instanceObject, boolean isAllocation) {
        boolean instanceAdded = false;
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            instanceAdded = this.myClassifier.getClassifierSet(instanceObject, true).addDeltaInstanceInformation(instanceObject, isAllocation);
        } else if (!this.myDeltaInstances.contains(instanceObject)) {
            instanceAdded = true;
            this.myDeltaInstances.add(instanceObject);
        }
        if (isAllocation) {
            ++this.myDeltaAllocations;
        } else {
            ++this.myDeltaDeallocations;
        }
        this.myTotalNativeSize += (long)(isAllocation ? 1 : -1) * (instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize());
        this.myTotalShallowSize += (long)((isAllocation ? 1 : -1) * (instanceObject.getShallowSize() == -1 ? 0 : instanceObject.getShallowSize()));
        this.myTotalRetainedSize += (long)(isAllocation ? 1 : -1) * (instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize());
        if (instanceAdded && instanceObject.getCallStackDepth() > 0) {
            ++this.myInstancesWithStackInfoCount;
            this.myNeedsRefiltering = true;
        }
        return instanceAdded;
    }

    private boolean removeDeltaInstanceInformation(@NotNull InstanceObject instanceObject, boolean isAllocation) {
        boolean instanceRemoved = false;
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            ClassifierSet classifierSet = this.myClassifier.getClassifierSet(instanceObject, false);
            assert (classifierSet != null);
            instanceRemoved = classifierSet.removeDeltaInstanceInformation(instanceObject, isAllocation);
        } else if (!instanceObject.hasTimeData() && this.myDeltaInstances.contains(instanceObject)) {
            this.myDeltaInstances.remove(instanceObject);
            instanceRemoved = true;
        }
        if (isAllocation) {
            --this.myDeltaAllocations;
        } else {
            --this.myDeltaDeallocations;
        }
        this.myTotalNativeSize -= (long)(isAllocation ? 1 : -1) * (instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize());
        this.myTotalShallowSize -= (long)((isAllocation ? 1 : -1) * (instanceObject.getShallowSize() == -1 ? 0 : instanceObject.getShallowSize()));
        this.myTotalRetainedSize -= (long)(isAllocation ? 1 : -1) * (instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize());
        if (instanceRemoved && instanceObject.getCallStackDepth() > 0) {
            --this.myInstancesWithStackInfoCount;
            this.myNeedsRefiltering = true;
        }
        return instanceRemoved;
    }

    public void clearClassifierSets() {
        this.mySnapshotInstances.clear();
        this.myDeltaInstances.clear();
        this.myClassifier = this.createSubClassifier();
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myObjectSetCount = 0;
        this.myFilteredObjectSetCount = 0;
        this.myFilterMatchCount = 0;
    }

    public int getInstancesCount() {
        if (this.myClassifier == null) {
            HashSet<InstanceObject> total = new HashSet<InstanceObject>(this.mySnapshotInstances);
            total.addAll(this.myDeltaInstances);
            return total.size();
        }
        return (int)this.getInstancesStream().count();
    }

    @NotNull
    public Stream<InstanceObject> getInstancesStream() {
        Stream<InstanceObject> total = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).distinct();
        if (this.myClassifier == null) {
            return total;
        }
        return Stream.concat(this.myClassifier.getAllClassifierSets().stream().flatMap(ClassifierSet::getInstancesStream), total);
    }

    @NotNull
    protected Stream<InstanceObject> getDeltaInstanceStream() {
        if (this.myClassifier == null) {
            return this.myDeltaInstances.stream();
        }
        return Stream.concat(this.myClassifier.getAllClassifierSets().stream().flatMap(ClassifierSet::getDeltaInstanceStream), this.myDeltaInstances.stream());
    }

    @NotNull
    protected Stream<InstanceObject> getSnapshotInstanceStream() {
        if (this.myClassifier == null) {
            return this.mySnapshotInstances.stream();
        }
        return Stream.concat(this.myClassifier.getAllClassifierSets().stream().flatMap(ClassifierSet::getSnapshotInstanceStream), this.mySnapshotInstances.stream());
    }

    public boolean hasStackInfo() {
        return this.myInstancesWithStackInfoCount > 0;
    }

    @NotNull
    public List<ClassifierSet> getChildrenClassifierSets() {
        this.ensurePartition();
        assert (this.myClassifier != null);
        return this.myClassifier.getFilteredClassifierSets();
    }

    @Nullable
    public ClassifierSet findContainingClassifierSet(@NotNull InstanceObject target) {
        boolean instancesContainsTarget = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).filter(instance -> target.equals(instance)).findAny().isPresent();
        if (instancesContainsTarget && this.myClassifier != null) {
            return this;
        }
        if (instancesContainsTarget || this.myClassifier != null) {
            List<ClassifierSet> childrenClassifierSets = this.getChildrenClassifierSets();
            boolean stillContainsTarget = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).filter(instance -> target.equals(instance)).findAny().isPresent();
            if (instancesContainsTarget && stillContainsTarget) {
                return this;
            }
            for (ClassifierSet set : childrenClassifierSets) {
                ClassifierSet result = set.findContainingClassifierSet(target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public boolean isSupersetOf(@NotNull ClassifierSet targetSet) {
        if (this.getInstancesCount() < targetSet.getInstancesCount()) {
            return false;
        }
        Set instances = this.getInstancesStream().collect(Collectors.toSet());
        return targetSet.getInstancesStream().allMatch(instances::contains);
    }

    protected void ensurePartition() {
        if (this.myClassifier == null) {
            this.myClassifier = this.createSubClassifier();
            this.myClassifier.partition(this.mySnapshotInstances, this.myDeltaInstances);
        }
    }

    @NotNull
    protected abstract Classifier createSubClassifier();

    public boolean getIsFiltered() {
        return this.isEmpty() || this.myIsFiltered;
    }

    public boolean getIsMatched() {
        return this.myIsMatched;
    }

    protected void applyFilter(@NotNull Filter filter, boolean hasMatchedAncestor, boolean filterChanged) {
        if (!filterChanged && !this.myNeedsRefiltering) {
            return;
        }
        this.myIsFiltered = true;
        this.ensurePartition();
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myObjectSetCount = this.myClassifier.getAllClassifierSets().size();
        this.myFilteredObjectSetCount = 0;
        this.myIsMatched = this.matches(filter);
        int n = this.myFilterMatchCount = this.myIsMatched ? 1 : 0;
        assert (this.myClassifier != null);
        for (ClassifierSet classifierSet : this.myClassifier.getAllClassifierSets()) {
            classifierSet.applyFilter(filter, hasMatchedAncestor || this.myIsMatched, filterChanged);
            this.myObjectSetCount += classifierSet.myObjectSetCount;
            if (classifierSet.getIsFiltered()) continue;
            this.myIsFiltered = false;
            this.mySnapshotObjectCount += classifierSet.mySnapshotObjectCount;
            this.myDeltaAllocations += classifierSet.myDeltaAllocations;
            this.myDeltaDeallocations += classifierSet.myDeltaDeallocations;
            this.myTotalShallowSize += classifierSet.myTotalShallowSize;
            this.myTotalNativeSize += classifierSet.myTotalNativeSize;
            this.myTotalRetainedSize += classifierSet.myTotalRetainedSize;
            this.myInstancesWithStackInfoCount += classifierSet.myInstancesWithStackInfoCount;
            this.myFilterMatchCount += classifierSet.myFilterMatchCount;
            ++this.myFilteredObjectSetCount;
        }
        this.myNeedsRefiltering = false;
    }

    protected boolean matches(@NotNull Filter filter) {
        return filter.matches(this.getName());
    }

    public static abstract class Classifier {
        public static final Classifier IDENTITY_CLASSIFIER = new Classifier(){

            @Override
            public boolean isTerminalClassifier() {
                return true;
            }

            @Override
            @NotNull
            public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
                throw new NotImplementedException();
            }

            @Override
            @NotNull
            public List<ClassifierSet> getFilteredClassifierSets() {
                return Collections.emptyList();
            }

            @Override
            @NotNull
            protected List<ClassifierSet> getAllClassifierSets() {
                return Collections.emptyList();
            }
        };

        public boolean isTerminalClassifier() {
            return false;
        }

        @Nullable
        public abstract ClassifierSet getClassifierSet(@NotNull InstanceObject var1, boolean var2);

        @NotNull
        public abstract List<ClassifierSet> getFilteredClassifierSets();

        @NotNull
        protected abstract List<ClassifierSet> getAllClassifierSets();

        public final void partition(@NotNull Collection<InstanceObject> snapshotInstances, @NotNull Collection<InstanceObject> deltaInstances) {
            if (this.isTerminalClassifier()) {
                return;
            }
            snapshotInstances.forEach(instance -> this.getClassifierSet((InstanceObject)instance, true).addSnapshotInstanceObject((InstanceObject)instance));
            deltaInstances.forEach(instance -> {
                if (instance.hasTimeData()) {
                    if (instance.hasAllocTime() && !snapshotInstances.contains(instance)) {
                        this.getClassifierSet((InstanceObject)instance, true).addDeltaInstanceObject((InstanceObject)instance);
                    }
                    if (instance.hasDeallocTime()) {
                        this.getClassifierSet((InstanceObject)instance, true).freeDeltaInstanceObject((InstanceObject)instance);
                    }
                } else {
                    this.getClassifierSet((InstanceObject)instance, true).addDeltaInstanceObject((InstanceObject)instance);
                }
            });
            snapshotInstances.clear();
            deltaInstances.clear();
        }
    }
}

