/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.ext.NativeRegistryPostProcessor;
import com.android.tools.perflib.heap.io.InMemoryBuffer;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.HeapDumpInstanceObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.proguard.ProguardMap;
import com.google.common.annotations.VisibleForTesting;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapDumpCaptureObject
implements CaptureObject {
    @NotNull
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final FeatureTracker myFeatureTracker;
    @NotNull
    private final Map<Integer, HeapSet> myHeapSets = new HashMap<Integer, HeapSet>();
    @NotNull
    private final Map<ClassObj, InstanceObject> myClassObjectIndex = new HashMap<ClassObj, InstanceObject>();
    @NotNull
    private final Map<Instance, InstanceObject> myInstanceIndex = new HashMap<Instance, InstanceObject>();
    @NotNull
    private final ClassDb myClassDb = new ClassDb();
    @NotNull
    private final MemoryProfiler.HeapDumpInfo myHeapDumpInfo;
    @Nullable
    private final ProguardMap myProguardMap;
    @Nullable
    private volatile Snapshot mySnapshot;
    private volatile boolean myIsLoadingError = false;
    private boolean myHasNativeAllocations;
    @NotNull
    private final MemoryProfilerStage myStage;

    public HeapDumpCaptureObject(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, @NotNull MemoryProfiler.HeapDumpInfo heapDumpInfo, @Nullable ProguardMap proguardMap, @NotNull FeatureTracker featureTracker, @NotNull MemoryProfilerStage stage) {
        this.myClient = client;
        this.mySession = session;
        this.myHeapDumpInfo = heapDumpInfo;
        this.myProguardMap = proguardMap;
        this.myFeatureTracker = featureTracker;
        this.myStage = stage;
    }

    @Override
    @NotNull
    public String getName() {
        return "Heap Dump";
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return "hprof";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) {
        MemoryProfiler.saveHeapDumpToFile(this.myClient, this.mySession, this.myHeapDumpInfo, outputStream, this.myFeatureTracker);
    }

    @VisibleForTesting
    @NotNull
    ClassDb getClassDb() {
        return this.myClassDb;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        Snapshot snapshot = this.mySnapshot;
        if (snapshot == null) {
            return Collections.emptyList();
        }
        return this.myHeapSets.values();
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        return this.myHeapSets.getOrDefault(heapId, null);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        Snapshot snapshot = this.mySnapshot;
        if (snapshot == null) {
            return Stream.empty();
        }
        return this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity());
    }

    @Override
    public long getStartTimeNs() {
        return this.myHeapDumpInfo.getStartTime();
    }

    @Override
    public long getEndTimeNs() {
        return this.myHeapDumpInfo.getEndTime();
    }

    public boolean getHasNativeAllocations() {
        return this.myHasNativeAllocations;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        HeapSet heapSet;
        MemoryProfiler.DumpDataResponse response;
        while ((response = this.myClient.getHeapDump(MemoryProfiler.DumpDataRequest.newBuilder().setSession(this.mySession).setDumpTime(this.myHeapDumpInfo.getStartTime()).build())).getStatus() != MemoryProfiler.DumpDataResponse.Status.SUCCESS) {
            if (response.getStatus() == MemoryProfiler.DumpDataResponse.Status.NOT_READY) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.myIsLoadingError = true;
                    return false;
                }
            }
            this.myIsLoadingError = true;
            return false;
        }
        InMemoryBuffer buffer = new InMemoryBuffer(response.getData().asReadOnlyByteBuffer());
        NativeRegistryPostProcessor nativeRegistryPostProcessor = new NativeRegistryPostProcessor();
        Snapshot snapshot = this.myProguardMap != null ? Snapshot.createSnapshot((DataBuffer)buffer, (ProguardMap)this.myProguardMap, Arrays.asList(nativeRegistryPostProcessor)) : Snapshot.createSnapshot((DataBuffer)buffer, (ProguardMap)new ProguardMap(), Arrays.asList(nativeRegistryPostProcessor));
        snapshot.computeDominators();
        this.myHasNativeAllocations = nativeRegistryPostProcessor.getHasNativeAllocations();
        this.mySnapshot = snapshot;
        HashMap<Heap, HeapSet> heapSets = new HashMap<Heap, HeapSet>(snapshot.getHeaps().size());
        InstanceObject javaLangClassObject = null;
        for (Heap heap : snapshot.getHeaps()) {
            ClassObj javaLangClass;
            HeapSet heapSet2 = new HeapSet(this, heap.getName(), heap.getId());
            heapSets.put(heap, heapSet2);
            if (javaLangClassObject != null || (javaLangClass = (ClassObj)heap.getClasses().stream().filter(classObj -> "java.lang.Class".equals(classObj.getClassName())).findFirst().orElse(null)) == null) continue;
            javaLangClassObject = this.createClassObjectInstance(null, javaLangClass);
        }
        InstanceObject finalJavaLangClassObject = javaLangClassObject;
        for (Heap heap : snapshot.getHeaps()) {
            heapSet = (HeapSet)heapSets.get(heap);
            heap.getClasses().forEach(classObj -> {
                InstanceObject classObject = this.createClassObjectInstance(finalJavaLangClassObject, (ClassObj)classObj);
                this.myInstanceIndex.put((Instance)classObj, classObject);
                heapSet.addDeltaInstanceObject(classObject);
            });
        }
        for (Heap heap : snapshot.getHeaps()) {
            heapSet = (HeapSet)heapSets.get(heap);
            heap.forEachInstance(instance -> {
                assert (!"java.lang.Class".equals(this.getName()));
                ClassObj classObj = instance.getClassObj();
                HeapDumpInstanceObject instanceObject = new HeapDumpInstanceObject(this, this.getClassObjectInstance((Instance)instance), (Instance)instance, this.myClassDb.registerClass(classObj.getClassLoaderId(), classObj.getClassName()), null);
                this.myInstanceIndex.put((Instance)instance, instanceObject);
                heapSet.addDeltaInstanceObject(instanceObject);
                return true;
            });
        }
        heapSets.forEach((key, value) -> {
            if ("default".equals(key.getName())) {
                if (heapSets.size() == 1 || key.getInstancesCount() > 0) {
                    this.myHeapSets.put(key.getId(), (HeapSet)value);
                }
            } else {
                this.myHeapSets.put(key.getId(), (HeapSet)value);
            }
        });
        this.myStage.refreshSelectedHeap();
        return true;
    }

    @Override
    public boolean isDoneLoading() {
        return this.mySnapshot != null || this.myIsLoadingError;
    }

    @Override
    public boolean isError() {
        return this.myIsLoadingError;
    }

    @Override
    public void unload() {
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        return this.myHasNativeAllocations ? Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.NATIVE_SIZE, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE) : Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE);
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        return this.myHasNativeAllocations ? Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.NATIVE_SIZE, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE) : Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE);
    }

    @Nullable
    public InstanceObject findInstanceObject(@NotNull Instance instance) {
        if (this.mySnapshot == null) {
            return null;
        }
        return this.myInstanceIndex.get(instance);
    }

    @NotNull
    InstanceObject createClassObjectInstance(@Nullable InstanceObject javaLangClass, @NotNull ClassObj classObj) {
        if (javaLangClass == null) {
            assert (!this.myClassObjectIndex.containsKey(classObj));
            HeapDumpInstanceObject rootInstanceObject = new HeapDumpInstanceObject(this, null, (Instance)classObj, this.myClassDb.registerClass(classObj.getClassLoaderId(), "java.lang.Class"), ValueObject.ValueType.CLASS);
            this.myClassObjectIndex.put(classObj, rootInstanceObject);
            return rootInstanceObject;
        }
        HeapDumpInstanceObject classObject = new HeapDumpInstanceObject(this, javaLangClass, (Instance)classObj, this.myClassDb.registerClass(classObj.getClassLoaderId(), javaLangClass.getClassEntry().getClassName()), ValueObject.ValueType.CLASS);
        this.myClassObjectIndex.put(classObj, classObject);
        return classObject;
    }

    @Nullable
    InstanceObject getClassObjectInstance(@NotNull Instance instance) {
        ClassObj classObj = instance.getClassObj();
        return this.myClassObjectIndex.get(classObj);
    }
}

