/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.StackFrame;
import com.android.tools.perflib.heap.Type;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.ArrayObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.HeapDumpCaptureObject;
import com.android.tools.profilers.memory.adapters.HeapDumpFieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ReferenceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HeapDumpInstanceObject
implements InstanceObject {
    private static final String NAME_FORMATTER = "%s@%d (0x%x)";
    private static final int MAX_VALUE_TEXT_LENGTH = 1024;
    private static final Comparator<Instance> DEPTH_COMPARATOR = Comparator.comparingInt(Instance::getDistanceToGcRoot);
    private static final String INVALID_STRING_VALUE = " ...<invalid string value>...";
    private static final Map<Type, ValueObject.ValueType> VALUE_TYPE_MAP = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)ValueObject.ValueType.BOOLEAN).put((Object)Type.BYTE, (Object)ValueObject.ValueType.BYTE).put((Object)Type.CHAR, (Object)ValueObject.ValueType.CHAR).put((Object)Type.SHORT, (Object)ValueObject.ValueType.SHORT).put((Object)Type.INT, (Object)ValueObject.ValueType.INT).put((Object)Type.LONG, (Object)ValueObject.ValueType.LONG).put((Object)Type.FLOAT, (Object)ValueObject.ValueType.FLOAT).put((Object)Type.DOUBLE, (Object)ValueObject.ValueType.DOUBLE).put((Object)Type.OBJECT, (Object)ValueObject.ValueType.OBJECT).build();
    @NotNull
    protected ValueObject.ValueType myValueType;
    @NotNull
    private final HeapDumpCaptureObject myCaptureObject;
    @Nullable
    private final InstanceObject myClassInstanceObject;
    @NotNull
    private final Instance myInstance;
    @NotNull
    private final ClassDb.ClassEntry myClassEntry;
    @NotNull
    private final String myMemoizedLabel;

    public HeapDumpInstanceObject(@NotNull HeapDumpCaptureObject captureObject, @Nullable InstanceObject classInstanceObject, @NotNull Instance instance, @NotNull ClassDb.ClassEntry classEntry, @Nullable ValueObject.ValueType precomputedValueType) {
        this.myCaptureObject = captureObject;
        this.myClassInstanceObject = classInstanceObject;
        this.myInstance = instance;
        this.myClassEntry = classEntry;
        this.myMemoizedLabel = String.format(NAME_FORMATTER, this.myClassEntry.getSimpleClassName(), this.myInstance.getUniqueId(), this.myInstance.getUniqueId());
        if (precomputedValueType != null) {
            this.myValueType = precomputedValueType;
            return;
        }
        ClassObj classObj = instance.getClassObj();
        this.myValueType = instance instanceof ClassObj ? ValueObject.ValueType.CLASS : (instance instanceof ClassInstance && classObj.getClassName().equals("java.lang.String") ? ValueObject.ValueType.STRING : (classObj.getClassName().endsWith("[]") ? ValueObject.ValueType.ARRAY : ValueObject.ValueType.OBJECT));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HeapDumpInstanceObject)) {
            return false;
        }
        HeapDumpInstanceObject otherInstance = (HeapDumpInstanceObject)obj;
        return this.myInstance == otherInstance.myInstance;
    }

    public int hashCode() {
        return this.myInstance.hashCode();
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    @NotNull
    public String getValueText() {
        return this.myMemoizedLabel;
    }

    @Override
    @NotNull
    public String getToStringText() {
        if (this.myValueType == ValueObject.ValueType.STRING) {
            String text = ((ClassInstance)this.myInstance).getAsString(1024);
            if (text != null) {
                int textLength = text.length();
                StringBuilder builder = new StringBuilder(6 + textLength);
                builder.append("\"");
                if (textLength == 1024) {
                    builder.append(text, 0, textLength - 1).append("...");
                } else {
                    builder.append(text);
                }
                builder.append("\"");
                return builder.toString();
            }
            return INVALID_STRING_VALUE;
        }
        return "";
    }

    @Override
    public int getHeapId() {
        return this.myInstance.getHeap().getId();
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        return this.myClassEntry;
    }

    @Override
    @Nullable
    public InstanceObject getClassObject() {
        return this.myClassInstanceObject;
    }

    @Override
    public int getDepth() {
        return this.myInstance.getDistanceToGcRoot();
    }

    @Override
    public long getNativeSize() {
        return this.myInstance.getNativeSize();
    }

    @Override
    public int getShallowSize() {
        return this.myInstance.getSize();
    }

    @Override
    public long getRetainedSize() {
        return this.myInstance.getTotalRetainedSize();
    }

    @Override
    public int getFieldCount() {
        if (this.myInstance instanceof ClassInstance) {
            ClassInstance classInstance = (ClassInstance)this.myInstance;
            return classInstance.getValues().size();
        }
        if (this.myInstance instanceof ArrayInstance) {
            ArrayInstance arrayInstance = (ArrayInstance)this.myInstance;
            return arrayInstance.getLength();
        }
        if (this.myInstance instanceof ClassObj) {
            ClassObj classObj = (ClassObj)this.myInstance;
            return classObj.getStaticFieldValues().size();
        }
        return 0;
    }

    @Override
    @NotNull
    public List<FieldObject> getFields() {
        ArrayList<FieldObject> fields;
        block4: {
            block5: {
                block3: {
                    fields = new ArrayList<FieldObject>();
                    if (!(this.myInstance instanceof ClassInstance)) break block3;
                    ClassInstance classInstance = (ClassInstance)this.myInstance;
                    for (ClassInstance.FieldValue field : classInstance.getValues()) {
                        fields.add(new HeapDumpFieldObject(this.myCaptureObject, this.myInstance, field));
                    }
                    break block4;
                }
                if (!(this.myInstance instanceof ArrayInstance)) break block5;
                ArrayInstance arrayInstance = (ArrayInstance)this.myInstance;
                Type arrayType = arrayInstance.getArrayType();
                int arrayIndex = 0;
                for (Object value : arrayInstance.getValues()) {
                    ClassInstance.FieldValue field = new ClassInstance.FieldValue(new Field(arrayType, Integer.toString(arrayIndex)), value);
                    fields.add(new HeapDumpFieldObject(this.myCaptureObject, this.myInstance, field));
                    ++arrayIndex;
                }
                break block4;
            }
            if (!(this.myInstance instanceof ClassObj)) break block4;
            ClassObj classObj = (ClassObj)this.myInstance;
            for (Map.Entry entry : classObj.getStaticFieldValues().entrySet()) {
                ClassInstance.FieldValue field = new ClassInstance.FieldValue((Field)entry.getKey(), entry.getValue());
                fields.add(new HeapDumpFieldObject(this.myCaptureObject, this.myInstance, field));
            }
        }
        return fields;
    }

    @Override
    @Nullable
    public ArrayObject getArrayObject() {
        if (!(this.myInstance instanceof ArrayInstance)) {
            return null;
        }
        final ArrayInstance arrayInstance = (ArrayInstance)this.myInstance;
        return new ArrayObject(){

            @Override
            @NotNull
            public ValueObject.ValueType getArrayElementType() {
                return (ValueObject.ValueType)((Object)VALUE_TYPE_MAP.get(arrayInstance.getArrayType()));
            }

            @Override
            @Nullable
            public byte[] getAsByteArray() {
                if (this.getArrayElementType() == ValueObject.ValueType.BYTE) {
                    return arrayInstance.asRawByteArray(0, arrayInstance.getLength());
                }
                return null;
            }

            @Override
            @Nullable
            public char[] getAsCharArray() {
                if (this.getArrayElementType() == ValueObject.ValueType.CHAR) {
                    return arrayInstance.asCharArray(0, arrayInstance.getLength());
                }
                return null;
            }

            @Override
            @NotNull
            public Object[] getAsArray() {
                return arrayInstance.getValues();
            }

            @Override
            public int getArrayLength() {
                return arrayInstance.getLength();
            }
        };
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        return this.myValueType;
    }

    @Override
    @Nullable
    public MemoryProfiler.AllocationStack getAllocationCallStack() {
        if (this.myInstance.getStack() == null) {
            return null;
        }
        MemoryProfiler.AllocationStack.Builder builder = MemoryProfiler.AllocationStack.newBuilder();
        MemoryProfiler.AllocationStack.StackFrameWrapper.Builder frameBuilder = MemoryProfiler.AllocationStack.StackFrameWrapper.newBuilder();
        for (StackFrame stackFrame : this.myInstance.getStack().getFrames()) {
            String fileName = stackFrame.getFilename();
            String guessedClassName = fileName.endsWith(".java") ? fileName.substring(0, fileName.length() - ".java".length()) : fileName;
            frameBuilder.addFrames(MemoryProfiler.AllocationStack.StackFrame.newBuilder().setClassName(guessedClassName).setMethodName(stackFrame.getMethodName()).setLineNumber(stackFrame.getLineNumber()).setFileName(fileName).build());
        }
        builder.setFullStack(frameBuilder);
        return builder.build();
    }

    @Override
    public boolean getIsRoot() {
        return this.myInstance instanceof RootObj;
    }

    @Override
    @NotNull
    public List<ReferenceObject> getReferences() {
        return this.getIsRoot() ? Collections.EMPTY_LIST : this.extractReferences();
    }

    @NotNull
    public List<ReferenceObject> extractReferences() {
        ArrayList<Object> sortedReferences = new ArrayList<Object>(this.myInstance.getHardReverseReferences());
        sortedReferences.sort(DEPTH_COMPARATOR);
        if (this.myInstance.getSoftReverseReferences() != null) {
            ArrayList<Instance> sortedSoftReferences = new ArrayList<Instance>(this.myInstance.getSoftReverseReferences());
            sortedSoftReferences.sort(DEPTH_COMPARATOR);
            sortedReferences.addAll(sortedSoftReferences);
        }
        ArrayList<ReferenceObject> referrers = new ArrayList<ReferenceObject>(sortedReferences.size());
        for (Instance instance : sortedReferences) {
            ArrayList<String> referencingFieldNames = new ArrayList<String>(3);
            if (instance instanceof ClassInstance) {
                ClassInstance classInstance = (ClassInstance)instance;
                for (ClassInstance.FieldValue entry : classInstance.getValues()) {
                    if (entry.getField().getType() != Type.OBJECT || entry.getValue() != this.myInstance) continue;
                    referencingFieldNames.add(entry.getField().getName());
                }
            } else if (instance instanceof ArrayInstance) {
                ArrayInstance arrayInstance = (ArrayInstance)instance;
                assert (arrayInstance.getArrayType() == Type.OBJECT);
                Object[] values = arrayInstance.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != this.myInstance) continue;
                    referencingFieldNames.add(String.valueOf(i));
                }
            } else if (instance instanceof ClassObj) {
                ClassObj classObj = (ClassObj)instance;
                Map staticValues = classObj.getStaticFieldValues();
                for (Map.Entry entry : staticValues.entrySet()) {
                    if (((Field)entry.getKey()).getType() != Type.OBJECT || entry.getValue() != this.myInstance) continue;
                    referencingFieldNames.add(((Field)entry.getKey()).getName());
                }
            }
            InstanceObject referencingInstance = this.myCaptureObject.findInstanceObject(instance);
            assert (referencingInstance != null);
            referrers.add(new ReferenceObject(referencingFieldNames, referencingInstance));
        }
        return referrers;
    }
}

