/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.AllocationStackConverter;
import com.android.tools.profilers.memory.adapters.ArrayObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.ReferenceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.ThreadId;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InstanceObject
extends ValueObject {
    public int getHeapId();

    @NotNull
    default public ThreadId getAllocationThreadId() {
        return ThreadId.INVALID_THREAD_ID;
    }

    @NotNull
    default public ThreadId getDeallocationThreadId() {
        return ThreadId.INVALID_THREAD_ID;
    }

    @NotNull
    public ClassDb.ClassEntry getClassEntry();

    @Nullable
    public InstanceObject getClassObject();

    default public int getFieldCount() {
        return 0;
    }

    @NotNull
    default public List<FieldObject> getFields() {
        return Collections.emptyList();
    }

    @Nullable
    default public ArrayObject getArrayObject() {
        return null;
    }

    default public long getAllocTime() {
        return Long.MIN_VALUE;
    }

    default public long getDeallocTime() {
        return Long.MAX_VALUE;
    }

    @Nullable
    default public MemoryProfiler.AllocationStack getAllocationCallStack() {
        return null;
    }

    default public int getCallStackDepth() {
        MemoryProfiler.AllocationStack callStack = this.getAllocationCallStack();
        if (callStack == null) {
            return 0;
        }
        switch (callStack.getFrameCase()) {
            case FULL_STACK: {
                return callStack.getFullStack().getFramesCount();
            }
            case SMALL_STACK: {
                return callStack.getSmallStack().getFramesCount();
            }
        }
        return 0;
    }

    @NotNull
    default public List<CodeLocation> getAllocationCodeLocations() {
        MemoryProfiler.AllocationStack.StackFrameWrapper fullStack;
        MemoryProfiler.AllocationStack callStack = this.getAllocationCallStack();
        if (callStack != null && callStack.getFrameCase() == MemoryProfiler.AllocationStack.FrameCase.FULL_STACK && !(fullStack = callStack.getFullStack()).getFramesList().isEmpty()) {
            List<CodeLocation> stackFrames = fullStack.getFramesList().stream().map(AllocationStackConverter::getCodeLocation).collect(Collectors.toList());
            return stackFrames;
        }
        return Collections.emptyList();
    }

    @NotNull
    default public List<CodeLocation> getDeallocationCodeLocations() {
        return Collections.emptyList();
    }

    @NotNull
    default public List<ReferenceObject> getReferences() {
        return Collections.emptyList();
    }

    default public boolean getIsRoot() {
        return false;
    }

    default public boolean hasTimeData() {
        return false;
    }

    default public boolean hasAllocTime() {
        return false;
    }

    default public boolean hasDeallocTime() {
        return false;
    }
}

