/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.JniReferenceInstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationInstanceObject;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TLongObjectHashMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class LiveAllocationCaptureObject
implements CaptureObject {
    static final String SAMPLING_INFO_MESSAGE = "Selected region does not have full tracking. Data may be inaccurate.";
    @Nullable
    private MemoryProfilerStage myStage;
    final ExecutorService myExecutorService;
    private final ClassDb myClassDb;
    private final Map<ClassDb.ClassEntry, LiveAllocationInstanceObject> myClassMap;
    private final TIntObjectHashMap<LiveAllocationInstanceObject> myInstanceMap;
    private final TIntObjectHashMap<MemoryProfiler.AllocationStack> myCallstackMap;
    @NotNull
    private final TLongObjectHashMap<MemoryProfiler.NativeCallStack.NativeFrame> myNativeFrameMap;
    private final TIntObjectHashMap<ThreadId> myThreadIdMap;
    private final TLongObjectHashMap<MemoryProfiler.StackFrameInfoResponse> myFrameInfoResponseMap;
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    private final Common.Session mySession;
    private final long myCaptureStartTime;
    private final List<HeapSet> myHeapSets;
    private final AspectObserver myAspectObserver;
    private final boolean myEnableJniRefsTracking;
    private long myEventsEndTimeNs;
    private long myContextEndTimeNs;
    private long myPreviousQueryStartTimeNs;
    private long myPreviousQueryEndTimeNs;
    private Range myQueryRange;
    private Future myCurrentTask;
    @Nullable
    private String myInfoMessage;

    private static Logger getLogger() {
        return Logger.getInstance(LiveAllocationCaptureObject.class);
    }

    public LiveAllocationCaptureObject(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, long captureStartTime, @Nullable ExecutorService loadService, @Nullable MemoryProfilerStage stage) {
        this.myExecutorService = loadService == null ? Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("profiler-live-allocation").build()) : loadService;
        this.myClassDb = new ClassDb();
        this.myClassMap = new HashMap<ClassDb.ClassEntry, LiveAllocationInstanceObject>();
        this.myInstanceMap = new TIntObjectHashMap();
        this.myCallstackMap = new TIntObjectHashMap();
        this.myNativeFrameMap = new TLongObjectHashMap();
        this.myThreadIdMap = new TIntObjectHashMap();
        this.myFrameInfoResponseMap = new TLongObjectHashMap();
        this.myClient = client;
        this.mySession = session;
        this.myCaptureStartTime = captureStartTime;
        this.myAspectObserver = new AspectObserver();
        this.myStage = stage;
        this.myHeapSets = new ArrayList<HeapSet>(Arrays.asList(new HeapSet(this, "default", 0), new HeapSet(this, "image", 1), new HeapSet(this, "zygote", 2), new HeapSet(this, "app", 3)));
        this.myEnableJniRefsTracking = stage.getStudioProfilers().getIdeServices().getFeatureConfig().isJniReferenceTrackingEnabled();
        if (this.myEnableJniRefsTracking) {
            this.myHeapSets.add(new HeapSet(this, "JNI", 4));
        }
        this.myEventsEndTimeNs = Long.MIN_VALUE;
        this.myContextEndTimeNs = Long.MIN_VALUE;
        this.myPreviousQueryStartTimeNs = Long.MIN_VALUE;
        this.myPreviousQueryEndTimeNs = Long.MIN_VALUE;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.mySession;
    }

    @Override
    @NotNull
    public MemoryServiceGrpc.MemoryServiceBlockingStub getClient() {
        return this.myClient;
    }

    @Override
    @NotNull
    public String getName() {
        return "Live Allocation";
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return null;
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isMemorySnapshotEnabled()) {
            return ImmutableList.of((Object)((Object)CaptureObject.ClassifierAttribute.LABEL), (Object)((Object)CaptureObject.ClassifierAttribute.ALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.DEALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.TOTAL_COUNT), (Object)((Object)CaptureObject.ClassifierAttribute.SHALLOW_SIZE));
        }
        return ImmutableList.of((Object)((Object)CaptureObject.ClassifierAttribute.LABEL), (Object)((Object)CaptureObject.ClassifierAttribute.ALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.DEALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.SHALLOW_SIZE));
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        return ImmutableList.of((Object)((Object)CaptureObject.InstanceAttribute.LABEL), (Object)((Object)CaptureObject.InstanceAttribute.ALLOCATION_TIME), (Object)((Object)CaptureObject.InstanceAttribute.DEALLOCATION_TIME));
    }

    @Override
    @Nullable
    public String getInfoMessage() {
        return this.myInfoMessage;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        if (this.myHeapSets.get(0).getInstancesCount() > 0) {
            return this.myHeapSets;
        }
        return this.myHeapSets.subList(1, this.myHeapSets.size());
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        return this.myHeapSets.get(heapId);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        return this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity());
    }

    @Override
    public long getStartTimeNs() {
        return this.myCaptureStartTime;
    }

    @Override
    public long getEndTimeNs() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        assert (queryRange != null);
        assert (queryJoiner != null);
        this.myQueryRange = queryRange;
        this.myQueryRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, () -> this.loadTimeRange(this.myQueryRange, queryJoiner));
        this.loadTimeRange(this.myQueryRange, queryJoiner);
        return true;
    }

    @Override
    @Nullable
    public MemoryProfiler.StackFrameInfoResponse getStackFrameInfoResponse(long methodId) {
        MemoryProfiler.StackFrameInfoResponse frameInfo = (MemoryProfiler.StackFrameInfoResponse)this.myFrameInfoResponseMap.get(methodId);
        if (frameInfo == null) {
            frameInfo = this.getClient().getStackFrameInfo(MemoryProfiler.StackFrameInfoRequest.newBuilder().setSession(this.getSession()).setMethodId(methodId).build());
            this.myFrameInfoResponseMap.put(methodId, (Object)frameInfo);
        }
        return frameInfo;
    }

    @Override
    public boolean isDoneLoading() {
        return true;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public void unload() {
        this.myQueryRange.removeDependencies(this.myAspectObserver);
        this.myExecutorService.shutdownNow();
    }

    private void updateAllocationContexts(long endTimeNs) {
        if (this.myContextEndTimeNs >= endTimeNs) {
            return;
        }
        MemoryProfiler.AllocationContextsResponse contextsResponse = this.myClient.getAllocationContexts(MemoryProfiler.AllocationContextsRequest.newBuilder().setSession(this.mySession).setStartTime(this.myContextEndTimeNs).setEndTime(endTimeNs).build());
        for (MemoryProfiler.AllocatedClass klass : contextsResponse.getAllocatedClassesList()) {
            ClassDb.ClassEntry entry = this.myClassDb.registerClass(-1L, klass.getClassName(), klass.getClassId());
            if (this.myClassMap.containsKey(entry)) continue;
            LiveAllocationInstanceObject instance = new LiveAllocationInstanceObject(this, entry, null, null, null, -1L, -1);
            instance.setAllocationTime(this.myCaptureStartTime);
            this.myClassMap.put(entry, instance);
        }
        contextsResponse.getAllocationStacksList().forEach(callStack -> {
            if (!this.myCallstackMap.contains(callStack.getStackId())) {
                this.myCallstackMap.put(callStack.getStackId(), callStack);
            }
        });
        contextsResponse.getAllocationThreadsList().forEach(thread2 -> {
            if (!this.myThreadIdMap.contains(thread2.getThreadId())) {
                this.myThreadIdMap.put(thread2.getThreadId(), (Object)new ThreadId(thread2.getThreadName()));
            }
        });
        this.myContextEndTimeNs = Math.max(this.myContextEndTimeNs, contextsResponse.getTimestamp());
    }

    private void loadTimeRange(@NotNull Range queryRange, @NotNull Executor joiner) {
        try {
            if (this.myCurrentTask != null) {
                this.myCurrentTask.cancel(false);
            }
            this.myCurrentTask = this.myExecutorService.submit(() -> {
                boolean clear;
                long newStartTimeNs = TimeUnit.MICROSECONDS.toNanos((long)queryRange.getMin());
                long newEndTimeNs = TimeUnit.MICROSECONDS.toNanos((long)queryRange.getMax());
                if (newStartTimeNs == this.myPreviousQueryStartTimeNs && newEndTimeNs == this.myPreviousQueryEndTimeNs && newEndTimeNs != Long.MAX_VALUE) {
                    return null;
                }
                boolean hasNonFullTrackingRegion = !MemoryProfiler.hasOnlyFullAllocationTrackingWithinRegion(this.myClient, this.mySession, TimeUnit.NANOSECONDS.toMicros(newStartTimeNs), TimeUnit.NANOSECONDS.toMicros(newEndTimeNs));
                joiner.execute(() -> this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATING));
                this.updateAllocationContexts(newEndTimeNs);
                if (newEndTimeNs > this.myEventsEndTimeNs + 1L) {
                    MemoryProfiler.LatestAllocationTimeResponse timeResponse = this.myClient.getLatestAllocationTime(MemoryProfiler.LatestAllocationTimeRequest.newBuilder().setSession(this.mySession).build());
                    this.myEventsEndTimeNs = Math.max(this.myEventsEndTimeNs, timeResponse.getTimestamp());
                    if (newEndTimeNs > this.myEventsEndTimeNs + 1L) {
                        newEndTimeNs = this.myEventsEndTimeNs + 1L;
                        newStartTimeNs = Math.min(newStartTimeNs, newEndTimeNs);
                    }
                }
                ArrayList<InstanceObject> snapshotList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetSnapshotList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> deltaAllocationList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetDeltaAllocationList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> deltaFreeList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetDeltaFreeList = new ArrayList<InstanceObject>();
                boolean bl = clear = this.myPreviousQueryEndTimeNs <= newStartTimeNs || newEndTimeNs <= this.myPreviousQueryStartTimeNs;
                if (clear) {
                    this.myInstanceMap.clear();
                    this.queryJavaInstanceSnapshot(newStartTimeNs, snapshotList);
                    this.queryJniReferencesSnapshot(newStartTimeNs, snapshotList);
                    this.queryJavaInstanceDelta(newStartTimeNs, newEndTimeNs, deltaAllocationList, deltaFreeList, false);
                    this.queryJniReferencesDelta(newStartTimeNs, newEndTimeNs, deltaAllocationList, deltaFreeList, false);
                } else {
                    ArrayList<InstanceObject> leftAllocations = new ArrayList<InstanceObject>();
                    ArrayList<InstanceObject> leftDeallocations = new ArrayList<InstanceObject>();
                    if (newStartTimeNs < this.myPreviousQueryStartTimeNs) {
                        this.queryJavaInstanceDelta(newStartTimeNs, this.myPreviousQueryStartTimeNs, leftAllocations, leftDeallocations, false);
                        this.queryJniReferencesDelta(newStartTimeNs, this.myPreviousQueryStartTimeNs, leftAllocations, leftDeallocations, false);
                        deltaAllocationList.addAll(leftAllocations);
                        deltaFreeList.addAll(leftDeallocations);
                        resetSnapshotList.addAll(leftAllocations);
                        snapshotList.addAll(leftDeallocations);
                    } else if (newStartTimeNs > this.myPreviousQueryStartTimeNs) {
                        this.queryJavaInstanceDelta(this.myPreviousQueryStartTimeNs, newStartTimeNs, leftAllocations, leftDeallocations, true);
                        this.queryJniReferencesDelta(this.myPreviousQueryStartTimeNs, newStartTimeNs, leftAllocations, leftDeallocations, true);
                        resetDeltaAllocationList.addAll(leftAllocations);
                        resetDeltaFreeList.addAll(leftDeallocations);
                        snapshotList.addAll(leftAllocations);
                        resetSnapshotList.addAll(leftDeallocations);
                    }
                    ArrayList<InstanceObject> rightAllocations = new ArrayList<InstanceObject>();
                    ArrayList<InstanceObject> rightDeallocations = new ArrayList<InstanceObject>();
                    if (newEndTimeNs < this.myPreviousQueryEndTimeNs) {
                        this.queryJavaInstanceDelta(newEndTimeNs, this.myPreviousQueryEndTimeNs, rightAllocations, rightDeallocations, true);
                        this.queryJniReferencesDelta(newEndTimeNs, this.myPreviousQueryEndTimeNs, rightAllocations, rightDeallocations, true);
                        resetDeltaAllocationList.addAll(rightAllocations);
                        resetDeltaFreeList.addAll(rightDeallocations);
                    } else if (newEndTimeNs > this.myPreviousQueryEndTimeNs) {
                        this.queryJavaInstanceDelta(this.myPreviousQueryEndTimeNs, newEndTimeNs, rightAllocations, rightDeallocations, false);
                        this.queryJniReferencesDelta(this.myPreviousQueryEndTimeNs, newEndTimeNs, rightAllocations, rightDeallocations, false);
                        deltaAllocationList.addAll(rightAllocations);
                        deltaFreeList.addAll(rightDeallocations);
                    }
                }
                this.myPreviousQueryStartTimeNs = newStartTimeNs;
                this.myPreviousQueryEndTimeNs = newEndTimeNs;
                joiner.execute(() -> {
                    this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATED);
                    if (clear || deltaAllocationList.size() + deltaFreeList.size() + resetDeltaAllocationList.size() + resetDeltaFreeList.size() > 0) {
                        if (clear) {
                            this.myHeapSets.forEach(heap -> heap.clearClassifierSets());
                            if (this.myStage.getSelectedClassSet() != null) {
                                this.myStage.selectClassSet(ClassSet.EMPTY_SET);
                            }
                        }
                        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isMemorySnapshotEnabled()) {
                            snapshotList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).addSnapshotInstanceObject((InstanceObject)instance));
                            resetSnapshotList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeSnapshotInstanceObject((InstanceObject)instance));
                        }
                        deltaAllocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).addDeltaInstanceObject((InstanceObject)instance));
                        deltaFreeList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).freeDeltaInstanceObject((InstanceObject)instance));
                        resetDeltaAllocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeAddedDeltaInstanceObject((InstanceObject)instance));
                        resetDeltaFreeList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeFreedDeltaInstanceObject((InstanceObject)instance));
                        this.myInfoMessage = hasNonFullTrackingRegion ? SAMPLING_INFO_MESSAGE : null;
                        this.myStage.refreshSelectedHeap();
                    }
                });
                return null;
            });
        }
        catch (RejectedExecutionException e) {
            LiveAllocationCaptureObject.getLogger().debug((Throwable)e);
        }
    }

    @NotNull
    private LiveAllocationInstanceObject getOrCreateInstanceObject(int tag, int classTag, int stackId, int threadId, long size, int heapId) {
        LiveAllocationInstanceObject instance = (LiveAllocationInstanceObject)this.myInstanceMap.get(tag);
        if (instance == null) {
            ClassDb.ClassEntry entry = this.myClassDb.getEntry(classTag);
            assert (this.myClassMap.containsKey(entry));
            MemoryProfiler.AllocationStack callstack = null;
            if (stackId != 0) {
                assert (this.myCallstackMap.containsKey(stackId));
                callstack = (MemoryProfiler.AllocationStack)this.myCallstackMap.get(stackId);
            }
            ThreadId thread2 = null;
            if (threadId != 0) {
                assert (this.myThreadIdMap.containsKey(threadId));
                thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
            }
            instance = new LiveAllocationInstanceObject(this, entry, this.myClassMap.get(entry), thread2, callstack, size, heapId);
            this.myInstanceMap.put(tag, (Object)instance);
        }
        return instance;
    }

    @Nullable
    private JniReferenceInstanceObject getOrCreateJniRefObject(int tag, long refValue) {
        LiveAllocationInstanceObject referencedObject = (LiveAllocationInstanceObject)this.myInstanceMap.get(tag);
        if (referencedObject == null) {
            return null;
        }
        JniReferenceInstanceObject result = referencedObject.getJniRefByValue(refValue);
        if (result == null) {
            result = new JniReferenceInstanceObject(this, referencedObject, tag, refValue);
            referencedObject.addJniRef(result);
        }
        return result;
    }

    private void queryJavaInstanceSnapshot(long newTimeNs, @NotNull List<InstanceObject> setAllocationList) {
        if (!this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isMemorySnapshotEnabled()) {
            return;
        }
        MemoryProfiler.BatchAllocationSample sampleResponse = this.myClient.getAllocations(MemoryProfiler.AllocationSnapshotRequest.newBuilder().setSession(this.mySession).setEndTime(newTimeNs).setLiveObjectsOnly(true).build());
        for (MemoryProfiler.AllocationEvent event : sampleResponse.getEventsList()) {
            if (event.getEventCase() == MemoryProfiler.AllocationEvent.EventCase.ALLOC_DATA) {
                MemoryProfiler.AllocationEvent.Allocation allocation = event.getAllocData();
                LiveAllocationInstanceObject instance = this.getOrCreateInstanceObject(allocation.getTag(), allocation.getClassTag(), allocation.getStackId(), allocation.getThreadId(), allocation.getSize(), allocation.getHeapId());
                instance.setAllocationTime(event.getTimestamp());
                setAllocationList.add(instance);
                continue;
            }
            assert (false);
        }
    }

    private void queryJniReferencesSnapshot(long newTimeNs, @NotNull List<InstanceObject> setAllocationList) {
        if (!this.myEnableJniRefsTracking) {
            return;
        }
        MemoryProfiler.JNIGlobalRefsEventsRequest request = MemoryProfiler.JNIGlobalRefsEventsRequest.newBuilder().setSession(this.mySession).setLiveObjectsOnly(true).setEndTime(newTimeNs).build();
        MemoryProfiler.BatchJNIGlobalRefEvent jniBatch = this.myClient.getJNIGlobalRefsEvents(request);
        for (MemoryProfiler.JNIGlobalReferenceEvent event : jniBatch.getEventsList()) {
            JniReferenceInstanceObject refObject;
            if (event.getEventType() != MemoryProfiler.JNIGlobalReferenceEvent.Type.CREATE_GLOBAL_REF || (refObject = this.getOrCreateJniRefObject(event.getObjectTag(), event.getRefValue())) == null) continue;
            if (event.hasBacktrace()) {
                refObject.setAllocationCallstack(this.resolveNativeBacktrace(event.getBacktrace()));
            }
            int threadId = event.getThreadId();
            ThreadId thread2 = ThreadId.INVALID_THREAD_ID;
            if (threadId != 0) {
                assert (this.myThreadIdMap.containsKey(threadId));
                thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
            }
            refObject.setAllocThreadId(thread2);
            refObject.setAllocationTime(event.getTimestamp());
            setAllocationList.add(refObject);
        }
    }

    private void queryJavaInstanceDelta(long startTimeNs, long endTimeNs, @NotNull List<InstanceObject> allocationList, @NotNull List<InstanceObject> deallocatoinList, boolean resetInstance) {
        if (startTimeNs == endTimeNs) {
            return;
        }
        MemoryProfiler.BatchAllocationSample sampleResponse = this.myClient.getAllocations(MemoryProfiler.AllocationSnapshotRequest.newBuilder().setSession(this.mySession).setStartTime(startTimeNs).setEndTime(endTimeNs).build());
        for (MemoryProfiler.AllocationEvent event : sampleResponse.getEventsList()) {
            LiveAllocationInstanceObject instance;
            if (event.getEventCase() == MemoryProfiler.AllocationEvent.EventCase.ALLOC_DATA) {
                MemoryProfiler.AllocationEvent.Allocation allocation = event.getAllocData();
                instance = this.getOrCreateInstanceObject(allocation.getTag(), allocation.getClassTag(), allocation.getStackId(), allocation.getThreadId(), allocation.getSize(), allocation.getHeapId());
                instance.setAllocationTime(resetInstance ? Long.MIN_VALUE : event.getTimestamp());
                allocationList.add(instance);
                continue;
            }
            if (event.getEventCase() == MemoryProfiler.AllocationEvent.EventCase.FREE_DATA) {
                MemoryProfiler.AllocationEvent.Deallocation deallocation = event.getFreeData();
                instance = this.getOrCreateInstanceObject(deallocation.getTag(), deallocation.getClassTag(), deallocation.getStackId(), deallocation.getThreadId(), deallocation.getSize(), deallocation.getHeapId());
                instance.setDeallocTime(resetInstance ? Long.MAX_VALUE : event.getTimestamp());
                deallocatoinList.add(instance);
                continue;
            }
            assert (false);
        }
    }

    private void queryJniReferencesDelta(long startTimeNs, long endTimeNs, @NotNull List<InstanceObject> allocationList, @NotNull List<InstanceObject> deallocatoinList, boolean resetInstance) {
        if (!this.myEnableJniRefsTracking || startTimeNs == endTimeNs) {
            return;
        }
        MemoryProfiler.JNIGlobalRefsEventsRequest request = MemoryProfiler.JNIGlobalRefsEventsRequest.newBuilder().setSession(this.mySession).setStartTime(startTimeNs).setEndTime(endTimeNs).build();
        MemoryProfiler.BatchJNIGlobalRefEvent jniBatch = this.myClient.getJNIGlobalRefsEvents(request);
        block4: for (MemoryProfiler.JNIGlobalReferenceEvent event : jniBatch.getEventsList()) {
            JniReferenceInstanceObject refObject = this.getOrCreateJniRefObject(event.getObjectTag(), event.getRefValue());
            if (refObject == null) continue;
            int threadId = event.getThreadId();
            ThreadId thread2 = ThreadId.INVALID_THREAD_ID;
            if (threadId != 0) {
                assert (this.myThreadIdMap.containsKey(threadId));
                thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
            }
            switch (event.getEventType()) {
                case CREATE_GLOBAL_REF: {
                    if (resetInstance) {
                        refObject.setAllocationTime(Long.MIN_VALUE);
                    } else {
                        refObject.setAllocationTime(event.getTimestamp());
                        if (event.hasBacktrace()) {
                            refObject.setAllocationCallstack(this.resolveNativeBacktrace(event.getBacktrace()));
                        }
                        refObject.setAllocThreadId(thread2);
                    }
                    allocationList.add(refObject);
                    continue block4;
                }
                case DELETE_GLOBAL_REF: {
                    if (resetInstance) {
                        refObject.setAllocationTime(Long.MAX_VALUE);
                    } else {
                        refObject.setDeallocTime(event.getTimestamp());
                        if (event.hasBacktrace()) {
                            refObject.setDeallocationCallstack(this.resolveNativeBacktrace(event.getBacktrace()));
                        }
                        refObject.setDeallocThreadId(thread2);
                    }
                    deallocatoinList.add(refObject);
                    continue block4;
                }
            }
            assert (false);
        }
    }

    @NotNull
    private MemoryProfiler.NativeCallStack resolveNativeBacktrace(@Nullable MemoryProfiler.NativeBacktrace backtrace) {
        if (backtrace == null || backtrace.getAddressesCount() == 0) {
            return MemoryProfiler.NativeCallStack.getDefaultInstance();
        }
        MemoryProfiler.ResolveNativeBacktraceRequest request = MemoryProfiler.ResolveNativeBacktraceRequest.newBuilder().setSession(this.getSession()).setBacktrace(backtrace).build();
        MemoryProfiler.NativeCallStack callstack = this.getClient().resolveNativeBacktrace(request);
        MemoryProfiler.NativeCallStack.Builder resolvedCallstack = MemoryProfiler.NativeCallStack.newBuilder();
        for (MemoryProfiler.NativeCallStack.NativeFrame unsymbolizedFrame : callstack.getFramesList()) {
            if (!this.myNativeFrameMap.containsKey(unsymbolizedFrame.getAddress())) {
                MemoryProfiler.NativeCallStack.NativeFrame symbolizedFrame = this.myStage.getStudioProfilers().getIdeServices().getNativeFrameSymbolizer().symbolize(this.myStage.getStudioProfilers().getSessionsManager().getSelectedSessionMetaData().getProcessAbi(), unsymbolizedFrame);
                this.myNativeFrameMap.put(unsymbolizedFrame.getAddress(), (Object)symbolizedFrame);
            }
            resolvedCallstack.addFrames((MemoryProfiler.NativeCallStack.NativeFrame)this.myNativeFrameMap.get(unsymbolizedFrame.getAddress()));
        }
        return resolvedCallstack.build();
    }
}

