/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    private final int myPackageNameIndex;

    @NotNull
    public static ClassifierSet.Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        return new PackageClassifier(captureObject, 0);
    }

    public PackageSet(@NotNull CaptureObject captureObject, @NotNull String packageElementName, int packageNameIndex) {
        super(packageElementName);
        this.myCaptureObject = captureObject;
        this.myPackageNameIndex = packageNameIndex;
    }

    @Override
    @NotNull
    public ClassifierSet.Classifier createSubClassifier() {
        return new PackageClassifier(this.myCaptureObject, this.myPackageNameIndex + 1);
    }

    private static final class PackageClassifier
    extends ClassifierSet.Classifier {
        @NotNull
        private final Map<String, PackageSet> myPackageElements = new LinkedHashMap<String, PackageSet>();
        @NotNull
        private final Map<ClassDb.ClassEntry, ClassSet> myClassMap = new LinkedHashMap<ClassDb.ClassEntry, ClassSet>();
        @NotNull
        private final CaptureObject myCaptureObject;
        private final int myPackageNameIndex;

        private PackageClassifier(@NotNull CaptureObject captureObject, int packageNameIndex) {
            this.myCaptureObject = captureObject;
            this.myPackageNameIndex = packageNameIndex;
        }

        @Override
        @Nullable
        public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
            if (this.myPackageNameIndex >= instance.getClassEntry().getSplitPackageName().length) {
                ClassDb.ClassEntry classEntry = instance.getClassEntry();
                ClassSet classSet = this.myClassMap.get(classEntry);
                if (classSet == null && createIfAbsent) {
                    classSet = new ClassSet(classEntry);
                    this.myClassMap.put(classEntry, classSet);
                }
                return classSet;
            }
            String subPackageName = instance.getClassEntry().getSplitPackageName()[this.myPackageNameIndex];
            PackageSet packageSet = this.myPackageElements.get(subPackageName);
            if (packageSet == null && createIfAbsent) {
                packageSet = new PackageSet(this.myCaptureObject, subPackageName, this.myPackageNameIndex);
                this.myPackageElements.put(subPackageName, packageSet);
            }
            return packageSet;
        }

        @Override
        @NotNull
        public List<ClassifierSet> getFilteredClassifierSets() {
            return Stream.concat(this.myPackageElements.values().stream(), this.myClassMap.values().stream()).filter(child -> !child.getIsFiltered()).collect(Collectors.toList());
        }

        @Override
        @NotNull
        protected List<ClassifierSet> getAllClassifierSets() {
            return Stream.concat(this.myPackageElements.values().stream(), this.myClassMap.values().stream()).collect(Collectors.toList());
        }
    }
}

