/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.common.EnumColors;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.network.NetworkState;
import com.android.tools.profilers.network.httpdata.HttpData;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class ConnectionsStateChart {
    @NotNull
    private final EnumColors<NetworkState> myColors = new EnumColors.Builder(2).add((Enum)NetworkState.SENDING, new Color[]{ProfilerColors.NETWORK_SENDING_COLOR, ProfilerColors.NETWORK_SENDING_COLOR}).add((Enum)NetworkState.RECEIVING, new Color[]{ProfilerColors.NETWORK_RECEIVING_COLOR, ProfilerColors.NETWORK_RECEIVING_SELECTED_COLOR}).add((Enum)NetworkState.WAITING, new Color[]{ProfilerColors.NETWORK_WAITING_COLOR, ProfilerColors.NETWORK_WAITING_COLOR}).add((Enum)NetworkState.NONE, new Color[]{ProfilerColors.TRANSPARENT_COLOR, ProfilerColors.TRANSPARENT_COLOR}).build();
    @NotNull
    private final StateChart<NetworkState> myChart;

    public ConnectionsStateChart(@NotNull List<HttpData> dataList, @NotNull Range range) {
        this.myChart = this.createChart(dataList, range);
    }

    public ConnectionsStateChart(@NotNull HttpData data, @NotNull Range range) {
        this(Collections.singletonList(data), range);
    }

    @NotNull
    public EnumColors<NetworkState> getColors() {
        return this.myColors;
    }

    public void setHeightGap(float gap) {
        this.myChart.setHeightGap(gap);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myChart;
    }

    @NotNull
    private StateChart<NetworkState> createChart(@NotNull Collection<HttpData> dataList, @NotNull Range range) {
        DefaultDataSeries series = new DefaultDataSeries();
        series.add(0L, (Object)NetworkState.NONE);
        for (HttpData data : dataList) {
            if (data.getConnectionEndTimeUs() == 0L) continue;
            series.add(data.getRequestStartTimeUs(), (Object)NetworkState.SENDING);
            if (data.getResponseStartTimeUs() > 0L) {
                series.add(data.getResponseStartTimeUs(), (Object)NetworkState.RECEIVING);
            }
            series.add(data.getConnectionEndTimeUs(), (Object)NetworkState.NONE);
        }
        StateChartModel stateModel = new StateChartModel();
        StateChart chart = new StateChart(stateModel, (StateChartColorProvider)new StateChartColorProvider<NetworkState>(){

            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull NetworkState value) {
                return ConnectionsStateChart.this.myColors.getColor((Enum)value);
            }
        });
        stateModel.addSeries(new RangedSeries(range, (DataSeries)series));
        return chart;
    }
}

