/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.httpdata.HttpData;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpDataFetcher {
    private final AspectObserver myAspectObserver = new AspectObserver();
    @NotNull
    private final NetworkConnectionsModel myConnectionsModel;
    @NotNull
    private final Range myRange;
    @NotNull
    private final List<Listener> myListeners = new ArrayList<Listener>();
    @Nullable
    private List<HttpData> myDataList;

    public HttpDataFetcher(@NotNull NetworkConnectionsModel connectionsModel, @NotNull Range range) {
        this.myConnectionsModel = connectionsModel;
        this.myRange = range;
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::handleRangeUpdated);
        this.handleRangeUpdated();
    }

    public void addListener(@NotNull Listener listener) {
        this.myListeners.add(listener);
        if (this.myDataList != null) {
            this.fireListeners(this.myDataList);
        }
    }

    private void handleRangeUpdated() {
        ArrayList<HttpData> dataList;
        List<HttpData> list = dataList = !this.myRange.isEmpty() ? this.myConnectionsModel.getData(this.myRange) : new ArrayList<HttpData>();
        if (this.myDataList != null && this.myDataList.equals(dataList)) {
            return;
        }
        this.myDataList = dataList;
        this.fireListeners(this.myDataList);
    }

    private void fireListeners(@NotNull List<HttpData> dataList) {
        for (Listener l : this.myListeners) {
            l.onUpdated(dataList);
        }
    }

    public static interface Listener {
        public void onUpdated(@NotNull List<HttpData> var1);
    }
}

