/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.NetworkTrafficFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.network.DetailedNetworkUsage;
import com.android.tools.profilers.network.HttpDataFetcher;
import com.android.tools.profilers.network.LegacyRpcNetworkConnectionsModel;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.NetworkProfilerAspect;
import com.android.tools.profilers.network.NetworkTrafficDataSeries;
import com.android.tools.profilers.network.RpcNetworkConnectionsModel;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final String HAS_USED_NETWORK_SELECTION = "network.used.selection";
    private static final BaseAxisFormatter TRAFFIC_AXIS_FORMATTER = new NetworkTrafficFormatter(1, 5, 5);
    private static final BaseAxisFormatter CONNECTIONS_AXIS_FORMATTER = new SingleUnitAxisFormatter(1, 5, 1, "");
    @Nullable
    private HttpData mySelectedConnection;
    private AspectObserver myAspectObserver = new AspectObserver();
    private AspectModel<NetworkProfilerAspect> myAspect = new AspectModel();
    private final NetworkConnectionsModel myConnectionsModel;
    private final DetailedNetworkUsage myDetailedNetworkUsage;
    private final NetworkStageLegends myLegends;
    private final NetworkStageLegends myTooltipLegends;
    private final ClampedAxisComponentModel myTrafficAxis;
    private final ClampedAxisComponentModel myConnectionsAxis;
    private final EventMonitor myEventMonitor;
    private final StackTraceModel myStackTraceModel;
    private final SelectionModel mySelectionModel;
    private final HttpDataFetcher myHttpDataFetcher;
    private final EaseOutModel myInstructionsEaseOutModel;

    public NetworkProfilerStage(final StudioProfilers profilers) {
        super(profilers);
        ProfilerTimeline timeline = profilers.getTimeline();
        this.myDetailedNetworkUsage = new DetailedNetworkUsage(profilers);
        this.myTrafficAxis = new ClampedAxisComponentModel.Builder(this.myDetailedNetworkUsage.getTrafficRange(), TRAFFIC_AXIS_FORMATTER).build();
        this.myConnectionsAxis = new ClampedAxisComponentModel.Builder(this.myDetailedNetworkUsage.getConnectionsRange(), CONNECTIONS_AXIS_FORMATTER).build();
        this.myLegends = new NetworkStageLegends(this.myDetailedNetworkUsage, timeline.getDataRange(), false);
        this.myTooltipLegends = new NetworkStageLegends(this.myDetailedNetworkUsage, timeline.getTooltipRange(), true);
        this.myEventMonitor = new EventMonitor(profilers);
        this.myStackTraceModel = new StackTraceModel(profilers.getIdeServices().getCodeNavigator());
        this.mySelectionModel = new SelectionModel(timeline.getSelectionRange());
        profilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, () -> this.mySelectionModel.setSelectionEnabled(profilers.isAgentAttached()));
        this.mySelectionModel.setSelectionEnabled(profilers.isAgentAttached());
        this.mySelectionModel.addListener(new SelectionListener(){

            public void selectionCreated() {
                NetworkProfilerStage.this.setProfilerMode(ProfilerMode.EXPANDED);
                profilers.getIdeServices().getFeatureTracker().trackSelectRange();
                profilers.getIdeServices().getTemporaryProfilerPreferences().setBoolean(NetworkProfilerStage.HAS_USED_NETWORK_SELECTION, true);
                NetworkProfilerStage.this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
            }

            public void selectionCleared() {
                NetworkProfilerStage.this.setProfilerMode(ProfilerMode.NORMAL);
            }
        });
        this.myConnectionsModel = profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled() ? new RpcNetworkConnectionsModel(profilers.getClient().getTransportClient(), profilers.getSession()) : new LegacyRpcNetworkConnectionsModel(profilers.getClient().getTransportClient(), profilers.getClient().getNetworkClient(), profilers.getSession());
        this.myHttpDataFetcher = new HttpDataFetcher(this.myConnectionsModel, timeline.getSelectionRange());
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
    }

    public boolean hasUserUsedNetworkSelection() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_NETWORK_SELECTION, false);
    }

    @NotNull
    public NetworkConnectionsModel getConnectionsModel() {
        return this.myConnectionsModel;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    @NotNull
    public StackTraceModel getStackTraceModel() {
        return this.myStackTraceModel;
    }

    @NotNull
    public HttpDataFetcher getHttpDataFetcher() {
        return this.myHttpDataFetcher;
    }

    public boolean setSelectedConnection(@Nullable HttpData data) {
        if (Objects.equals(this.mySelectedConnection, data)) {
            return false;
        }
        this.mySelectedConnection = data;
        this.getAspect().changed((Enum)NetworkProfilerAspect.SELECTED_CONNECTION);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectNetworkRequest();
        return true;
    }

    @Nullable
    public HttpData getSelectedConnection() {
        return this.mySelectedConnection;
    }

    @NotNull
    public AspectModel<NetworkProfilerAspect> getAspect() {
        return this.myAspect;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myDetailedNetworkUsage);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myTrafficAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myConnectionsAxis);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myDetailedNetworkUsage);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myTrafficAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myConnectionsAxis);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.mySelectionModel.clearListeners();
    }

    @NotNull
    public String getName() {
        return "NETWORK";
    }

    @NotNull
    public DetailedNetworkUsage getDetailedNetworkUsage() {
        return this.myDetailedNetworkUsage;
    }

    @NotNull
    public AxisComponentModel getTrafficAxis() {
        return this.myTrafficAxis;
    }

    @NotNull
    public AxisComponentModel getConnectionsAxis() {
        return this.myConnectionsAxis;
    }

    @NotNull
    public NetworkStageLegends getLegends() {
        return this.myLegends;
    }

    @NotNull
    public NetworkStageLegends getTooltipLegends() {
        return this.myTooltipLegends;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        return this.myInstructionsEaseOutModel;
    }

    @NotNull
    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    public static class NetworkStageLegends
    extends LegendComponentModel {
        private final SeriesLegend myRxLegend;
        private final SeriesLegend myTxLegend;
        private final SeriesLegend myConnectionLegend;

        public NetworkStageLegends(DetailedNetworkUsage usage, Range range, boolean tooltip) {
            super(range);
            this.myRxLegend = new SeriesLegend(usage.getRxSeries(), TRAFFIC_AXIS_FORMATTER, range, NetworkTrafficDataSeries.Type.BYTES_RECEIVED.getLabel(tooltip), Interpolatable.SegmentInterpolator);
            this.myTxLegend = new SeriesLegend(usage.getTxSeries(), TRAFFIC_AXIS_FORMATTER, range, NetworkTrafficDataSeries.Type.BYTES_SENT.getLabel(tooltip), Interpolatable.SegmentInterpolator);
            this.myConnectionLegend = new SeriesLegend(usage.getConnectionSeries(), CONNECTIONS_AXIS_FORMATTER, range, Interpolatable.SteppedLineInterpolator);
            this.add((Legend)this.myRxLegend);
            this.add((Legend)this.myTxLegend);
            this.add((Legend)this.myConnectionLegend);
        }

        public SeriesLegend getRxLegend() {
            return this.myRxLegend;
        }

        public SeriesLegend getTxLegend() {
            return this.myTxLegend;
        }

        public SeriesLegend getConnectionLegend() {
            return this.myConnectionLegend;
        }
    }
}

