/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.SelectionComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.instructions.UrlInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.stdui.CommonTabbedPane;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.android.tools.profilers.network.ConnectionsView;
import com.android.tools.profilers.network.DetailedNetworkUsage;
import com.android.tools.profilers.network.NetworkProfilerAspect;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkTrafficTooltip;
import com.android.tools.profilers.network.NetworkTrafficTooltipView;
import com.android.tools.profilers.network.ThreadsView;
import com.android.tools.profilers.network.details.ConnectionDetailsView;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;

public class NetworkProfilerStageView
extends StageView<NetworkProfilerStage> {
    private static final String CARD_CONNECTIONS = "Connections";
    private static final String CARD_INFO = "Info";
    private final ConnectionsView myConnectionsView;
    private final ConnectionDetailsView myConnectionDetails;
    private final JPanel myConnectionsPanel;

    public NetworkProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull NetworkProfilerStage stage) {
        super(profilersView, stage);
        ((NetworkProfilerStage)this.getStage()).getAspect().addDependency((AspectObserver)this).onChange((Enum)NetworkProfilerAspect.SELECTED_CONNECTION, this::updateConnectionDetailsView);
        this.getTooltipBinder().bind(NetworkTrafficTooltip.class, NetworkTrafficTooltipView::new);
        this.getTooltipBinder().bind(LifecycleTooltip.class, LifecycleTooltipView::new);
        this.getTooltipBinder().bind(UserEventTooltip.class, UserEventTooltipView::new);
        this.myConnectionDetails = new ConnectionDetailsView(this);
        this.myConnectionDetails.setMinimumSize(new Dimension(JBUI.scale((int)450), (int)this.myConnectionDetails.getMinimumSize().getHeight()));
        this.myConnectionsView = new ConnectionsView(this);
        ThreadsView threadsView = new ThreadsView(this);
        JBSplitter leftSplitter = new JBSplitter(true);
        leftSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        leftSplitter.setFirstComponent((JComponent)this.buildMonitorUi());
        this.myConnectionsPanel = new JPanel((LayoutManager)new TabularLayout("*,Fit-", "Fit-,*"));
        JPanel connectionsPanel = new JPanel(new CardLayout());
        CommonTabbedPane connectionsTab = new CommonTabbedPane();
        JBScrollPane connectionScrollPane = new JBScrollPane((Component)this.myConnectionsView.getComponent());
        connectionScrollPane.setBorder((Border)JBUI.Borders.empty());
        JBScrollPane threadsViewScrollPane = new JBScrollPane((Component)threadsView.getComponent());
        threadsViewScrollPane.setBorder((Border)JBUI.Borders.empty());
        connectionsTab.addTab("Connection View", (Component)connectionScrollPane);
        connectionsTab.addTab("Thread View", (Component)threadsViewScrollPane);
        connectionsTab.addChangeListener(arg_0 -> this.lambda$new$0((JTabbedPane)connectionsTab, arg_0));
        connectionsPanel.add((Component)connectionsTab, CARD_CONNECTIONS);
        JPanel infoPanel = new JPanel(new BorderLayout());
        InstructionsPanel infoMessage = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(UIUtilities.getFontMetrics((JComponent)infoPanel, (Font)ProfilerFonts.H3_FONT), "Network profiling data unavailable"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(UIUtilities.getFontMetrics((JComponent)infoPanel, (Font)ProfilerFonts.STANDARD_FONT), "There is no information for the network traffic you've selected."), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new UrlInstruction(ProfilerFonts.STANDARD_FONT, "Learn More", "https://developer.android.com/r/studio-ui/network-profiler-troubleshoot-connections.html")}).setColors(JBColor.foreground(), null).build();
        infoPanel.add((Component)infoMessage, "Center");
        infoPanel.setName(CARD_INFO);
        connectionsPanel.add((Component)infoPanel, CARD_INFO);
        JPanel toolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        JLabel selectionTimeLabel = this.getSelectionTimeLabel();
        selectionTimeLabel.setBorder((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)8));
        toolbar.add(selectionTimeLabel);
        this.myConnectionsPanel.add((Component)toolbar, new TabularLayout.Constraint(0, 1));
        this.myConnectionsPanel.add((Component)connectionsPanel, new TabularLayout.Constraint(0, 0, 2, 2));
        this.myConnectionsPanel.setVisible(false);
        leftSplitter.setSecondComponent((JComponent)this.myConnectionsPanel);
        this.getTimeline().getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> {
            CardLayout cardLayout = (CardLayout)connectionsPanel.getLayout();
            cardLayout.show(connectionsPanel, this.selectionHasTrafficUsageWithNoConnection() ? CARD_INFO : CARD_CONNECTIONS);
        });
        JBSplitter splitter = new JBSplitter(false, 0.6f);
        splitter.setFirstComponent((JComponent)leftSplitter);
        splitter.setSecondComponent((JComponent)this.myConnectionDetails);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.getDivider().setBorder(AdtUiUtils.DEFAULT_VERTICAL_BORDERS);
        this.getComponent().add((Component)splitter, "Center");
        this.updateConnectionDetailsView();
    }

    public ConnectionsView getConnectionsView() {
        return this.myConnectionsView;
    }

    @NotNull
    private JPanel buildMonitorUi() {
        StudioProfilers profilers = ((NetworkProfilerStage)this.getStage()).getStudioProfilers();
        ProfilerTimeline timeline = profilers.getTimeline();
        SelectionComponent selection = new SelectionComponent(((NetworkProfilerStage)this.getStage()).getSelectionModel(), timeline.getViewRange());
        selection.setCursorSetter(ProfilerLayeredPane::setCursorOnProfilerLayeredPane);
        RangeTooltipComponent tooltip = new RangeTooltipComponent(timeline.getTooltipRange(), timeline.getViewRange(), timeline.getDataRange(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> selection.shouldShowSeekComponent());
        TabularLayout layout = new TabularLayout("*");
        JBPanel panel = new JBPanel((LayoutManager)layout);
        panel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        panel.add((Component)tooltip, new TabularLayout.Constraint(0, 0, 2, 1));
        ProfilerScrollbar sb = new ProfilerScrollbar(timeline, (JComponent)panel);
        panel.add((Component)((Object)sb), new TabularLayout.Constraint(3, 0));
        JComponent timeAxis = this.buildTimeAxis(profilers);
        panel.add((Component)timeAxis, new TabularLayout.Constraint(2, 0));
        EventMonitorView eventsView = new EventMonitorView(this.getProfilersView(), ((NetworkProfilerStage)this.getStage()).getEventMonitor());
        JComponent eventsComponent = eventsView.getComponent();
        panel.add((Component)eventsComponent, new TabularLayout.Constraint(0, 0));
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
        JLabel label = new JLabel(((NetworkProfilerStage)this.getStage()).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        lineChartPanel.setBorder(BorderFactory.createEmptyBorder(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0));
        DetailedNetworkUsage usage = ((NetworkProfilerStage)this.getStage()).getDetailedNetworkUsage();
        LineChart lineChart = new LineChart((LineChartModel)usage);
        LineConfig receivedConfig = new LineConfig(ProfilerColors.NETWORK_RECEIVING_COLOR).setLegendIconType(LegendConfig.IconType.LINE);
        lineChart.configure(usage.getRxSeries(), receivedConfig);
        LineConfig sentConfig = new LineConfig(ProfilerColors.NETWORK_SENDING_COLOR).setLegendIconType(LegendConfig.IconType.LINE);
        lineChart.configure(usage.getTxSeries(), sentConfig);
        LineConfig connectionConfig = new LineConfig(ProfilerColors.NETWORK_CONNECTIONS_COLOR).setLegendIconType(LegendConfig.IconType.DASHED_LINE).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE);
        lineChart.configure(usage.getConnectionSeries(), connectionConfig);
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, "Center");
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((NetworkProfilerStage)this.getStage()).getTrafficAxis(), AxisComponent.AxisOrientation.RIGHT);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(true);
        leftAxis.setShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        AxisComponent rightAxis = new AxisComponent(((NetworkProfilerStage)this.getStage()).getConnectionsAxis(), AxisComponent.AxisOrientation.LEFT);
        rightAxis.setShowAxisLine(false);
        rightAxis.setShowMax(true);
        rightAxis.setShowUnitAtMax(true);
        rightAxis.setHideTickAtMin(true);
        rightAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        rightAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)rightAxis, "East");
        NetworkProfilerStage.NetworkStageLegends legends = ((NetworkProfilerStage)this.getStage()).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.configure((Legend)legends.getRxLegend(), new LegendConfig(lineChart.getLineConfig(usage.getRxSeries())));
        legend.configure((Legend)legends.getTxLegend(), new LegendConfig(lineChart.getLineConfig(usage.getTxSeries())));
        legend.configure((Legend)legends.getConnectionLegend(), new LegendConfig(lineChart.getLineConfig(usage.getConnectionSeries())));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        legendPanel.add((Component)legend, "East");
        ((NetworkProfilerStage)this.getStage()).getSelectionModel().addListener(new SelectionListener(){

            public void selectionCreated() {
                NetworkProfilerStageView.this.myConnectionsPanel.setVisible(true);
            }

            public void selectionCleared() {
                NetworkProfilerStageView.this.myConnectionsPanel.setVisible(false);
                NetworkProfilerStageView.this.myConnectionDetails.setHttpData(null);
            }
        });
        selection.addMouseListener((MouseListener)new ProfilerTooltipMouseAdapter((Stage)((Object)this.getStage()), () -> new NetworkTrafficTooltip((NetworkProfilerStage)this.getStage())));
        eventsView.registerTooltip(tooltip, (Stage)((Object)this.getStage()));
        tooltip.registerListenersOn((JComponent)selection);
        this.getProfilersView().installCommonMenuItems((JComponent)selection);
        if (!((NetworkProfilerStage)this.getStage()).hasUserUsedNetworkSelection()) {
            this.installProfilingInstructions((JPanel)monitorPanel);
        }
        monitorPanel.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)selection, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)axisPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
        layout.setRowSizing(1, "*");
        panel.add((Component)monitorPanel, new TabularLayout.Constraint(1, 0));
        return panel;
    }

    private void installProfilingInstructions(@NotNull JPanel parent) {
        assert (parent.getLayout().getClass() == TabularLayout.class);
        InstructionsPanel panel = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(UIUtilities.getFontMetrics((JComponent)parent, (Font)ProfilerFonts.H2_FONT), "Select a range to inspect network traffic")}).setEaseOut(((NetworkProfilerStage)this.getStage()).getInstructionsEaseOutModel(), instructionsPanel -> parent.remove((Component)instructionsPanel)).setBackgroundCornerRadius(ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER, ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER).build();
        parent.add((Component)panel, new TabularLayout.Constraint(0, 0));
    }

    private void updateConnectionDetailsView() {
        this.myConnectionDetails.setHttpData(((NetworkProfilerStage)this.getStage()).getSelectedConnection());
    }

    @Override
    @NotNull
    public JComponent getToolbar() {
        return new JPanel(new BorderLayout());
    }

    private boolean selectionHasTrafficUsageWithNoConnection() {
        boolean hasNoConnection;
        Range range = this.getTimeline().getSelectionRange();
        boolean bl = hasNoConnection = !range.isEmpty() && ((NetworkProfilerStage)this.getStage()).getConnectionsModel().getData(range).isEmpty();
        if (hasNoConnection) {
            DetailedNetworkUsage detailedNetworkUsage = ((NetworkProfilerStage)this.getStage()).getDetailedNetworkUsage();
            return NetworkProfilerStageView.hasTrafficUsage(detailedNetworkUsage.getRxSeries(), range) || NetworkProfilerStageView.hasTrafficUsage(detailedNetworkUsage.getTxSeries(), range);
        }
        return false;
    }

    private static boolean hasTrafficUsage(RangedContinuousSeries series, Range range) {
        int maxIndex;
        List list = series.getDataSeries().getDataForXRange(range);
        if (list.stream().anyMatch(data -> (double)data.x >= range.getMin() && (double)data.x <= range.getMax() && (Long)data.value > 0L)) {
            return true;
        }
        Function<Long, Integer> getInsertPoint = time -> {
            int index = Collections.binarySearch(list, new SeriesData(time.longValue(), (Object)0L), (o1, o2) -> Long.compare(o1.x, o2.x));
            return index < 0 ? -(index + 1) : index;
        };
        int minIndex = getInsertPoint.apply((long)range.getMin());
        if (minIndex == (maxIndex = getInsertPoint.apply((long)range.getMax()).intValue())) {
            return minIndex > 0 && (Long)((SeriesData)list.get((int)(minIndex - 1))).value > 0L && minIndex < list.size() && (Long)((SeriesData)list.get((int)minIndex)).value > 0L;
        }
        return false;
    }

    private /* synthetic */ void lambda$new$0(JTabbedPane connectionsTab, ChangeEvent evt) {
        this.myConnectionsPanel.repaint();
        int selectedIndex = connectionsTab.getSelectedIndex();
        if (selectedIndex == 0) {
            ((NetworkProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectNetworkConnectionsView();
        } else if (selectedIndex == 1) {
            ((NetworkProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectNetworkThreadsView();
        } else {
            throw new IllegalStateException("Missing tracking for tab " + connectionsTab.getTitleAt(selectedIndex));
        }
    }
}

