/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.android.tools.profilers.network.NetworkTrafficTooltip;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class NetworkTrafficTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final NetworkTrafficTooltip myTooltip;

    NetworkTrafficTooltipView(@NotNull NetworkProfilerStageView view, @NotNull NetworkTrafficTooltip tooltip) {
        super(view.getTimeline());
        this.myTooltip = tooltip;
    }

    @Override
    @NotNull
    protected JComponent createTooltip() {
        NetworkProfilerStage.NetworkStageLegends legends = this.myTooltip.getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setVerticalPadding(0).setOrientation(LegendComponent.Orientation.VERTICAL).build();
        legend.configure((Legend)legends.getRxLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.NETWORK_RECEIVING_COLOR));
        legend.configure((Legend)legends.getTxLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.NETWORK_SENDING_COLOR));
        legend.configure((Legend)legends.getConnectionLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.NETWORK_CONNECTIONS_COLOR));
        return legend;
    }
}

