/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.details.HttpDataComponentFactory;
import com.android.tools.profilers.network.details.TabContent;
import com.android.tools.profilers.network.details.TabUiUtils;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RequestTabContent
extends TabContent {
    private static final String HEADERS_TITLE = "Application Headers";
    private final IdeProfilerComponents myComponents;
    private final NetworkConnectionsModel myModel;
    private JPanel myPanel;

    public RequestTabContent(@NotNull IdeProfilerComponents components, @NotNull NetworkConnectionsModel model) {
        this.myComponents = components;
        this.myModel = model;
    }

    @Override
    @NotNull
    public String getTitle() {
        return "Request";
    }

    @Override
    @NotNull
    protected JComponent createComponent() {
        this.myPanel = TabUiUtils.createVerticalPanel(TabUiUtils.TAB_SECTION_VGAP);
        this.myPanel.setBorder((Border)new JBEmptyBorder(0, 15, 0, 15));
        return TabUiUtils.createVerticalScrollPane(this.myPanel);
    }

    @Override
    public void populateFor(@Nullable HttpData data) {
        this.myPanel.removeAll();
        if (data == null) {
            return;
        }
        HttpDataComponentFactory httpDataComponentFactory = new HttpDataComponentFactory(this.myModel, data);
        JComponent headersComponent = httpDataComponentFactory.createHeaderComponent(HttpDataComponentFactory.ConnectionType.REQUEST);
        this.myPanel.add((Component)TabUiUtils.createHideablePanel(HEADERS_TITLE, headersComponent, null));
        this.myPanel.add(httpDataComponentFactory.createBodyComponent(this.myComponents, HttpDataComponentFactory.ConnectionType.REQUEST));
    }

    @Override
    public void trackWith(@NotNull FeatureTracker featureTracker) {
        featureTracker.trackSelectNetworkDetailsRequest();
    }

    @Nullable
    @VisibleForTesting
    JComponent findPayloadBody() {
        return TabUiUtils.findComponentWithUniqueName(this.myPanel, HttpDataComponentFactory.ConnectionType.REQUEST.getBodyComponentId());
    }
}

