/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.ProfilerAction;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsView;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SessionArtifactView<T extends SessionArtifact>
extends JPanel {
    private static final String PREVIOUS = "Previous";
    private static final String NEXT = "Next";
    private static final String SELECT = "Select";
    private static final Border ARTIFACT_ICON_BORDER = JBUI.Borders.empty((int)2, (int)0);
    private static final Border EXPORT_ICON_BORDER = JBUI.Borders.empty((int)4);
    protected static final Border SELECTED_BORDER = JBUI.Borders.customLine((Color)ProfilerColors.SELECTED_SESSION_COLOR, (int)0, (int)3, (int)0, (int)0);
    protected static final Border UNSELECTED_BORDER = JBUI.Borders.emptyLeft((int)3);
    protected static final Border ARTIFACT_PADDING = JBUI.Borders.empty((int)3, (int)9, (int)3, (int)4);
    protected static final Border LABEL_PADDING = JBUI.Borders.empty((int)1, (int)8, (int)1, (int)0);
    protected static final Font TITLE_FONT = AdtUiUtils.DEFAULT_FONT.biggerOn(3.0f);
    protected static final Font STATUS_FONT = AdtUiUtils.DEFAULT_FONT.biggerOn(1.0f);
    private static final Icon EXPORT_ICON = StudioIcons.Profiler.Sessions.SAVE;
    private static final Icon EXPORT_ICON_HOVERED = IconUtil.darker((Icon)StudioIcons.Profiler.Sessions.SAVE, (int)3);
    @NotNull
    private final T myArtifact;
    @NotNull
    private final ArtifactDrawInfo myArtifactDrawInfo;
    @NotNull
    protected final AspectObserver myObserver;
    @NotNull
    private final JComponent myArtifactView;
    @Nullable
    private JComponent myExportLabel;
    @NotNull
    private final List<JComponent> myMouseListeningComponents;

    public SessionArtifactView(@NotNull ArtifactDrawInfo artifactDrawInfo, @NotNull T artifact) {
        this.setFocusable(true);
        this.myArtifactDrawInfo = artifactDrawInfo;
        this.myArtifact = artifact;
        this.myObserver = new AspectObserver();
        this.myMouseListeningComponents = new ArrayList<JComponent>();
        JComponent artifactView = this.buildComponent();
        if (artifact.canExport()) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder());
            artifactView.setOpaque(false);
            panel.add((Component)artifactView, "Center");
            this.myExportLabel = this.buildExportButton();
            this.myExportLabel.setVisible(false);
            this.addMouseListeningComponents(this.myExportLabel);
            panel.add((Component)this.myExportLabel, "East");
            this.myArtifactView = panel;
        } else {
            this.myArtifactView = artifactView;
        }
        this.myArtifactView.setBackground(ProfilerColors.HOVERED_SESSION_COLOR);
        this.myArtifactView.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myArtifactView, "Center");
        this.installContextMenus(this);
        this.addMouseListeningComponents(this);
        this.initializeMouseListeners();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PointerInfo info = MouseInfo.getPointerInfo();
                if (info != null) {
                    Point mousePosition = info.getLocation();
                    SwingUtilities.convertPointFromScreen(mousePosition, SessionArtifactView.this);
                    SessionArtifactView.this.showHoverState(SessionArtifactView.this.contains(mousePosition));
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SessionArtifactView.this.showHoverState(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SessionArtifactView.this.showHoverState(false);
            }
        });
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(40, 0), NEXT);
        inputMap.put(KeyStroke.getKeyStroke(38, 0), PREVIOUS);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), SELECT);
        ActionMap actionMap = this.getActionMap();
        actionMap.put(NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int artifactCount = ((SessionArtifactView)SessionArtifactView.this).myArtifactDrawInfo.mySessionsView.getSessionsPanel().getComponentCount();
                int nextIndex = Math.floorMod(((SessionArtifactView)SessionArtifactView.this).myArtifactDrawInfo.myIndex + 1, artifactCount);
                ((SessionArtifactView)SessionArtifactView.this).myArtifactDrawInfo.mySessionsView.getSessionsPanel().getComponent(nextIndex).requestFocusInWindow();
            }
        });
        actionMap.put(PREVIOUS, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int artifactCount = ((SessionArtifactView)SessionArtifactView.this).myArtifactDrawInfo.mySessionsView.getSessionsPanel().getComponentCount();
                int prevIndex = Math.floorMod(((SessionArtifactView)SessionArtifactView.this).myArtifactDrawInfo.myIndex - 1, artifactCount);
                ((SessionArtifactView)SessionArtifactView.this).myArtifactDrawInfo.mySessionsView.getSessionsPanel().getComponent(prevIndex).requestFocusInWindow();
            }
        });
        actionMap.put(SELECT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionArtifactView.this.getArtifact().onSelect();
            }
        });
    }

    protected void installContextMenus(@NotNull JComponent component) {
        ContextMenuInstaller contextMenuInstaller = this.getSessionsView().getIdeProfilerComponents().createContextMenuInstaller();
        this.getContextMenus().forEach(menu -> contextMenuInstaller.installGenericContextMenu(component, (ContextMenuItem)menu));
    }

    protected void addMouseListeningComponents(@NotNull JComponent comp) {
        this.myMouseListeningComponents.add(comp);
    }

    private void initializeMouseListeners() {
        for (JComponent comp : this.myMouseListeningComponents) {
            comp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && !e.isConsumed()) {
                        SessionArtifactView.this.myArtifact.onSelect();
                    }
                    SessionArtifactView.this.requestFocusInWindow();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    SessionArtifactView.this.showHoverState(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SessionArtifactView.this.showHoverState(false);
                }
            });
        }
    }

    @NotNull
    public SessionsView getSessionsView() {
        return this.myArtifactDrawInfo.mySessionsView;
    }

    @Nullable
    @VisibleForTesting
    public JComponent getExportLabel() {
        return this.myExportLabel;
    }

    @NotNull
    public T getArtifact() {
        return this.myArtifact;
    }

    @NotNull
    public StudioProfilers getProfilers() {
        return this.myArtifactDrawInfo.mySessionsView.getProfilers();
    }

    public boolean isSessionSelected() {
        return this.myArtifact.getSession().equals((Object)this.myArtifact.getProfilers().getSessionsManager().getSelectedSession());
    }

    public int getIndex() {
        return this.myArtifactDrawInfo.myIndex;
    }

    @NotNull
    protected List<ContextMenuItem> getContextMenus() {
        ArrayList<ContextMenuItem> menus = new ArrayList<ContextMenuItem>();
        ProfilerAction action = new ProfilerAction.Builder("Export...").setEnableBooleanSupplier(() -> !this.getArtifact().isOngoing()).setActionRunnable(() -> this.exportArtifact()).build();
        menus.add(action);
        return menus;
    }

    @NotNull
    protected abstract JComponent buildComponent();

    protected void exportArtifact() {
    }

    private void showHoverState(boolean hover) {
        if (this.myExportLabel != null) {
            this.myExportLabel.setVisible(hover);
        }
        this.myArtifactView.setOpaque(hover);
        this.myArtifactView.repaint();
    }

    @NotNull
    protected JComponent buildCaptureArtifactView(@NotNull String name, @NotNull String subtitle, @NotNull Icon icon, boolean isOngoing) {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("Fit,*", "Fit,Fit"));
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new BoxLayout(iconPanel, 1));
        iconPanel.setOpaque(false);
        Object iconLabel = isOngoing ? new AsyncProcessIcon("") : new JLabel(icon);
        ((JComponent)iconLabel).setBorder(ARTIFACT_ICON_BORDER);
        iconPanel.add((Component)iconLabel);
        iconPanel.add(Box.createHorizontalGlue());
        panel.add((Component)iconPanel, new TabularLayout.Constraint(0, 0, 2, 1));
        JLabel artifactName = new JLabel(name);
        artifactName.setBorder(LABEL_PADDING);
        artifactName.setFont(TITLE_FONT);
        artifactName.setForeground(StandardColors.TEXT_COLOR);
        JLabel artifactTime = new JLabel(subtitle);
        artifactTime.setBorder(LABEL_PADDING);
        artifactTime.setFont(STATUS_FONT);
        artifactTime.setForeground(AdtUiUtils.overlayColor((int)artifactTime.getBackground().getRGB(), (int)StandardColors.TEXT_COLOR.getRGB(), (float)0.6f));
        panel.add((Component)artifactName, new TabularLayout.Constraint(0, 1));
        panel.add((Component)artifactTime, new TabularLayout.Constraint(1, 1));
        CompoundBorder selectedBorder = BorderFactory.createCompoundBorder(SELECTED_BORDER, ARTIFACT_PADDING);
        CompoundBorder unSelectedBorder = BorderFactory.createCompoundBorder(UNSELECTED_BORDER, ARTIFACT_PADDING);
        this.getProfilers().getSessionsManager().addDependency(this.myObserver).onChange((Enum)SessionAspect.SELECTED_SESSION, () -> panel.setBorder(this.isSessionSelected() ? selectedBorder : unSelectedBorder));
        panel.setBorder(this.isSessionSelected() ? selectedBorder : unSelectedBorder);
        return panel;
    }

    @NotNull
    private JComponent buildExportButton() {
        final JLabel export = new JLabel(EXPORT_ICON);
        export.setBorder(EXPORT_ICON_BORDER);
        export.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    SessionArtifactView.this.exportArtifact();
                    e.consume();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                export.setIcon(EXPORT_ICON_HOVERED);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                export.setIcon(EXPORT_ICON);
            }
        });
        export.setToolTipText("Export " + this.getArtifact().getName());
        export.setVerticalAlignment(0);
        return export;
    }

    public static class ArtifactDrawInfo {
        @NotNull
        final SessionsView mySessionsView;
        final int myIndex;

        ArtifactDrawInfo(@NotNull SessionsView sessionsView, int index) {
            this.mySessionsView = sessionsView;
            this.myIndex = index;
        }
    }
}

