/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCaptureSessionArtifact;
import com.android.tools.profilers.memory.HprofSessionArtifact;
import com.android.tools.profilers.memory.LegacyAllocationsSessionArtifact;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SessionsManager
extends AspectModel<SessionAspect> {
    private static final SessionArtifactComparator ARTIFACT_COMPARATOR = new SessionArtifactComparator();
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private Map<Long, SessionItem> mySessionItems;
    @NotNull
    private Map<Long, Common.SessionMetaData> mySessionMetaDatas;
    @NotNull
    private List<SessionArtifact> mySessionArtifacts;
    @NotNull
    private Common.Session mySelectedSession;
    @NotNull
    private Common.Session myProfilingSession;
    private final Map<Long, Range> mySessionViewRangeMap;
    private final Map<String, Consumer<File>> myImportHandlers = new HashMap<String, Consumer<File>>();
    private int importedSessionCount = 0;
    @NotNull
    private final List<ArtifactFetcher> myArtifactsFetchers;

    public SessionsManager(@NotNull StudioProfilers profilers) {
        this.myProfilers = profilers;
        this.mySelectedSession = this.myProfilingSession = Common.Session.getDefaultInstance();
        this.mySessionItems = new HashMap<Long, SessionItem>();
        this.mySessionMetaDatas = new HashMap<Long, Common.SessionMetaData>();
        this.mySessionMetaDatas.put(Common.Session.getDefaultInstance().getSessionId(), Common.SessionMetaData.getDefaultInstance());
        this.mySessionArtifacts = new ArrayList<SessionArtifact>();
        this.mySessionViewRangeMap = new HashMap<Long, Range>();
        this.myArtifactsFetchers = new ArrayList<ArtifactFetcher>();
        this.myArtifactsFetchers.add(HprofSessionArtifact::getSessionArtifacts);
        this.myArtifactsFetchers.add(LegacyAllocationsSessionArtifact::getSessionArtifacts);
        this.myArtifactsFetchers.add(CpuCaptureSessionArtifact::getSessionArtifacts);
    }

    @NotNull
    public Common.Session getSelectedSession() {
        return this.mySelectedSession;
    }

    @NotNull
    public Common.Session getProfilingSession() {
        return this.myProfilingSession;
    }

    @NotNull
    public Common.SessionMetaData getSelectedSessionMetaData() {
        return this.mySessionMetaDatas.get(this.mySelectedSession.getSessionId());
    }

    @NotNull
    public List<SessionArtifact> getSessionArtifacts() {
        return this.mySessionArtifacts;
    }

    public boolean isSessionAlive() {
        return SessionsManager.isSessionAlive(this.mySelectedSession);
    }

    public static boolean isSessionAlive(@NotNull Common.Session session) {
        return session.getEndTimestamp() == Long.MAX_VALUE;
    }

    @NotNull
    public Range getSessionPreferredViewRange(@NotNull Common.Session session) {
        double viewRangeMin = TimeUnit.NANOSECONDS.toMicros(session.getStartTimestamp());
        double viewRangeMax = TimeUnit.NANOSECONDS.toMicros(session.getEndTimestamp());
        if (this.mySessionViewRangeMap.containsKey(session.getSessionId())) {
            Range cachedRange = this.mySessionViewRangeMap.get(session.getSessionId());
            viewRangeMin = Math.max(viewRangeMin, cachedRange.getMin());
            viewRangeMax = Math.min(viewRangeMax, cachedRange.getMax());
        }
        return new Range(viewRangeMin, viewRangeMax);
    }

    public void update() {
        if (this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            this.updateSessions();
        } else {
            Profiler.GetSessionsResponse sessionsResponse = this.myProfilers.getClient().getProfilerClient().getSessions(Profiler.GetSessionsRequest.getDefaultInstance());
            this.updateSessionItems(sessionsResponse.getSessionsList());
        }
    }

    private void updateSessions() {
        assert (this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled());
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setKind(Common.Event.Kind.SESSION).build();
        Transport.GetEventGroupsResponse response = this.myProfilers.getClient().getTransportClient().getEventGroups(request);
        this.updateSessionItemsByGroup(response.getGroupsList());
    }

    private void updateSessionItemsByGroup(List<Transport.EventGroup> groups) {
        ArrayList<SessionArtifact> sessionArtifacts = new ArrayList<SessionArtifact>();
        List previousArtifactProtos = this.mySessionArtifacts.stream().map(artifact -> artifact.getArtifactProto()).collect(Collectors.toList());
        groups.forEach(group -> {
            SessionItem sessionItem = this.mySessionItems.get(group.getGroupId());
            boolean sessionStateChanged = false;
            if (sessionItem == null) {
                sessionItem = this.processSessionStarted(group.getEvents(0));
                this.setProfilingSession(sessionItem.getSession());
                sessionStateChanged = true;
            }
            if (group.getEventsCount() == 2 && sessionItem.isOngoing()) {
                Common.Session session = sessionItem.getSession().toBuilder().setEndTimestamp(group.getEvents(1).getTimestamp()).build();
                sessionItem.setSession(session);
                sessionStateChanged = true;
            }
            if (sessionStateChanged) {
                this.setSessionInternal(sessionItem.getSession());
            }
            SessionItem item = sessionItem;
            sessionArtifacts.add(item);
            ArrayList<SessionArtifact> artifacts = new ArrayList<SessionArtifact>();
            this.myArtifactsFetchers.forEach(fetcher -> artifacts.addAll(fetcher.fetch(this.myProfilers, item.getSession(), item.getSessionMetaData())));
            item.setChildArtifacts(artifacts);
            if (item.getSessionMetaData().getType() == Common.SessionMetaData.SessionType.FULL) {
                sessionArtifacts.addAll(artifacts);
            }
            Collections.sort(sessionArtifacts, ARTIFACT_COMPARATOR);
        });
        List newArtifactProtos = sessionArtifacts.stream().map(artifact -> artifact.getArtifactProto()).collect(Collectors.toList());
        if (!previousArtifactProtos.equals(newArtifactProtos)) {
            this.mySessionArtifacts.forEach(artifact -> this.myProfilers.getUpdater().unregister((Updatable)artifact));
            this.mySessionArtifacts = sessionArtifacts;
            this.changed(SessionAspect.SESSIONS);
            this.mySessionArtifacts.forEach(artifact -> this.myProfilers.getUpdater().register((Updatable)artifact));
        }
    }

    private SessionItem processSessionStarted(Common.Event event) {
        Common.SessionData.SessionStarted sessionData = event.getSession().getSessionStarted();
        Common.Session session = Common.Session.newBuilder().setSessionId(sessionData.getSessionId()).setPid(sessionData.getPid()).setStartTimestamp(event.getTimestamp()).setEndTimestamp(Long.MAX_VALUE).setStreamId(sessionData.getStreamId()).build();
        Common.SessionMetaData metadata = Common.SessionMetaData.newBuilder().setSessionId(session.getSessionId()).setType(Common.SessionMetaData.SessionType.forNumber((int)sessionData.getType().getNumber())).setStartTimestampEpochMs(sessionData.getStartTimestampEpochMs()).setProcessAbi(sessionData.getProcessAbi()).setJvmtiEnabled(sessionData.getJvmtiEnabled()).setSessionName(sessionData.getSessionName()).setLiveAllocationEnabled(sessionData.getLiveAllocationEnabled()).build();
        SessionItem sessionItem = new SessionItem(this.myProfilers, session, metadata);
        this.mySessionItems.put(session.getSessionId(), sessionItem);
        this.mySessionMetaDatas.put(session.getSessionId(), metadata);
        return sessionItem;
    }

    public void setSession(@NotNull Common.Session session) {
        this.myProfilers.setAutoProfilingEnabled(false);
        this.setSessionInternal(session);
    }

    private void setSessionInternal(@NotNull Common.Session session) {
        if (session.equals((Object)this.mySelectedSession)) {
            return;
        }
        assert (Common.Session.getDefaultInstance().equals((Object)session) || this.mySessionItems.containsKey(session.getSessionId()) && this.mySessionItems.get(session.getSessionId()).getSession().equals((Object)session));
        if (!Common.Session.getDefaultInstance().equals((Object)this.mySelectedSession)) {
            this.mySessionViewRangeMap.put(this.mySelectedSession.getSessionId(), new Range(this.myProfilers.getTimeline().getViewRange()));
        }
        this.mySelectedSession = session;
        this.changed(SessionAspect.SELECTED_SESSION);
    }

    private void setProfilingSession(@NotNull Common.Session session) {
        if (session.equals((Object)this.myProfilingSession)) {
            return;
        }
        this.myProfilingSession = session;
        this.changed(SessionAspect.PROFILING_SESSION);
    }

    public void beginSession(@NotNull Common.Device device, @NotNull Common.Process process) {
        this.beginSession(0L, device, process);
    }

    public void beginSession(long streamId, @NotNull Common.Device device, @NotNull Common.Process process) {
        assert (Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession));
        assert (device.getState() == Common.Device.State.ONLINE);
        assert (process.getState() == Common.Process.State.ALIVE);
        if (this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            assert (streamId != 0L);
            Commands.BeginSession.Builder requestBuilder = Commands.BeginSession.newBuilder().setSessionName(StudioProfilers.buildSessionName(device, process)).setRequestTimeEpochMs(System.currentTimeMillis()).setProcessAbi(process.getAbiCpuArch());
            if (device.getFeatureLevel() >= 26) {
                requestBuilder.setJvmtiConfig(Commands.BeginSession.JvmtiConfig.newBuilder().setAttachAgent(true).setAgentLibFileName(String.format("libjvmtiagent_%s.so", process.getAbiCpuArch())).setAgentConfigPath("/data/local/tmp/perfd/agent.config").setLiveAllocationEnabled(this.myProfilers.getIdeServices().getFeatureConfig().isLiveAllocationsEnabled()).build());
            }
            Commands.Command command = Commands.Command.newBuilder().setStreamId(streamId).setPid(process.getPid()).setBeginSession(requestBuilder).setType(Commands.Command.CommandType.BEGIN_SESSION).build();
            this.myProfilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(command).build());
        } else {
            Profiler.BeginSessionRequest.Builder requestBuilder = Profiler.BeginSessionRequest.newBuilder().setDeviceId(device.getDeviceId()).setPid(process.getPid()).setSessionName(StudioProfilers.buildSessionName(device, process)).setRequestTimeEpochMs(System.currentTimeMillis()).setProcessAbi(process.getAbiCpuArch());
            if (device.getFeatureLevel() >= 26) {
                requestBuilder.setJvmtiConfig(Profiler.BeginSessionRequest.JvmtiConfig.newBuilder().setAttachAgent(true).setAgentLibFileName(String.format("libjvmtiagent_%s.so", process.getAbiCpuArch())).setAgentConfigPath("/data/local/tmp/perfd/agent.config").setLiveAllocationEnabled(this.myProfilers.getIdeServices().getFeatureConfig().isLiveAllocationsEnabled()).build());
            }
            Profiler.BeginSessionResponse response = this.myProfilers.getClient().getProfilerClient().beginSession(requestBuilder.build());
            Common.Session session = response.getSession();
            this.setProfilingSession(session);
            this.updateSessionItems(Collections.singletonList(session));
            this.setSessionInternal(session);
        }
    }

    public void endCurrentSession() {
        if (Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession)) {
            return;
        }
        Common.Session profilingSession = this.myProfilingSession;
        boolean selectedSessionIsProfilingSession = this.myProfilingSession.equals((Object)this.mySelectedSession);
        this.setProfilingSession(Common.Session.getDefaultInstance());
        if (this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Commands.Command command = Commands.Command.newBuilder().setStreamId(profilingSession.getStreamId()).setPid(profilingSession.getPid()).setEndSession(Commands.EndSession.newBuilder().setSessionId(profilingSession.getSessionId())).setType(Commands.Command.CommandType.END_SESSION).build();
            this.myProfilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(command).build());
        } else {
            Profiler.EndSessionResponse response = this.myProfilers.getClient().getProfilerClient().endSession(Profiler.EndSessionRequest.newBuilder().setDeviceId(profilingSession.getStreamId()).setSessionId(profilingSession.getSessionId()).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)this.myProfilers.getTimeline().getDataRange().getMax())).build());
            Common.Session session = response.getSession();
            this.updateSessionItems(Collections.singletonList(session));
            if (selectedSessionIsProfilingSession) {
                this.setSessionInternal(session);
            }
        }
    }

    public void deleteSession(@NotNull Common.Session session) {
        assert (this.mySessionItems.containsKey(session.getSessionId()) && this.mySessionItems.get(session.getSessionId()).getSession().equals((Object)session));
        boolean sessionIsSelectedSession = this.mySelectedSession.equals((Object)session);
        if (this.myProfilingSession.equals((Object)session)) {
            this.myProfilers.setProcess(null, null);
        }
        if (sessionIsSelectedSession) {
            this.setSessionInternal(Common.Session.getDefaultInstance());
        }
        Profiler.DeleteSessionRequest request = Profiler.DeleteSessionRequest.newBuilder().setSessionId(session.getSessionId()).build();
        this.myProfilers.getClient().getProfilerClient().deleteSession(request);
        this.mySessionItems.remove(session.getSessionId());
        this.updateSessionItems(Collections.emptyList());
    }

    @NotNull
    public Common.Session createImportedSession(@NotNull String sessionName, @NotNull Common.SessionMetaData.SessionType sessionType, long startTimestampNs, long endTimestampNs, long startTimestampEpochMs) {
        Common.Session session = Common.Session.newBuilder().setSessionId((long)this.generateUniqueSessionId()).setStartTimestamp(startTimestampNs).setEndTimestamp(endTimestampNs).build();
        if (!this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Profiler.ImportSessionRequest sessionRequest = Profiler.ImportSessionRequest.newBuilder().setSession(session).setSessionName(sessionName).setSessionType(sessionType).setStartTimestampEpochMs(startTimestampEpochMs).build();
            this.myProfilers.getClient().getProfilerClient().importSession(sessionRequest);
        }
        return session;
    }

    public void registerImportHandler(@NotNull String extension, @NotNull Consumer<File> handler) {
        this.myImportHandlers.put(extension, handler);
    }

    public boolean importSessionFromFile(@NotNull File file) {
        int indexOfDot = file.getName().lastIndexOf(46);
        if (indexOfDot == -1) {
            return false;
        }
        String extension = file.getName().substring(indexOfDot + 1).toLowerCase(Locale.US);
        if (this.myImportHandlers.get(extension) == null) {
            return false;
        }
        this.myImportHandlers.get(extension).accept(file);
        return true;
    }

    private int generateUniqueSessionId() {
        return ++this.importedSessionCount;
    }

    private void updateSessionItems(@NotNull List<Common.Session> sessions) {
        List previousProtos = this.mySessionArtifacts.stream().map(artifact -> artifact.getArtifactProto()).collect(Collectors.toList());
        sessions.forEach(session -> {
            SessionItem sessionItem = this.mySessionItems.get(session.getSessionId());
            if (sessionItem == null) {
                if (!this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
                    Profiler.GetSessionMetaDataResponse response = this.myProfilers.getClient().getProfilerClient().getSessionMetaData(Profiler.GetSessionMetaDataRequest.newBuilder().setSessionId(session.getSessionId()).build());
                    Common.SessionMetaData metadata = response.getData();
                    sessionItem = new SessionItem(this.myProfilers, (Common.Session)session, metadata);
                    this.mySessionItems.put(session.getSessionId(), sessionItem);
                    this.mySessionMetaDatas.put(session.getSessionId(), metadata);
                }
            } else {
                sessionItem.setSession((Common.Session)session);
            }
        });
        ArrayList<SessionArtifact> sessionArtifacts = new ArrayList<SessionArtifact>();
        for (SessionItem item : this.mySessionItems.values()) {
            sessionArtifacts.add(item);
            ArrayList<SessionArtifact> artifacts = new ArrayList<SessionArtifact>();
            this.myArtifactsFetchers.forEach(fetcher -> artifacts.addAll(fetcher.fetch(this.myProfilers, item.getSession(), item.getSessionMetaData())));
            item.setChildArtifacts(artifacts);
            if (item.getSessionMetaData().getType() != Common.SessionMetaData.SessionType.FULL) continue;
            sessionArtifacts.addAll(artifacts);
        }
        Collections.sort(sessionArtifacts, ARTIFACT_COMPARATOR);
        List newProtos = sessionArtifacts.stream().map(artifact -> artifact.getArtifactProto()).collect(Collectors.toList());
        if (!previousProtos.equals(newProtos)) {
            this.mySessionArtifacts.forEach(artifact -> this.myProfilers.getUpdater().unregister((Updatable)artifact));
            this.mySessionArtifacts = sessionArtifacts;
            this.changed(SessionAspect.SESSIONS);
            this.mySessionArtifacts.forEach(artifact -> this.myProfilers.getUpdater().register((Updatable)artifact));
        }
    }

    private static class SessionArtifactComparator
    implements Comparator<SessionArtifact> {
        private SessionArtifactComparator() {
        }

        @Override
        public int compare(SessionArtifact artifact1, SessionArtifact artifact2) {
            int result = Long.compare(artifact2.getSessionMetaData().getStartTimestampEpochMs(), artifact1.getSessionMetaData().getStartTimestampEpochMs());
            if (result != 0) {
                return result;
            }
            if (artifact1 instanceof SessionItem) {
                return -1;
            }
            if (artifact2 instanceof SessionItem) {
                return 1;
            }
            return Long.compare(artifact2.getTimestampNs(), artifact1.getTimestampNs());
        }
    }

    private static interface ArtifactFetcher {
        public List<SessionArtifact> fetch(@NotNull StudioProfilers var1, @NotNull Common.Session var2, @NotNull Common.SessionMetaData var3);
    }

    public static enum SessionCreationSource {
        MANUAL;

    }
}

