/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.stacktrace;

import com.android.tools.profilers.stacktrace.CodeLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StackFrameParser {
    @NotNull
    private final String myLine;

    public StackFrameParser(@NotNull String line) {
        this.myLine = line;
    }

    @Nullable
    public String getClassName() {
        int lastDot = this.getLastDot();
        if (lastDot == -1) {
            return null;
        }
        return this.myLine.substring(0, lastDot);
    }

    @Nullable
    public String getFileName() {
        int start = this.getOpenParen();
        int end = this.getLastColon();
        if (start == -1 || start >= end) {
            return null;
        }
        return this.myLine.substring(start + 1, end);
    }

    @Nullable
    public String getMethodName() {
        int start = this.getLastDot();
        int end = this.getOpenParen();
        if (start == -1 || start >= end) {
            return null;
        }
        return this.myLine.substring(start + 1, end);
    }

    public int getLineNumber() {
        int end;
        int start = this.getLastColon();
        if (start >= (end = this.getCloseParen()) || start == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(this.myLine.substring(start + 1, end));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getLastColon() {
        return this.myLine.lastIndexOf(58);
    }

    public int getLastDot() {
        return this.myLine.lastIndexOf(46, this.getOpenParen());
    }

    public int getOpenParen() {
        return this.myLine.indexOf(40);
    }

    public int getCloseParen() {
        return this.myLine.indexOf(41);
    }

    @NotNull
    public CodeLocation toCodeLocation() {
        String className = this.getClassName();
        if (className == null) {
            throw new IllegalStateException(String.format("Trying to create CodeLocation from an incomplete StackFrameParser. Line contents: '%s'", this.myLine));
        }
        return new CodeLocation.Builder(className).setFileName(this.getFileName()).setMethodName(this.getMethodName()).setLineNumber(this.getLineNumber() - 1).build();
    }
}

