/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.collections;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 (*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001(B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u0013\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u001b\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0004J\u0016\u0010\"\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u001b\u0010$\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010#\u001a\u00020\u0004J\b\u0010%\u001a\u00020&H\u0016J\u0013\u0010'\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006)"}, d2={"Ltrebuchet/collections/SparseArray;", "E", "", "initialCapacity", "", "(I)V", "mGarbage", "", "mKeys", "", "mSize", "mValues", "", "[Ljava/lang/Object;", "append", "", "key", "value", "(ILjava/lang/Object;)V", "clear", "delete", "gc", "get", "(I)Ljava/lang/Object;", "valueIfKeyNotFound", "(ILjava/lang/Object;)Ljava/lang/Object;", "indexOfKey", "indexOfValue", "(Ljava/lang/Object;)I", "keyAt", "index", "put", "remove", "removeAt", "removeAtRange", "size", "setValueAt", "toString", "", "valueAt", "Companion", "intellij.android.profilers.atrace"})
public final class SparseArray<E> {
    private boolean mGarbage;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;
    private static final Object DELETED;
    @NotNull
    private static final int[] EMPTY_INTS;
    @NotNull
    private static final Object[] EMPTY_OBJECTS;
    public static final Companion Companion;

    @Nullable
    public final E get(int key) {
        return this.get(key, null);
    }

    @Nullable
    public final E get(int key, @Nullable E valueIfKeyNotFound) {
        int i = Companion.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0 || this.mValues[i] == DELETED) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i];
    }

    public final void delete(int key) {
        int i = Companion.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            this.mValues[i] = DELETED;
            this.mGarbage = true;
        }
    }

    public final void remove(int key) {
        this.delete(key);
    }

    public final void removeAt(int index) {
        if (this.mValues[index] != DELETED) {
            this.mValues[index] = DELETED;
            this.mGarbage = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeAtRange(int index, int size) {
        int n = this.mSize;
        int n2 = index + size;
        n = index;
        int end = Math.min(n, n2);
        if (n <= (n2 = end - 1)) {
            while (true) {
                void i;
                this.removeAt((int)i);
                if (i == n2) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void gc() {
        int n = this.mSize;
        int o = 0;
        int[] keys = this.mKeys;
        Object[] values = this.mValues;
        int n2 = 0;
        int n3 = n - 1;
        if (n2 <= n3) {
            while (true) {
                void i;
                Object val;
                if ((val = values[i]) != DELETED) {
                    if (i != o) {
                        keys[o] = keys[i];
                        values[o] = val;
                        values[i] = null;
                    }
                    ++o;
                }
                if (i == n3) break;
                ++i;
            }
        }
        this.mGarbage = false;
        this.mSize = o;
    }

    public final void put(int key, E value) {
        int i = Companion.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            if ((i ^= 0xFFFFFFFF) < this.mSize && this.mValues[i] == DELETED) {
                this.mKeys[i] = key;
                this.mValues[i] = value;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                i = ~Companion.binarySearch(this.mKeys, this.mSize, key);
            }
            if (this.mSize >= this.mKeys.length) {
                int n = Companion.idealIntArraySize(this.mSize + 1);
                int[] nkeys = new int[n];
                Object[] nvalues = new Object[n];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
                System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
            }
            this.mKeys[i] = key;
            this.mValues[i] = value;
            int n = this.mSize;
            this.mSize = n + 1;
        }
    }

    public final int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public final int keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    public final E valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    public final void setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    public final int indexOfKey(int key) {
        if (this.mGarbage) {
            this.gc();
        }
        return Companion.binarySearch(this.mKeys, this.mSize, key);
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOfValue(E value) {
        int n;
        int n2;
        if (this.mGarbage) {
            this.gc();
        }
        if ((n2 = 0) <= (n = this.mSize - 1)) {
            while (true) {
                void i;
                if (this.mValues[i] == value) {
                    return (int)i;
                }
                if (i == n) break;
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void clear() {
        int n = this.mSize;
        Object[] values = this.mValues;
        int n2 = 0;
        int n3 = n - 1;
        if (n2 <= n3) {
            while (true) {
                void i;
                values[i] = null;
                if (i == n3) break;
                ++i;
            }
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public final void append(int key, E value) {
        int pos;
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((pos = this.mSize) >= this.mKeys.length) {
            int n = Companion.idealIntArraySize(pos + 1);
            int[] nkeys = new int[n];
            Object[] nvalues = new Object[n];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        int n = 0;
        int n2 = this.mSize - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (i > 0) {
                    buffer.append(", ");
                }
                int key = this.keyAt((int)i);
                buffer.append(key);
                buffer.append('=');
                E value = this.valueAt((int)i);
                if (value != this) {
                    buffer.append(value);
                } else {
                    buffer.append("(this Map)");
                }
                if (i == n2) break;
                ++i;
            }
        }
        buffer.append('}');
        return buffer.toString();
    }

    public SparseArray(int initialCapacity) {
        if (initialCapacity == 0) {
            this.mKeys = EMPTY_INTS;
            this.mValues = EMPTY_OBJECTS;
        } else {
            int idealSize = Companion.idealIntArraySize(initialCapacity);
            this.mKeys = new int[idealSize];
            this.mValues = new Object[idealSize];
        }
    }

    public /* synthetic */ SparseArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    public SparseArray() {
        this(0, 1, null);
    }

    static {
        Companion = new Companion(null);
        DELETED = new Object();
        EMPTY_INTS = new int[0];
        EMPTY_OBJECTS = new Object[0];
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ltrebuchet/collections/SparseArray$Companion;", "", "()V", "DELETED", "EMPTY_INTS", "", "getEMPTY_INTS", "()[I", "EMPTY_OBJECTS", "", "getEMPTY_OBJECTS", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "binarySearch", "", "array", "size", "value", "idealByteArraySize", "need", "idealIntArraySize", "intellij.android.profilers.atrace"})
    public static final class Companion {
        @NotNull
        public final int[] getEMPTY_INTS() {
            return EMPTY_INTS;
        }

        @NotNull
        public final Object[] getEMPTY_OBJECTS() {
            return EMPTY_OBJECTS;
        }

        public final int idealIntArraySize(int need) {
            return this.idealByteArraySize(need * 4) / 4;
        }

        /*
         * WARNING - void declaration
         */
        public final int idealByteArraySize(int need) {
            int n = 4;
            int n2 = 31;
            while (n <= n2) {
                void i;
                if (need <= (1 << i) - 12) {
                    return (1 << i) - 12;
                }
                ++i;
            }
            return need;
        }

        public final int binarySearch(@NotNull int[] array, int size, int value) {
            int lo = 0;
            int hi = size - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int midVal = array[mid];
                if (midVal < value) {
                    lo = mid + 1;
                    continue;
                }
                if (midVal > value) {
                    hi = mid - 1;
                    continue;
                }
                return mid;
            }
            return ~lo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

