/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.io;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import trebuchet.io.DataSlice;
import trebuchet.io.DataSliceKt;
import trebuchet.io.StreamingReader;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003J\u001a\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001a0\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001d"}, d2={"Ltrebuchet/io/StreamingLineReader;", "", "maxLineLength", "", "stream", "Ltrebuchet/io/StreamingReader;", "(ILtrebuchet/io/StreamingReader;)V", "getMaxLineLength", "()I", "getStream", "()Ltrebuchet/io/StreamingReader;", "tmpBuffer", "", "getTmpBuffer", "()[B", "tmpBufferSlice", "Ltrebuchet/io/DataSlice;", "getTmpBufferSlice", "()Ltrebuchet/io/DataSlice;", "tmpSlice", "getTmpSlice", "findNewlineInWindow", "window", "Ltrebuchet/io/StreamingReader$Window;", "startIndex", "forEachLine", "", "lineCallback", "Lkotlin/Function1;", "intellij.android.profilers.atrace"})
public final class StreamingLineReader {
    @NotNull
    private final byte[] tmpBuffer;
    @NotNull
    private final DataSlice tmpBufferSlice;
    @NotNull
    private final DataSlice tmpSlice;
    private final int maxLineLength;
    @NotNull
    private final StreamingReader stream;

    @NotNull
    public final byte[] getTmpBuffer() {
        return this.tmpBuffer;
    }

    @NotNull
    public final DataSlice getTmpBufferSlice() {
        return this.tmpBufferSlice;
    }

    @NotNull
    public final DataSlice getTmpSlice() {
        return this.tmpSlice;
    }

    /*
     * WARNING - void declaration
     */
    public final void forEachLine(@NotNull Function1<? super DataSlice, Unit> lineCallback) {
        int lineStartIndex = this.stream.getStartIndex();
        while (true) {
            int lineEndIndexInclusive;
            StreamingReader.Window window;
            int index = lineStartIndex;
            int foundAt = -1;
            while ((index <= this.stream.getEndIndex() || this.stream.loadIndex(index)) && (foundAt = this.findNewlineInWindow(window = this.stream.windowFor(index), index)) == -1) {
                index = window.getGlobalEndIndex() + 1;
            }
            if (lineStartIndex > this.stream.getEndIndex()) {
                return;
            }
            if (foundAt == -1) {
                foundAt = this.stream.getEndIndex() + 1;
            }
            int nextStart = foundAt + 1;
            if (this.stream.get(foundAt - 1) == (byte)13) {
                --foundAt;
            }
            if ((lineEndIndexInclusive = foundAt - 1) - lineStartIndex < this.maxLineLength) {
                StreamingReader.Window window2 = this.stream.windowFor(lineStartIndex);
                if (window2 == this.stream.windowFor(lineEndIndexInclusive)) {
                    void endIndex$iv;
                    void startIndex$iv;
                    void this_$iv;
                    void dest$iv;
                    DataSlice dataSlice = window2.getSlice();
                    int n = lineStartIndex - window2.getGlobalStartIndex();
                    int n2 = lineEndIndexInclusive - window2.getGlobalStartIndex() + 1;
                    DataSlice dataSlice2 = this.tmpSlice;
                    Function1<? super DataSlice, Unit> function1 = lineCallback;
                    boolean $i$f$slice = false;
                    dest$iv.set(this_$iv.getBuffer(), this_$iv.getStartIndex() + startIndex$iv, this_$iv.getStartIndex() + endIndex$iv);
                    void var14_15 = dest$iv;
                    function1.invoke((Object)var14_15);
                } else {
                    this.stream.copyTo(this.tmpBuffer, lineStartIndex, lineEndIndexInclusive);
                    this.tmpBufferSlice.set(this.tmpBuffer, 0, lineEndIndexInclusive - lineStartIndex + 1);
                    lineCallback.invoke((Object)this.tmpBufferSlice);
                }
            }
            lineStartIndex = nextStart;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int findNewlineInWindow(@NotNull StreamingReader.Window window, int startIndex) {
        int n = startIndex;
        int n2 = window.getGlobalEndIndex();
        if (n <= n2) {
            while (true) {
                void this_$iv$iv;
                void i;
                StreamingReader.Window this_$iv = window;
                boolean $i$f$get = false;
                DataSlice dataSlice = this_$iv.getSlice();
                void i$iv$iv = i - this_$iv.getGlobalStartIndex();
                boolean $i$f$get2 = false;
                if (this_$iv$iv.getBuffer()[this_$iv$iv.getStartIndex() + i$iv$iv] == (byte)10) {
                    return (int)i;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return -1;
    }

    public final int getMaxLineLength() {
        return this.maxLineLength;
    }

    @NotNull
    public final StreamingReader getStream() {
        return this.stream;
    }

    public StreamingLineReader(int maxLineLength, @NotNull StreamingReader stream) {
        this.maxLineLength = maxLineLength;
        this.stream = stream;
        if (this.maxLineLength > this.stream.getKeepLoadedSize()) {
            throw (Throwable)new IllegalArgumentException("Cannot have a maxLineLength (" + this.maxLineLength + ") that's bigger than " + "the StreamingReader's window size (" + this.stream.getKeepLoadedSize());
        }
        this.tmpBuffer = new byte[this.maxLineLength];
        this.tmpBufferSlice = DataSliceKt.asSlice$default(this.tmpBuffer, 0, 1, null);
        this.tmpSlice = new DataSlice();
    }
}

