/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public enum ArtifactKind {
    ARTIFACT("", "jar"),
    SOURCES("sources", "jar"),
    JAVADOC("javadoc", "jar"),
    ANNOTATIONS("annotations", "zip"),
    AAR_ARTIFACT("", "aar"),
    POM("", "pom");

    private final String myClassifier;
    private final String myExtension;

    private ArtifactKind(String classifier, String extension) {
        this.myClassifier = classifier;
        this.myExtension = extension;
    }

    @NotNull
    public String getClassifier() {
        return this.myClassifier;
    }

    @NotNull
    public String getExtension() {
        return this.myExtension;
    }

    public static ArtifactKind find(String classifier, String extension) {
        for (ArtifactKind kind : ArtifactKind.values()) {
            if (!kind.getClassifier().equals(classifier) || !kind.getExtension().equals(extension)) continue;
            return kind;
        }
        return null;
    }

    @NotNull
    public static EnumSet<ArtifactKind> kindsOf(boolean sources, boolean javadoc) {
        EnumSet<ArtifactKind> result = EnumSet.noneOf(ArtifactKind.class);
        if (sources) {
            result.add(SOURCES);
        }
        if (javadoc) {
            result.add(JAVADOC);
        }
        return result;
    }
}

