/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import com.google.common.base.Predicate;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnection;
import org.apache.http.client.HttpClient;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.building.Problem;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.interpolation.Interpolator;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.artifact.DelegatingArtifact;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactDependencyNode;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.JreProxySelector;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ArtifactRepositoryManager {
    private static final VersionScheme ourVersioning = new GenericVersionScheme();
    private static final JreProxySelector ourProxySelector = new JreProxySelector();
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactRepositoryManager.class);
    private final DefaultRepositorySystemSession mySession;
    private static final RemoteRepository MAVEN_CENTRAL_REPOSITORY = ArtifactRepositoryManager.createRemoteRepository("central", "http://repo1.maven.org/maven2/");
    private static final RemoteRepository JBOSS_COMMUNITY_REPOSITORY = ArtifactRepositoryManager.createRemoteRepository("jboss.community", "https://repository.jboss.org/nexus/content/repositories/public/");
    private static final RepositorySystem ourSystem;
    private final List<RemoteRepository> myRemoteRepositories = new ArrayList<RemoteRepository>();

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath) {
        this(localRepositoryPath, ProgressConsumer.DEAF);
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, @NotNull ProgressConsumer progressConsumer) {
        this(localRepositoryPath, Arrays.asList(ArtifactRepositoryManager.createRemoteRepository(MAVEN_CENTRAL_REPOSITORY), ArtifactRepositoryManager.createRemoteRepository(JBOSS_COMMUNITY_REPOSITORY)), progressConsumer);
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, List<RemoteRepository> remoteRepositories, final @NotNull ProgressConsumer progressConsumer) {
        this.myRemoteRepositories.addAll(remoteRepositories);
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        if (progressConsumer != ProgressConsumer.DEAF) {
            session.setTransferListener((TransferListener)Proxy.newProxyInstance(session.getClass().getClassLoader(), new Class[]{TransferListener.class}, new InvocationHandler(){
                private final EnumSet<TransferEvent.EventType> checkCancelEvents = EnumSet.of(TransferEvent.EventType.INITIATED, TransferEvent.EventType.STARTED, TransferEvent.EventType.PROGRESSED);

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object event = args[0];
                    if (event instanceof TransferEvent) {
                        TransferEvent.EventType type = ((TransferEvent)event).getType();
                        if (this.checkCancelEvents.contains(type) && progressConsumer.isCanceled()) {
                            throw new TransferCancelledException();
                        }
                        progressConsumer.consume(event.toString());
                    }
                    return null;
                }
            }));
        }
        session.setLocalRepositoryManager(ourSystem.newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(localRepositoryPath)));
        session.setProxySelector((ProxySelector)ourProxySelector);
        session.setReadOnly();
        this.mySession = session;
    }

    public static List<Class> getClassesFromDependencies() {
        return Arrays.asList(ArtifactRepositoryManager.class, VersionsMetadataGeneratorFactory.class, Artifact.class, StringUtils.class, org.codehaus.plexus.util.Base64.class, Problem.class, Model.class, ModelBuilder.class, Metadata.class, Component.class, Interpolator.class, RepositorySystem.class, BasicRepositoryConnectorFactory.class, RepositoryConnector.class, org.eclipse.aether.util.StringUtils.class, ArtifactResolver.class, FileTransporterFactory.class, HttpTransporterFactory.class, Predicate.class, HttpConnection.class, HttpClient.class, Base64.class, LogFactory.class, Marker.class);
    }

    public Collection<File> resolveDependency(String groupId, String artifactId, String version, boolean includeTransitiveDependencies, List<String> excludedDependencies) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (org.eclipse.aether.artifact.Artifact artifact : this.resolveDependencyAsArtifact(groupId, artifactId, version, EnumSet.of(ArtifactKind.ARTIFACT), includeTransitiveDependencies, excludedDependencies)) {
            files.add(artifact.getFile());
        }
        return files;
    }

    @Nullable
    public ArtifactDependencyNode collectDependencies(String groupId, String artifactId, String versionConstraint) throws Exception {
        Set<VersionConstraint> constraints = Collections.singleton(ArtifactRepositoryManager.asVersionConstraint(versionConstraint));
        CollectRequest collectRequest = this.createCollectRequest(groupId, artifactId, constraints, EnumSet.of(ArtifactKind.ARTIFACT));
        ArtifactDependencyTreeBuilder builder = new ArtifactDependencyTreeBuilder();
        DependencyNode root = ourSystem.collectDependencies((RepositorySystemSession)this.mySession, collectRequest).getRoot();
        if (root.getArtifact() == null && root.getChildren().size() == 1) {
            root = (DependencyNode)root.getChildren().get(0);
        }
        root.accept((DependencyVisitor)new TreeDependencyVisitor((DependencyVisitor)new FilteringDependencyVisitor((DependencyVisitor)builder, ArtifactRepositoryManager.createScopeFilter())));
        return builder.getRoot();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<org.eclipse.aether.artifact.Artifact> resolveDependencyAsArtifact(String groupId, String artifactId, String versionConstraint, Set<ArtifactKind> artifactKinds, boolean includeTransitiveDependencies, List<String> excludedDependencies) throws Exception {
        ArrayList<org.eclipse.aether.artifact.Artifact> artifacts = new ArrayList<org.eclipse.aether.artifact.Artifact>();
        VersionConstraint originalConstraints = ArtifactRepositoryManager.asVersionConstraint(versionConstraint);
        for (ArtifactKind kind : artifactKinds) {
            try {
                VersionRangeResult result;
                List<Object> requests;
                Set<VersionConstraint> constraints = kind == ArtifactKind.ANNOTATIONS ? ArtifactRepositoryManager.relaxForAnnotations(originalConstraints) : Collections.singleton(originalConstraints);
                if (includeTransitiveDependencies) {
                    void var15_20;
                    CollectResult collectResult = ourSystem.collectDependencies((RepositorySystemSession)this.mySession, this.createCollectRequest(groupId, artifactId, constraints, EnumSet.of(kind)));
                    ArtifactRequestBuilder builder = new ArtifactRequestBuilder(kind);
                    DependencyFilter dependencyFilter = ArtifactRepositoryManager.createScopeFilter();
                    if (!excludedDependencies.isEmpty()) {
                        DependencyFilter dependencyFilter2 = DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{dependencyFilter, new ExcludeDependenciesFilter(excludedDependencies)});
                    }
                    collectResult.getRoot().accept((DependencyVisitor)new TreeDependencyVisitor((DependencyVisitor)new FilteringDependencyVisitor((DependencyVisitor)builder, (DependencyFilter)var15_20)));
                    requests = builder.getRequests();
                } else {
                    requests = new ArrayList<ArtifactRequest>();
                    for (org.eclipse.aether.artifact.Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, constraints, Collections.singleton(kind))) {
                        if (ourVersioning.parseVersionConstraint(artifact.getVersion()).getRange() != null) {
                            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, Collections.unmodifiableList(this.myRemoteRepositories), null);
                            result = ourSystem.resolveVersionRange((RepositorySystemSession)this.mySession, versionRangeRequest);
                            if (result.getVersions().isEmpty()) continue;
                            org.eclipse.aether.artifact.Artifact newArtifact = artifact.setVersion(result.getHighestVersion().toString());
                            requests.add(new ArtifactRequest(newArtifact, Collections.unmodifiableList(this.myRemoteRepositories), null));
                            continue;
                        }
                        requests.add(new ArtifactRequest(artifact, Collections.unmodifiableList(this.myRemoteRepositories), null));
                    }
                }
                if (requests.isEmpty()) continue;
                try {
                    for (ArtifactResult result2 : ourSystem.resolveArtifacts((RepositorySystemSession)this.mySession, requests)) {
                        artifacts.add(result2.getArtifact());
                    }
                }
                catch (ArtifactResolutionException e) {
                    if (kind != ArtifactKind.ARTIFACT) {
                        if (requests.size() <= 1) continue;
                        for (ArtifactRequest artifactRequest : requests) {
                            try {
                                result = ourSystem.resolveArtifact((RepositorySystemSession)this.mySession, artifactRequest);
                                artifacts.add(result.getArtifact());
                            }
                            catch (ArtifactResolutionException artifactResolutionException) {}
                        }
                        continue;
                    }
                    throw e;
                }
            }
            catch (DependencyCollectionException e) {
                if (kind != ArtifactKind.ARTIFACT) continue;
                throw e;
            }
        }
        return artifacts;
    }

    private static Set<VersionConstraint> relaxForAnnotations(VersionConstraint constraint) {
        VersionRange range;
        String annotationsConstraint = constraint.toString();
        Version version = constraint.getVersion();
        if (version != null) {
            String major = version.toString().split("[.\\-_]")[0];
            annotationsConstraint = "[" + major + ", " + version.toString() + "-an10000]";
        }
        if ((range = constraint.getRange()) != null) {
            String majorLower = range.getLowerBound().getVersion().toString().split("[.\\-_]")[0];
            String upper = range.getUpperBound().isInclusive() ? range.getUpperBound().toString() + "-an10000]" : range.getUpperBound().toString() + ")";
            annotationsConstraint = "[" + majorLower + ", " + upper;
        }
        try {
            return Collections.singleton(ourVersioning.parseVersionConstraint(annotationsConstraint));
        }
        catch (InvalidVersionSpecificationException e) {
            LOG.info("Failed to parse version constraint " + annotationsConstraint, (Throwable)e);
            return Collections.singleton(constraint);
        }
    }

    @NotNull
    private static DependencyFilter createScopeFilter() {
        return DependencyFilterUtils.classpathFilter((String[])new String[]{"compile", "runtime"});
    }

    @NotNull
    public List<Version> getAvailableVersions(String groupId, String artifactId, String versionConstraint, ArtifactKind artifactKind) throws Exception {
        VersionRangeResult result = ourSystem.resolveVersionRange((RepositorySystemSession)this.mySession, this.createVersionRangeRequest(groupId, artifactId, ArtifactRepositoryManager.asVersionConstraint(versionConstraint), artifactKind));
        return result.getVersions();
    }

    public static RemoteRepository createRemoteRepository(String id, String url) {
        return new RemoteRepository.Builder(id, "default", url).setProxy(ourProxySelector.getProxy(url)).build();
    }

    public static RemoteRepository createRemoteRepository(RemoteRepository prototype) {
        String url = prototype.getUrl();
        return new RemoteRepository.Builder(prototype.getId(), prototype.getContentType(), url).setProxy(ourProxySelector.getProxy(url)).build();
    }

    private CollectRequest createCollectRequest(String groupId, String artifactId, Collection<VersionConstraint> versions, Set<ArtifactKind> kinds) {
        CollectRequest request = new CollectRequest();
        for (org.eclipse.aether.artifact.Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, versions, kinds)) {
            request.addDependency(new Dependency(artifact, "compile"));
        }
        return request.setRepositories(Collections.unmodifiableList(this.myRemoteRepositories));
    }

    private VersionRangeRequest createVersionRangeRequest(String groupId, String artifactId, VersionConstraint versioning, ArtifactKind artifactKind) {
        VersionRangeRequest request = new VersionRangeRequest();
        for (org.eclipse.aether.artifact.Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, Collections.singleton(versioning), EnumSet.of(artifactKind))) {
            request.setArtifact(artifact);
        }
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>(this.myRemoteRepositories.size());
        for (RemoteRepository repository : this.myRemoteRepositories) {
            RepositoryPolicy policy = new RepositoryPolicy(true, "always", "warn");
            repositories.add(new RemoteRepository.Builder(repository).setPolicy(policy).build());
        }
        return request.setRepositories(repositories);
    }

    public static Version asVersion(@Nullable String str) throws InvalidVersionSpecificationException {
        return ourVersioning.parseVersion(str == null ? "" : str);
    }

    public static VersionConstraint asVersionConstraint(@Nullable String str) throws InvalidVersionSpecificationException {
        return ourVersioning.parseVersionConstraint(str == null ? "" : str);
    }

    private static List<org.eclipse.aether.artifact.Artifact> toArtifacts(String groupId, String artifactId, Collection<VersionConstraint> constraints, Set<ArtifactKind> kinds) {
        if (constraints.isEmpty() || kinds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<org.eclipse.aether.artifact.Artifact> result = new ArrayList<org.eclipse.aether.artifact.Artifact>(kinds.size() * constraints.size());
        for (ArtifactKind kind : kinds) {
            for (VersionConstraint constraint : constraints) {
                result.add((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(groupId, artifactId, kind.getClassifier(), kind.getExtension(), constraint.toString()));
            }
        }
        return result;
    }

    static {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                if (exception != null) {
                    throw new RuntimeException(exception);
                }
            }
        });
        ourSystem = (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static class ArtifactDependencyTreeBuilder
    implements DependencyVisitor {
        private final List<List<ArtifactDependencyNode>> myCurrentChildren = new ArrayList<List<ArtifactDependencyNode>>();

        ArtifactDependencyTreeBuilder() {
            this.myCurrentChildren.add(new ArrayList());
        }

        public boolean visitEnter(DependencyNode node) {
            org.eclipse.aether.artifact.Artifact artifact = node.getArtifact();
            if (artifact == null) {
                return false;
            }
            this.myCurrentChildren.add(new ArrayList());
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            org.eclipse.aether.artifact.Artifact artifact = node.getArtifact();
            if (artifact != null) {
                List<ArtifactDependencyNode> last = this.myCurrentChildren.get(this.myCurrentChildren.size() - 1);
                this.myCurrentChildren.remove(this.myCurrentChildren.size() - 1);
                this.myCurrentChildren.get(this.myCurrentChildren.size() - 1).add(new ArtifactDependencyNode(artifact, last));
            }
            return true;
        }

        public ArtifactDependencyNode getRoot() {
            List<ArtifactDependencyNode> rootNodes = this.myCurrentChildren.get(0);
            return rootNodes.isEmpty() ? null : rootNodes.get(0);
        }
    }

    private static class ExcludeDependenciesFilter
    implements DependencyFilter {
        private final HashSet<String> myExcludedDependencies;

        ExcludeDependenciesFilter(List<String> excludedDependencies) {
            this.myExcludedDependencies = new HashSet<String>(excludedDependencies);
        }

        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            org.eclipse.aether.artifact.Artifact artifact = node.getArtifact();
            if (artifact != null && this.myExcludedDependencies.contains(artifact.getGroupId() + ":" + artifact.getArtifactId())) {
                return false;
            }
            for (DependencyNode parent : parents) {
                org.eclipse.aether.artifact.Artifact parentArtifact = parent.getArtifact();
                if (parentArtifact == null || !this.myExcludedDependencies.contains(parentArtifact.getGroupId() + ":" + parentArtifact.getArtifactId())) continue;
                return false;
            }
            return true;
        }
    }

    private static class ArtifactRequestBuilder
    implements DependencyVisitor {
        private final ArtifactKind myKind;
        private final List<ArtifactRequest> myRequests = new ArrayList<ArtifactRequest>();

        ArtifactRequestBuilder(ArtifactKind kind) {
            this.myKind = kind;
        }

        public boolean visitEnter(DependencyNode node) {
            Dependency dep = node.getDependency();
            if (dep != null) {
                this.myRequests.add(new ArtifactRequest((org.eclipse.aether.artifact.Artifact)new ArtifactWithChangedClassifier(node.getDependency().getArtifact(), this.myKind.getClassifier()), node.getRepositories(), node.getRequestContext()));
            }
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            return true;
        }

        @NotNull
        public List<ArtifactRequest> getRequests() {
            return this.myRequests;
        }
    }

    private static class ArtifactWithChangedClassifier
    extends DelegatingArtifact {
        private final String myClassifier;

        ArtifactWithChangedClassifier(org.eclipse.aether.artifact.Artifact artifact, String classifier) {
            super(artifact);
            this.myClassifier = classifier;
        }

        protected DelegatingArtifact newInstance(org.eclipse.aether.artifact.Artifact artifact) {
            return new ArtifactWithChangedClassifier(artifact, this.myClassifier);
        }

        public String getClassifier() {
            return this.myClassifier;
        }
    }
}

