/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemRunConfigurationMenu
extends DefaultActionGroup
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        for (AnAction action : this.getChildActionsOrStubs()) {
            if (!(action instanceof ExecuteExternalSystemRunConfigurationAction)) continue;
            this.remove(action);
        }
        Project project = e.getProject();
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1 || !(selectedNodes.get(0) instanceof RunConfigurationNode)) {
            return;
        }
        RunConfigurationNode runConfigurationNode = (RunConfigurationNode)selectedNodes.get(0);
        RunnerAndConfigurationSettings settings = runConfigurationNode.getSettings();
        if (settings == null || project == null) {
            return;
        }
        ProjectSystemId projectSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
        Executor[] executors = ExecutorRegistry.getInstance().getRegisteredExecutors();
        int i = executors.length;
        while (--i >= 0) {
            Executor executor = executors[i];
            if (!executor.isApplicable(project)) continue;
            ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)settings.getConfiguration());
            ExecuteExternalSystemRunConfigurationAction action = new ExecuteExternalSystemRunConfigurationAction(executor, runner != null, project, projectSystemId, settings);
            this.addAction(action, Constraints.FIRST);
        }
        super.update(e);
    }

    private static class ExecuteExternalSystemRunConfigurationAction
    extends AnAction {
        private final Executor myExecutor;
        private final boolean myEnabled;
        private final Project myProject;
        private final RunnerAndConfigurationSettings mySettings;
        private final ProjectSystemId mySystemId;

        ExecuteExternalSystemRunConfigurationAction(Executor executor, boolean enabled, Project project, ProjectSystemId projectSystemId, RunnerAndConfigurationSettings settings) {
            super(executor.getActionName(), null, executor.getIcon());
            this.myExecutor = executor;
            this.myEnabled = enabled;
            this.myProject = project;
            this.mySettings = settings;
            this.mySystemId = projectSystemId;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (this.myEnabled) {
                ExternalSystemActionsCollector.trigger(this.myProject, this.mySystemId, this, event, new String[0]);
                ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)this.mySettings, (Executor)this.myExecutor);
                RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(this.mySettings);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.myEnabled);
        }
    }
}

