/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemToggleAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleAutoImportAction
extends ExternalSystemToggleAction {
    public ToggleAutoImportAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.project.auto.text", (Object[])new Object[0]));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.project.auto.description", (Object[])new Object[0]));
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        if (this.getSystemId(e) == null) {
            return false;
        }
        return ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(e.getDataContext()) != null;
    }

    @Override
    protected boolean isVisible(@NotNull AnActionEvent e) {
        if (!super.isVisible(e)) {
            return false;
        }
        if (this.getSystemId(e) == null) {
            return false;
        }
        return ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(e.getDataContext()) != null;
    }

    @Override
    protected boolean doIsSelected(@NotNull AnActionEvent e) {
        ExternalProjectSettings projectSettings = this.getProjectSettings(e);
        return projectSettings != null && projectSettings.isUseAutoImport();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        ExternalProjectSettings projectSettings = this.getProjectSettings(e);
        if (projectSettings != null && state != projectSettings.isUseAutoImport()) {
            Project project = this.getProject(e);
            ProjectSystemId systemId = this.getSystemId(e);
            ExternalSystemActionsCollector.trigger(project, systemId, (AnAction)this, e, new String[0]);
            projectSettings.setUseAutoImport(state);
            ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)systemId).getPublisher().onUseAutoImportChange(state, projectSettings.getExternalProjectPath());
        }
    }

    @Nullable
    private ExternalProjectSettings getProjectSettings(@NotNull AnActionEvent e) {
        ProjectNode projectNode = (ProjectNode)ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(e.getDataContext());
        if (projectNode == null || projectNode.getData() == null) {
            return null;
        }
        AbstractExternalSystemSettings externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.getProject(e), (ProjectSystemId)this.getSystemId(e));
        return externalSystemSettings.getLinkedProjectSettings(((ProjectData)projectNode.getData()).getLinkedExternalProjectPath());
    }
}

