/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;

@ApiStatus.Experimental
public class ConfigurationDataImpl
extends AbstractExternalEntityData
implements ConfigurationData {
    private static final long serialVersionUID = 1L;
    @Language(value="JSON")
    @NotNull
    private final String myData;
    @Nullable
    private volatile transient Object myJsonObject;

    public ConfigurationDataImpl(@NotNull ProjectSystemId owner, @Language(value="JSON") @NotNull String data) {
        super(owner);
        this.myData = data;
    }

    @Language(value="JSON")
    @NotNull
    public String getJsonString() {
        return this.myData;
    }

    public Object find(@NotNull String query) {
        if (StringUtil.isEmpty((String)query)) {
            return null;
        }
        Object jsonObject = this.getJsonObject();
        for (String part : StringUtil.split((String)query, (String)".")) {
            if (jsonObject instanceof Map) {
                jsonObject = ((Map)jsonObject).get(part);
                continue;
            }
            return null;
        }
        return jsonObject;
    }

    public Object getJsonObject() {
        if (this.myJsonObject == null) {
            JsonReaderEx reader = new JsonReaderEx((CharSequence)this.myData);
            reader.setLenient(true);
            this.myJsonObject = JsonUtil.nextAny((JsonReaderEx)reader);
        }
        return this.myJsonObject;
    }
}

