/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.ExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.InProcessExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemFacadeWrapper;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.IntegrationKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemFacadeManager {
    private static final int REMOTE_FAIL_RECOVERY_ATTEMPTS_NUMBER = 3;
    private final ConcurrentMap<IntegrationKey, RemoteExternalSystemFacade> myFacadeWrappers = ContainerUtil.newConcurrentMap();
    private final Map<IntegrationKey, Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>> myRemoteFacades = ContainerUtil.newConcurrentMap();
    @NotNull
    private final Lock myLock = new ReentrantLock();
    @NotNull
    private final RemoteExternalSystemProgressNotificationManager myProgressManager;
    @NotNull
    private final RemoteExternalSystemCommunicationManager myRemoteCommunicationManager;
    @NotNull
    private final InProcessExternalSystemCommunicationManager myInProcessCommunicationManager;

    public ExternalSystemFacadeManager(@NotNull ExternalSystemProgressNotificationManager notificationManager, @NotNull RemoteExternalSystemCommunicationManager remoteCommunicationManager, @NotNull InProcessExternalSystemCommunicationManager inProcessCommunicationManager) {
        this.myProgressManager = (RemoteExternalSystemProgressNotificationManager)((Object)notificationManager);
        this.myRemoteCommunicationManager = remoteCommunicationManager;
        this.myInProcessCommunicationManager = inProcessCommunicationManager;
    }

    @NotNull
    private static Project findProject(@NotNull IntegrationKey key) {
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project : projectManager.getOpenProjects()) {
            if (!key.getIdeProjectName().equals(project.getName()) || !key.getIdeProjectLocationHash().equals(project.getLocationHash())) continue;
            return project;
        }
        return projectManager.getDefaultProject();
    }

    public void onProjectRename(@NotNull String oldName, @NotNull String newName) {
        ExternalSystemFacadeManager.onProjectRename(this.myFacadeWrappers, oldName, newName);
        ExternalSystemFacadeManager.onProjectRename(this.myRemoteFacades, oldName, newName);
    }

    private static <V> void onProjectRename(@NotNull Map<IntegrationKey, V> data, @NotNull String oldName, @NotNull String newName) {
        HashSet keys = ContainerUtilRt.newHashSet(data.keySet());
        for (IntegrationKey key : keys) {
            if (!key.getIdeProjectName().equals(oldName)) continue;
            IntegrationKey newKey = new IntegrationKey(newName, key.getIdeProjectLocationHash(), key.getExternalSystemId(), key.getExternalProjectConfigPath());
            V value = data.get(key);
            data.put(newKey, value);
            data.remove(key);
            if (!(value instanceof Consumer)) continue;
            ((Consumer)value).consume((Object)newKey);
        }
    }

    @NotNull
    public RemoteExternalSystemFacade getFacade(@Nullable Project project, @NotNull String externalProjectPath, @NotNull ProjectSystemId externalSystemId) {
        IntegrationKey key;
        RemoteExternalSystemFacade facade;
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        if ((facade = (RemoteExternalSystemFacade)this.myFacadeWrappers.get(key = new IntegrationKey(project, externalSystemId, externalProjectPath))) == null) {
            RemoteExternalSystemFacade newFacade = (RemoteExternalSystemFacade)Proxy.newProxyInstance(ExternalSystemFacadeManager.class.getClassLoader(), new Class[]{RemoteExternalSystemFacade.class, Consumer.class}, (InvocationHandler)new MyHandler(key));
            this.myFacadeWrappers.putIfAbsent(key, newFacade);
        }
        return (RemoteExternalSystemFacade)this.myFacadeWrappers.get(key);
    }

    public Object doInvoke(@NotNull IntegrationKey key, @NotNull Project project, Method method, Object[] args, int invocationNumber) throws Throwable {
        RemoteExternalSystemFacade facade = this.doGetFacade(key, project);
        try {
            return method.invoke((Object)facade, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RemoteException && invocationNumber > 0) {
                Thread.sleep(1000L);
                return this.doInvoke(key, project, method, args, invocationNumber - 1);
            }
            throw e;
        }
    }

    public ExternalSystemCommunicationManager getCommunicationManager(@NotNull ProjectSystemId externalSystemId) {
        boolean currentInProcess = ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)externalSystemId);
        return currentInProcess ? this.myInProcessCommunicationManager : this.myRemoteCommunicationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private RemoteExternalSystemFacade doGetFacade(@NotNull IntegrationKey key, @NotNull Project project) throws Exception {
        boolean currentInProcess = ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)key.getExternalSystemId());
        ExternalSystemCommunicationManager myCommunicationManager = currentInProcess ? this.myInProcessCommunicationManager : this.myRemoteCommunicationManager;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)key.getExternalSystemId());
        if (project.isDisposed() || manager == null) {
            return RemoteExternalSystemFacade.NULL_OBJECT;
        }
        Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings> pair = this.myRemoteFacades.get(key);
        if (pair != null && this.prepare(myCommunicationManager, project, key, pair)) {
            return (RemoteExternalSystemFacade)pair.first;
        }
        this.myLock.lock();
        try {
            pair = this.myRemoteFacades.get(key);
            if (pair != null && this.prepare(myCommunicationManager, project, key, pair)) {
                RemoteExternalSystemFacade remoteExternalSystemFacade = (RemoteExternalSystemFacade)pair.first;
                return remoteExternalSystemFacade;
            }
            if (pair != null) {
                this.myFacadeWrappers.clear();
                this.myRemoteFacades.clear();
            }
            RemoteExternalSystemFacade remoteExternalSystemFacade = this.doCreateFacade(key, project, myCommunicationManager);
            return remoteExternalSystemFacade;
        }
        finally {
            this.myLock.unlock();
        }
    }

    @NotNull
    private RemoteExternalSystemFacade doCreateFacade(@NotNull IntegrationKey key, @NotNull Project project, @NotNull ExternalSystemCommunicationManager communicationManager) throws Exception {
        RemoteExternalSystemFacade facade = communicationManager.acquire(key.getExternalProjectConfigPath(), key.getExternalSystemId());
        if (facade == null) {
            throw new IllegalStateException("Can't obtain facade to working with external api at the remote process. Project: " + project);
        }
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                ExternalSystemFacadeManager.this.myFacadeWrappers.clear();
                ExternalSystemFacadeManager.this.myRemoteFacades.clear();
            }
        });
        ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings> result = new ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings>(facade, this.myProgressManager);
        ExternalSystemExecutionSettings settings = ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)key.getExternalProjectConfigPath(), (ProjectSystemId)key.getExternalSystemId());
        Pair newPair = Pair.create(result, (Object)settings);
        this.myRemoteFacades.put(key, (Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>)newPair);
        result.applySettings((ExternalSystemExecutionSettings)newPair.second);
        return result;
    }

    private boolean prepare(@NotNull ExternalSystemCommunicationManager communicationManager, @NotNull Project project, @NotNull IntegrationKey key, @NotNull Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings> pair) {
        if (!communicationManager.isAlive((RemoteExternalSystemFacade)pair.first)) {
            return false;
        }
        try {
            ExternalSystemExecutionSettings currentSettings = ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)key.getExternalProjectConfigPath(), (ProjectSystemId)key.getExternalSystemId());
            if (!currentSettings.equals(pair.second)) {
                ((RemoteExternalSystemFacade)pair.first).applySettings(currentSettings);
                this.myRemoteFacades.put(key, (Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>)Pair.create((Object)pair.first, (Object)currentSettings));
            }
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskActive(@NotNull ExternalSystemTaskId id) {
        HashMap copy = ContainerUtilRt.newHashMap(this.myRemoteFacades);
        for (Map.Entry entry : copy.entrySet()) {
            try {
                if (!((RemoteExternalSystemFacade)((Pair)entry.getValue()).first).isTaskInProgress(id)) continue;
                return true;
            }
            catch (RemoteException e) {
                this.myLock.lock();
                try {
                    this.myRemoteFacades.remove(entry.getKey());
                    this.myFacadeWrappers.remove(entry.getKey());
                }
                finally {
                    this.myLock.unlock();
                }
            }
        }
        return false;
    }

    private class MyHandler
    implements InvocationHandler {
        @NotNull
        private final AtomicReference<IntegrationKey> myKey = new AtomicReference();

        MyHandler(IntegrationKey key) {
            this.myKey.set(key);
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("consume".equals(method.getName())) {
                this.myKey.set((IntegrationKey)args[0]);
                return null;
            }
            Project project = ExternalSystemFacadeManager.findProject(this.myKey.get());
            return ExternalSystemFacadeManager.this.doInvoke(this.myKey.get(), project, method, args, 3);
        }
    }
}

