/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.ExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.InProcessExternalSystemFacadeImpl;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemFacadeWrapper;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InProcessExternalSystemCommunicationManager
implements ExternalSystemCommunicationManager {
    @NotNull
    private final ExternalSystemProgressNotificationManagerImpl myProgressManager;

    public InProcessExternalSystemCommunicationManager(@NotNull ExternalSystemProgressNotificationManager notificationManager) {
        this.myProgressManager = (ExternalSystemProgressNotificationManagerImpl)notificationManager;
    }

    @Override
    @Nullable
    public RemoteExternalSystemFacade acquire(@NotNull String id, @NotNull ProjectSystemId externalSystemId) throws Exception {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        InProcessExternalSystemFacadeImpl result = new InProcessExternalSystemFacadeImpl(manager.getProjectResolverClass(), manager.getTaskManagerClass());
        result.applyProgressManager(this.myProgressManager);
        return result;
    }

    @Override
    public void release(@NotNull String id, @NotNull ProjectSystemId externalSystemId) {
    }

    @Override
    public boolean isAlive(@NotNull RemoteExternalSystemFacade facade) {
        RemoteExternalSystemFacade toCheck = facade;
        if (facade instanceof ExternalSystemFacadeWrapper) {
            toCheck = ((ExternalSystemFacadeWrapper)facade).getDelegate();
        }
        return toCheck instanceof InProcessExternalSystemFacadeImpl;
    }

    @Override
    public void clear() {
    }
}

