/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.intellij.CommonBundle;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.core.JavaCoreBundle;
import com.intellij.debugger.ui.DebuggerView;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.rmi.RemoteProcessSupport;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.ExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.InProcessExternalSystemFacadeImpl;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacadeImpl;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemFacadeWrapper;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiBundle;
import com.intellij.ui.PlaceHolder;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Unit;
import kotlin.reflect.full.NoSuchPropertyException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nustaq.serialization.FSTConfiguration;
import org.objenesis.Objenesis;

public class RemoteExternalSystemCommunicationManager
implements ExternalSystemCommunicationManager,
Disposable {
    private static final Logger LOG = Logger.getInstance(RemoteExternalSystemCommunicationManager.class);
    private static final String MAIN_CLASS_NAME = RemoteExternalSystemFacadeImpl.class.getName();
    private final AtomicReference<RemoteExternalSystemProgressNotificationManager> myExportedNotificationManager = new AtomicReference();
    @NotNull
    private final ThreadLocal<ProjectSystemId> myTargetExternalSystemId = new ThreadLocal();
    @NotNull
    private final ExternalSystemProgressNotificationManagerImpl myProgressManager;
    @NotNull
    private final RemoteProcessSupport<Object, RemoteExternalSystemFacade, String> mySupport;

    public RemoteExternalSystemCommunicationManager(@NotNull ExternalSystemProgressNotificationManager notificationManager) {
        this.myProgressManager = (ExternalSystemProgressNotificationManagerImpl)notificationManager;
        this.mySupport = new RemoteProcessSupport<Object, RemoteExternalSystemFacade, String>(RemoteExternalSystemFacade.class){

            protected void fireModificationCountChanged() {
            }

            protected String getName(@NotNull Object o) {
                return RemoteExternalSystemFacade.class.getName();
            }

            protected RunProfileState getRunProfileState(@NotNull Object o, @NotNull String configuration, @NotNull Executor executor) {
                return RemoteExternalSystemCommunicationManager.this.createRunProfileState(configuration);
            }
        };
        ShutDownTracker.getInstance().registerShutdownTask(() -> this.shutdown(false));
    }

    public synchronized void shutdown(boolean wait) {
        this.mySupport.stopAll(wait);
    }

    private RunProfileState createRunProfileState(final String configuration) {
        return new CommandLineState(null){

            private SimpleJavaParameters createJavaParameters() throws ExecutionException {
                ExternalSystemManager manager;
                ProjectSystemId externalSystemId;
                SimpleJavaParameters params = new SimpleJavaParameters();
                params.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
                File myWorkingDirectory = new File(configuration);
                params.setWorkingDirectory(myWorkingDirectory.isDirectory() ? myWorkingDirectory.getPath() : PathManager.getBinPath());
                ArrayList classPath = ContainerUtilRt.newArrayList();
                classPath.addAll(PathManager.getUtilClassPath());
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(ProjectBundle.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(PlaceHolder.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(DebuggerView.class));
                ExternalSystemApiUtil.addBundle((PathsList)params.getClassPath(), (String)"messages.ProjectBundle", ProjectBundle.class);
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(PsiBundle.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(Alarm.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(DependencyScope.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(ExtensionPointName.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(StorageUtilKt.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(ExternalSystemTaskNotificationListener.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(StdModuleTypes.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(JavaModuleType.class));
                ExternalSystemApiUtil.addBundle((PathsList)params.getClassPath(), (String)"messages.JavaCoreBundle", JavaCoreBundle.class);
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(ModuleType.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(EmptyModuleType.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(LanguageLevel.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(Unit.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(NoSuchPropertyException.class));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()));
                ContainerUtil.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(ExternalSystemException.class));
                ExternalSystemApiUtil.addBundle((PathsList)params.getClassPath(), (String)"messages.CommonBundle", CommonBundle.class);
                ContainerUtilRt.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(FSTConfiguration.class));
                ContainerUtilRt.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(JsonFactory.class));
                ContainerUtilRt.addIfNotNull((Collection)classPath, (Object)PathUtil.getJarPathForClass(Objenesis.class));
                params.getClassPath().addAll((List)classPath);
                params.setMainClass(MAIN_CLASS_NAME);
                params.getVMParametersList().addParametersString("-Djava.awt.headless=true");
                params.getVMParametersList().addParametersString("-Dsun.rmi.transport.connectionTimeout=" + TimeUnit.HOURS.toMillis(1L));
                String debugPort = System.getProperty("external.system.remote.communication.manager.debug.port");
                if (debugPort != null) {
                    params.getVMParametersList().addParametersString("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + debugPort);
                }
                if ((externalSystemId = (ProjectSystemId)RemoteExternalSystemCommunicationManager.this.myTargetExternalSystemId.get()) != null && (manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId)) != null) {
                    params.getClassPath().add(PathUtil.getJarPathForClass((Class)manager.getProjectResolverClass()));
                    params.getProgramParametersList().add(manager.getProjectResolverClass().getName());
                    params.getProgramParametersList().add(manager.getTaskManagerClass().getName());
                    manager.enhanceRemoteProcessing(params);
                }
                return params;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                OSProcessHandler processHandler = this.startProcess();
                return new DefaultExecutionResult((ProcessHandler)processHandler);
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                SimpleJavaParameters params = this.createJavaParameters();
                GeneralCommandLine commandLine = params.toCommandLine();
                OSProcessHandler processHandler = new OSProcessHandler(commandLine);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler);
                return processHandler;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RemoteExternalSystemFacade acquire(@NotNull String id, @NotNull ProjectSystemId externalSystemId) throws Exception {
        RemoteExternalSystemFacade facade;
        this.myTargetExternalSystemId.set(externalSystemId);
        try {
            facade = (RemoteExternalSystemFacade)this.mySupport.acquire((Object)this, (Object)id);
        }
        finally {
            this.myTargetExternalSystemId.set(null);
        }
        if (facade == null) {
            return null;
        }
        RemoteExternalSystemProgressNotificationManager exported = this.myExportedNotificationManager.get();
        if (exported == null) {
            try {
                exported = (RemoteExternalSystemProgressNotificationManager)UnicastRemoteObject.exportObject((Remote)this.myProgressManager, 0);
                this.myExportedNotificationManager.set(exported);
            }
            catch (RemoteException e) {
                exported = this.myExportedNotificationManager.get();
            }
        }
        if (exported == null) {
            LOG.warn("Can't export progress manager");
        } else {
            facade.applyProgressManager(exported);
        }
        return facade;
    }

    @Override
    public void release(@NotNull String id, @NotNull ProjectSystemId externalSystemId) {
        this.mySupport.release((Object)this, (Object)id);
    }

    @Override
    public boolean isAlive(@NotNull RemoteExternalSystemFacade facade) {
        RemoteExternalSystemFacade toCheck = facade;
        if (facade instanceof ExternalSystemFacadeWrapper) {
            toCheck = ((ExternalSystemFacadeWrapper)facade).getDelegate();
        }
        if (toCheck instanceof InProcessExternalSystemFacadeImpl) {
            return false;
        }
        try {
            facade.getResolver();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public void clear() {
        this.mySupport.stopAll(true);
    }

    public void dispose() {
        this.shutdown(false);
    }
}

