/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemTaskConfigurationType
implements ConfigurationType {
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final ConfigurationFactory[] myFactories = new ConfigurationFactory[1];
    @NotNull
    private final NotNullLazyValue<Icon> myIcon = new NotNullLazyValue<Icon>(){

        @NotNull
        protected Icon compute() {
            ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId);
            Icon result = null;
            if (manager instanceof ExternalSystemUiAware) {
                result = ((ExternalSystemUiAware)manager).getProjectIcon();
            }
            return result == null ? DefaultExternalSystemUiAware.INSTANCE.getTaskIcon() : result;
        }
    };

    protected AbstractExternalSystemTaskConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        this.myExternalSystemId = externalSystemId;
        this.myFactories[0] = new ConfigurationFactory(this){

            @NotNull
            public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
                return AbstractExternalSystemTaskConfigurationType.this.doCreateConfiguration(AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId, project, this, "");
            }
        };
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return this.myExternalSystemId;
    }

    @NotNull
    public ConfigurationFactory getFactory() {
        return this.myFactories[0];
    }

    @NotNull
    protected ExternalSystemRunConfiguration doCreateConfiguration(@NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        return new ExternalSystemRunConfiguration(externalSystemId, project, factory, name);
    }

    @NotNull
    public String getDisplayName() {
        return this.myExternalSystemId.getReadableName();
    }

    public String getConfigurationTypeDescription() {
        return ExternalSystemBundle.message((String)"run.configuration.description", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
    }

    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    @NotNull
    public String getId() {
        return this.myExternalSystemId.getReadableName() + "RunConfiguration";
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return this.myFactories;
    }

    @NotNull
    public static String generateName(@NotNull Project project, @NotNull ExternalSystemTaskExecutionSettings settings) {
        return AbstractExternalSystemTaskConfigurationType.generateName(project, settings.getExternalSystemId(), settings.getExternalProjectPath(), settings.getTaskNames(), settings.getExecutionName());
    }

    @NotNull
    public static String generateName(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames, @Nullable String executionName) {
        return AbstractExternalSystemTaskConfigurationType.generateName(project, externalSystemId, externalProjectPath, taskNames, executionName, " [", "]");
    }

    @NotNull
    public static String generateName(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames, @Nullable String executionName, @NotNull String tasksPrefix, @NotNull String tasksPostfix) {
        String projectName;
        ExternalProjectInfo projectInfo;
        boolean isTasksAbsent = taskNames.isEmpty();
        String rootProjectPath = null;
        if (externalProjectPath != null && (projectInfo = ExternalSystemUtil.getExternalProjectInfo(project, externalSystemId, externalProjectPath)) != null) {
            rootProjectPath = projectInfo.getExternalProjectPath();
        }
        StringBuilder buffer = new StringBuilder();
        if (rootProjectPath == null) {
            projectName = null;
        } else {
            ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
            projectName = uiAware.getProjectRepresentationName(project, externalProjectPath, rootProjectPath);
        }
        if (!StringUtil.isEmptyOrSpaces(projectName)) {
            buffer.append(projectName);
        } else if (!StringUtil.isEmptyOrSpaces((String)externalProjectPath)) {
            buffer.append(externalProjectPath);
        }
        if (!isTasksAbsent) {
            buffer.append(tasksPrefix);
        }
        if (!StringUtil.isEmpty((String)executionName)) {
            buffer.append(executionName);
        } else if (!isTasksAbsent) {
            for (String taskName : taskNames) {
                buffer.append(taskName).append(' ');
            }
            buffer.setLength(buffer.length() - 1);
        }
        if (!isTasksAbsent) {
            buffer.append(tasksPostfix);
        }
        if (buffer.length() == 0) {
            buffer.append(ExecutionBundle.message((String)"run.configuration.unnamed.name.prefix", (Object[])new Object[0]));
        }
        return buffer.toString();
    }
}

