/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultExternalSystemExecutionConsoleManager
implements ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> {
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return ProjectSystemId.IDE;
    }

    @Nullable
    public ExecutionConsole attachExecutionConsole(@NotNull Project project, @NotNull ExternalSystemTask task, @Nullable ExecutionEnvironment env, @Nullable ProcessHandler processHandler) {
        ConsoleView executionConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        executionConsole.attachToProcess(processHandler);
        return executionConsole;
    }

    @Nullable
    public ExecutionConsole attachExecutionConsole(@NotNull ExternalSystemTask task, @NotNull Project project, @NotNull ExternalSystemRunConfiguration configuration, @NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler processHandler) throws ExecutionException {
        return this.attachExecutionConsole(project, task, env, processHandler);
    }

    public void onOutput(@NotNull ExecutionConsole executionConsole, @NotNull ProcessHandler processHandler, @NotNull String text, @NotNull Key processOutputType) {
        processHandler.notifyTextAvailable(text, processOutputType);
    }

    public boolean isApplicableFor(@NotNull ExternalSystemTask task) {
        return true;
    }

    public AnAction[] getRestartActions(@NotNull ExecutionConsole consoleView) {
        return AnAction.EMPTY_ARRAY;
    }
}

