/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ExternalSystemJavaUtil {
    @Nullable
    static SdkType getJavaSdk() {
        try {
            return JavaSdk.getInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    static Sdk getInternalJdk() {
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        try {
            if (projectJdkTable instanceof JavaAwareProjectJdkTableImpl) {
                return ((JavaAwareProjectJdkTableImpl)projectJdkTable).getInternalJdk();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    static Sdk tryAddJdk(String homePath) {
        SdkType javaSdk = ExternalSystemJavaUtil.getJavaSdk();
        if (javaSdk == null) {
            return null;
        }
        Sdk jdk = ((JavaSdk)javaSdk).createJdk(javaSdk.suggestSdkName(null, homePath), homePath, !JdkUtil.checkForJdk((String)homePath));
        SdkConfigurationUtil.addSdk((Sdk)jdk);
        return jdk;
    }
}

