/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJavaUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.service.execution.ProjectJdkNotFoundException;
import com.intellij.openapi.externalSystem.service.execution.UndefinedJavaHomeException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkUtil {
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    public static final String USE_JAVA_HOME = "#JAVA_HOME";

    @Nullable
    @Contract(value="_, null -> null")
    public static Sdk getJdk(@Nullable Project project, @Nullable String jdkName) throws ExternalSystemJdkException {
        if (jdkName == null) {
            return null;
        }
        if (USE_INTERNAL_JAVA.equals(jdkName)) {
            return ExternalSystemJdkUtil.getInternalJdk();
        }
        if (USE_PROJECT_JDK.equals(jdkName)) {
            return ExternalSystemJdkUtil.getProjectJdk(project);
        }
        if (USE_JAVA_HOME.equals(jdkName)) {
            return ExternalSystemJdkUtil.getJavaHomeJdk();
        }
        return ExternalSystemJdkUtil.getJdk(jdkName);
    }

    @Nullable
    @Contract(value="_, null -> null")
    public static Sdk resolveJdkName(@Nullable Sdk projectSdk, @Nullable String jdkName) throws ExternalSystemJdkException {
        if (jdkName == null) {
            return null;
        }
        if (USE_INTERNAL_JAVA.equals(jdkName)) {
            return ExternalSystemJdkUtil.getInternalJdk();
        }
        if (USE_PROJECT_JDK.equals(jdkName)) {
            if (projectSdk != null) {
                return projectSdk;
            }
            throw new ProjectJdkNotFoundException();
        }
        if (USE_JAVA_HOME.equals(jdkName)) {
            return ExternalSystemJdkUtil.getJavaHomeJdk();
        }
        return ExternalSystemJdkUtil.getJdk(jdkName);
    }

    @NotNull
    private static Sdk getProjectJdk(@Nullable Project project) {
        SdkType jdkType;
        if (project != null) {
            Module[] modules;
            Sdk res = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (res != null) {
                return res;
            }
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
                return sdk;
            }
        }
        if ((jdkType = ExternalSystemJdkUtil.getJavaSdk()) == null) {
            return ExternalSystemJdkUtil.getInternalJdk();
        }
        return ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)jdkType).stream().filter(it -> ExternalSystemJdkUtil.isValidJdk(it.getHomePath())).max(jdkType.versionComparator()).orElseGet(ExternalSystemJdkUtil::getInternalJdk);
    }

    @NotNull
    private static Sdk getJavaHomeJdk() {
        String javaHome = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME");
        if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
            throw new UndefinedJavaHomeException();
        }
        if (!ExternalSystemJdkUtil.isValidJdk(javaHome)) {
            throw new InvalidJavaHomeException(javaHome);
        }
        SimpleJavaSdkType sdkType = SimpleJavaSdkType.getInstance();
        String sdkName = sdkType.suggestSdkName(null, javaHome);
        return sdkType.createJdk(sdkName, javaHome);
    }

    @Nullable
    private static Sdk getJdk(@NotNull String jdkName) {
        Sdk jdk = ProjectJdkTable.getInstance().findJdk(jdkName);
        if (jdk == null) {
            return null;
        }
        String homePath = jdk.getHomePath();
        if (!ExternalSystemJdkUtil.isValidJdk(homePath)) {
            throw new InvalidSdkException(homePath);
        }
        return jdk;
    }

    @NotNull
    public static Pair<String, Sdk> getAvailableJdk(@Nullable Project project) throws ExternalSystemJdkException {
        String javaHome;
        Stream<Sdk> projectSdks;
        Sdk projectSdk;
        SdkType javaSdkType = ExternalSystemJdkUtil.getJavaSdkType();
        if (project != null && (projectSdk = (Sdk)(projectSdks = Stream.concat(Stream.of(ProjectRootManager.getInstance((Project)project).getProjectSdk()), Stream.of(ModuleManager.getInstance((Project)project).getModules()).map(module -> ModuleRootManager.getInstance((Module)module).getSdk()))).filter(sdk -> sdk != null && sdk.getSdkType() == javaSdkType && ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).findFirst().orElse(null)) != null) {
            return Pair.pair((Object)USE_PROJECT_JDK, (Object)projectSdk);
        }
        List allJdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdkType);
        Sdk mostRecentSdk = allJdks.stream().filter(sdk -> ExternalSystemJdkUtil.isValidJdk(sdk.getHomePath())).max(javaSdkType.versionComparator()).orElse(null);
        if (mostRecentSdk != null) {
            return Pair.pair((Object)mostRecentSdk.getName(), (Object)mostRecentSdk);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ExternalSystemJdkUtil.isValidJdk(javaHome = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME"))) {
            SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
            String sdkName = simpleJavaSdkType.suggestSdkName(null, javaHome);
            return Pair.pair((Object)USE_JAVA_HOME, (Object)simpleJavaSdkType.createJdk(sdkName, javaHome));
        }
        return Pair.pair((Object)USE_INTERNAL_JAVA, (Object)ExternalSystemJdkUtil.getInternalJdk());
    }

    @NotNull
    public static Collection<String> suggestJdkHomePaths() {
        return ExternalSystemJdkUtil.getJavaSdkType().suggestHomePaths();
    }

    @NotNull
    public static SdkType getJavaSdkType() {
        SdkType javaSdk = ExternalSystemJdkUtil.getJavaSdk();
        return javaSdk == null ? SimpleJavaSdkType.getInstance() : javaSdk;
    }

    @Deprecated
    public static boolean checkForJdk(@NotNull Project project, @Nullable String jdkName) {
        try {
            Sdk sdk = ExternalSystemJdkUtil.getJdk(project, jdkName);
            return sdk != null && sdk.getHomePath() != null && JdkUtil.checkForJdk((String)sdk.getHomePath());
        }
        catch (ExternalSystemJdkException externalSystemJdkException) {
            return false;
        }
    }

    public static boolean isValidJdk(@Nullable String homePath) {
        return !StringUtil.isEmptyOrSpaces((String)homePath) && JdkUtil.checkForJdk((String)homePath) && JdkUtil.checkForJre((String)homePath);
    }

    @NotNull
    public static Sdk addJdk(String homePath) {
        Sdk jdk;
        if (ExternalSystemJdkUtil.isJavaSdkPresent() && (jdk = ExternalSystemJavaUtil.tryAddJdk(homePath)) != null) {
            return jdk;
        }
        SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
        jdk = simpleJavaSdkType.createJdk(simpleJavaSdkType.suggestSdkName(null, homePath), homePath);
        SdkConfigurationUtil.addSdk((Sdk)jdk);
        return jdk;
    }

    @Nullable
    private static SdkType getJavaSdk() {
        if (ExternalSystemJdkUtil.isJavaSdkPresent()) {
            return ExternalSystemJavaUtil.getJavaSdk();
        }
        return null;
    }

    @NotNull
    private static Sdk getInternalJdk() {
        Sdk internalJdk;
        if (ExternalSystemJdkUtil.isJavaSdkPresent() && (internalJdk = ExternalSystemJavaUtil.getInternalJdk()) != null) {
            return internalJdk;
        }
        String jdkHome = SystemProperties.getJavaHome();
        SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
        return simpleJavaSdkType.createJdk(simpleJavaSdkType.suggestSdkName(null, jdkHome), jdkHome);
    }

    private static boolean isJavaSdkPresent() {
        try {
            Class.forName("com.intellij.openapi.projectRoots.impl.JavaSdkImpl");
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }
}

