/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProcessHandler
extends BuildProcessHandler
implements AnsiEscapeDecoder.ColoredTextAcceptor,
Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalSystemProcessHandler.class);
    private final String myExecutionName;
    @Nullable
    private ExternalSystemTask myTask;
    private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();
    @Nullable
    private OutputStream myProcessInput;

    public ExternalSystemProcessHandler(@NotNull ExternalSystemTask task, String executionName) {
        this.myTask = task;
        this.myExecutionName = executionName;
        if (task instanceof UserDataHolder) {
            try {
                Pipe pipe = Pipe.open();
                BufferedInputStream inputStream = new BufferedInputStream(Channels.newInputStream(pipe.source()));
                this.myProcessInput = new BufferedOutputStream(Channels.newOutputStream(pipe.sink()));
                ((UserDataHolder)task).putUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY, (Object)inputStream);
            }
            catch (IOException e) {
                LOG.warn("Unable to setup process input", (Throwable)e);
            }
        }
    }

    public String getExecutionName() {
        return this.myExecutionName;
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
        this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
    }

    protected void destroyProcessImpl() {
        ExternalSystemTask task = this.myTask;
        if (task != null) {
            task.cancel(new ExternalSystemTaskNotificationListener[0]);
        }
        this.closeInput();
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
        this.closeInput();
    }

    public boolean detachIsDefault() {
        return false;
    }

    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcessInput;
    }

    public void notifyProcessTerminated(int exitCode) {
        super.notifyProcessTerminated(exitCode);
        this.closeInput();
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
        super.notifyTextAvailable(text, attributes);
    }

    protected void closeInput() {
        ExternalSystemTask task = this.myTask;
        if (task instanceof UserDataHolder) {
            ((UserDataHolder)task).putUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY, null);
        }
        StreamUtil.closeStream((Closeable)this.myProcessInput);
        this.myProcessInput = null;
    }

    public void dispose() {
        try {
            this.detachProcessImpl();
        }
        finally {
            this.myTask = null;
        }
    }
}

