/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskDebugRunner;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.UIUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ForkedDebuggerThread
extends Thread {
    @NotNull
    private final ProcessHandler myMainProcessHandler;
    @NotNull
    private final ServerSocket mySocket;
    @NotNull
    private final Project myProject;
    @Nullable
    private final ExecutionConsole myMainExecutionConsole;

    ForkedDebuggerThread(@NotNull ProcessHandler mainProcessHandler, @NotNull RunContentDescriptor mainRunContentDescriptor, @NotNull ServerSocket socket, @NotNull Project project) {
        super("external task forked debugger runner");
        this.setDaemon(true);
        this.mySocket = socket;
        this.myProject = project;
        this.myMainProcessHandler = mainProcessHandler;
        this.myMainExecutionConsole = mainRunContentDescriptor.getExecutionConsole();
        this.myMainProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                this.closeSocket();
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                this.closeSocket();
            }

            void closeSocket() {
                try {
                    if (!ForkedDebuggerThread.this.mySocket.isClosed()) {
                        ForkedDebuggerThread.this.mySocket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void run() {
        while (!(this.myMainProcessHandler.isProcessTerminated() || this.myMainProcessHandler.isProcessTerminating() || this.mySocket.isClosed())) {
            try {
                this.handleForkedProcessSignal(this.mySocket.accept());
            }
            catch (EOFException eOFException) {
            }
            catch (IOException e) {
                ExternalSystemTaskDebugRunner.LOG.warn((Throwable)e);
            }
        }
        try {
            if (!this.mySocket.isClosed()) {
                this.mySocket.close();
            }
        }
        catch (IOException e) {
            ExternalSystemTaskDebugRunner.LOG.debug((Throwable)e);
        }
    }

    private void handleForkedProcessSignal(final Socket accept) throws IOException {
        final DataInputStream stream = new DataInputStream(accept.getInputStream());
        this.myMainProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                StreamUtil.closeStream((Closeable)stream);
                StreamUtil.closeStream((Closeable)accept);
            }
        });
        int signal = stream.readInt();
        final String processName = stream.readUTF();
        if (signal > 0) {
            String debugPort = String.valueOf(signal);
            ForkedDebuggerThread.attachVM(this.myProject, processName, debugPort, new ProgramRunner.Callback(){

                public void processStarted(RunContentDescriptor descriptor2) {
                    descriptor2.setSelectContentWhenAdded(false);
                    final ProcessHandler forkedProcessHandler = descriptor2.getProcessHandler();
                    if (forkedProcessHandler != null) {
                        ForkedDebuggerThread.this.myMainProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                                ForkedDebuggerThread.this.myMainProcessHandler.removeProcessListener((ProcessListener)this);
                                ForkedDebuggerThread.this.terminateForkedProcess(forkedProcessHandler);
                            }
                        });
                        forkedProcessHandler.addProcessListener((ProcessListener)new MyForkedProcessListener(descriptor2, processName));
                        try {
                            accept.getOutputStream().write(0);
                            stream.close();
                        }
                        catch (IOException e) {
                            ExternalSystemTaskDebugRunner.LOG.debug((Throwable)e);
                        }
                    }
                }
            });
        } else if (signal == 0) {
            ApplicationManager.getApplication().invokeLater(() -> {
                ProcessHandler handler;
                RunContentDescriptor descriptor2;
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
                ContentManager contentManager = toolWindowManager.getToolWindow(ToolWindowId.DEBUG).getContentManager();
                Content content = contentManager.findContent(processName);
                if (content != null && (descriptor2 = (RunContentDescriptor)content.getUserData(RunContentDescriptor.DESCRIPTOR_KEY)) != null && (handler = descriptor2.getProcessHandler()) != null) {
                    handler.destroyProcess();
                }
                try {
                    accept.getOutputStream().write(0);
                    stream.close();
                }
                catch (IOException e) {
                    ExternalSystemTaskDebugRunner.LOG.debug((Throwable)e);
                }
            });
        }
    }

    private static void attachVM(@NotNull Project project, String runConfigName, @NotNull String debugPort, ProgramRunner.Callback callback) {
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createConfiguration(runConfigName, RemoteConfigurationType.class);
        runSettings.setActivateToolWindowBeforeRun(false);
        RemoteConfiguration configuration = (RemoteConfiguration)runSettings.getConfiguration();
        configuration.HOST = "localhost";
        configuration.PORT = debugPort;
        configuration.USE_SOCKET_TRANSPORT = true;
        configuration.SERVER_MODE = true;
        try {
            ExecutionEnvironment environment = ExecutionEnvironmentBuilder.create((Executor)DefaultDebugExecutor.getDebugExecutorInstance(), (RunnerAndConfigurationSettings)runSettings).contentToReuse(null).dataContext(null).activeTarget().build();
            ProgramRunnerUtil.executeConfigurationAsync((ExecutionEnvironment)environment, (boolean)true, (boolean)true, (ProgramRunner.Callback)callback);
        }
        catch (ExecutionException e) {
            ExternalSystemTaskDebugRunner.LOG.error((Throwable)e);
        }
    }

    private void terminateForkedProcess(@NotNull ProcessHandler processHandler) {
        final DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(processHandler);
        if (debugProcess != null) {
            debugProcess.getManagerThread().invokeCommand(new DebuggerCommand(){

                public void action() {
                    VirtualMachineProxy virtualMachineProxy = debugProcess.getVirtualMachineProxy();
                    if (virtualMachineProxy instanceof VirtualMachineProxyImpl && ((VirtualMachineProxyImpl)virtualMachineProxy).canBeModified()) {
                        ((VirtualMachineProxyImpl)virtualMachineProxy).exit(0);
                    } else {
                        debugProcess.stop(true);
                    }
                }

                public void commandCancelled() {
                    debugProcess.stop(true);
                }
            });
        } else {
            processHandler.destroyProcess();
        }
    }

    private class MyForkedProcessListener
    extends ProcessAdapter {
        @NotNull
        private final RunContentDescriptor myDescriptor;
        @NotNull
        private final String myProcessName;
        @Nullable
        private RangeHighlighter myHyperlink;

        MyForkedProcessListener(@NotNull RunContentDescriptor descriptor2, String processName) {
            this.myDescriptor = descriptor2;
            this.myProcessName = processName;
        }

        public void startNotified(@NotNull ProcessEvent event) {
            this.postLink();
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            if (!willBeDestroyed) {
                ForkedDebuggerThread.this.terminateForkedProcess(event.getProcessHandler());
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)ForkedDebuggerThread.this.myProject);
            ContentManager contentManager = toolWindowManager.getToolWindow(ToolWindowId.DEBUG).getContentManager();
            Content content = this.myDescriptor.getAttachedContent();
            if (content != null) {
                ApplicationManager.getApplication().invokeLater(() -> contentManager.removeContent(content, true));
            }
            this.removeLink();
        }

        private void postLink() {
            ConsoleViewImpl mainConsoleView = this.getMainConsoleView();
            if (mainConsoleView != null) {
                ProcessHandler handler = this.myDescriptor.getProcessHandler();
                String addressDisplayName = "";
                DebugProcess debugProcess = DebuggerManager.getInstance((Project)ForkedDebuggerThread.this.myProject).getDebugProcess(handler);
                if (debugProcess instanceof DebugProcessImpl) {
                    addressDisplayName = "(" + DebuggerBundle.getAddressDisplayName((RemoteConnection)((DebugProcessImpl)debugProcess).getConnection()) + ")";
                }
                String linkText = ExternalSystemBundle.message((String)"debugger.open.session.tab", (Object[])new Object[0]);
                String debuggerAttachedStatusMessage = ExternalSystemBundle.message((String)"debugger.status.connected", (Object[])new Object[]{this.myProcessName, addressDisplayName}) + ". " + linkText + '\n';
                mainConsoleView.print(debuggerAttachedStatusMessage, ConsoleViewContentType.SYSTEM_OUTPUT);
                mainConsoleView.performWhenNoDeferredOutput(() -> {
                    EditorHyperlinkSupport hyperlinkSupport = mainConsoleView.getHyperlinks();
                    int messageOffset = mainConsoleView.getText().indexOf(debuggerAttachedStatusMessage);
                    int linkStartOffset = messageOffset + debuggerAttachedStatusMessage.indexOf(linkText);
                    this.myHyperlink = hyperlinkSupport.createHyperlink(linkStartOffset, linkStartOffset + linkText.length(), null, project -> {
                        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)ForkedDebuggerThread.this.myProject);
                        ContentManager contentManager = toolWindowManager.getToolWindow(ToolWindowId.DEBUG).getContentManager();
                        Content content = this.myDescriptor.getAttachedContent();
                        if (content != null) {
                            contentManager.setSelectedContent(content, true, true);
                        }
                    });
                });
            }
        }

        private void removeLink() {
            ConsoleViewImpl mainConsoleView;
            if (this.myHyperlink != null && (mainConsoleView = this.getMainConsoleView()) != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    EditorHyperlinkSupport hyperlinkSupport = mainConsoleView.getHyperlinks();
                    int startOffset = this.myHyperlink.getStartOffset();
                    int endOffset = this.myHyperlink.getEndOffset();
                    TextAttributes inactiveTextAttributes = this.myHyperlink.getTextAttributes() != null ? this.myHyperlink.getTextAttributes().clone() : TextAttributes.ERASE_MARKER.clone();
                    inactiveTextAttributes.setForegroundColor(UIUtil.getInactiveTextColor());
                    inactiveTextAttributes.setEffectColor(UIUtil.getInactiveTextColor());
                    inactiveTextAttributes.setFontType(2);
                    hyperlinkSupport.removeHyperlink(this.myHyperlink);
                    hyperlinkSupport.addHighlighter(startOffset, endOffset, inactiveTextAttributes, 5800);
                });
            }
        }

        @Nullable
        private ConsoleViewImpl getMainConsoleView() {
            Object consoleView;
            if (ForkedDebuggerThread.this.myMainExecutionConsole == null) {
                return null;
            }
            if (ForkedDebuggerThread.this.myMainExecutionConsole instanceof ConsoleViewImpl) {
                return (ConsoleViewImpl)ForkedDebuggerThread.this.myMainExecutionConsole;
            }
            if (ForkedDebuggerThread.this.myMainExecutionConsole instanceof DataProvider && (consoleView = ((DataProvider)ForkedDebuggerThread.this.myMainExecutionConsole).getData(LangDataKeys.CONSOLE_VIEW.getName())) instanceof ConsoleViewImpl) {
                return (ConsoleViewImpl)consoleView;
            }
            return null;
        }
    }
}

