/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProcessingManager
implements ExternalSystemTaskNotificationListener,
Disposable {
    private static final long TOO_LONG_EXECUTION_MS = TimeUnit.SECONDS.toMillis(10L);
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, Long> myTasksInProgress = ContainerUtil.newConcurrentMap();
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, ExternalSystemTask> myTasksDetails = ContainerUtil.newConcurrentMap();
    @NotNull
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    @NotNull
    private final ExternalSystemFacadeManager myFacadeManager;
    @NotNull
    private final ExternalSystemProgressNotificationManager myProgressNotificationManager;

    public ExternalSystemProcessingManager(@NotNull ExternalSystemFacadeManager facadeManager, @NotNull ExternalSystemProgressNotificationManager notificationManager) {
        this.myFacadeManager = facadeManager;
        this.myProgressNotificationManager = notificationManager;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        notificationManager.addNotificationListener(this);
    }

    public void dispose() {
        this.myProgressNotificationManager.removeNotificationListener(this);
        this.myAlarm.cancelAllRequests();
    }

    public boolean hasTaskOfTypeInProgress(@NotNull ExternalSystemTaskType type, @NotNull Project project) {
        String projectId = ExternalSystemTaskId.getProjectId((Project)project);
        for (ExternalSystemTaskId id : this.myTasksInProgress.keySet()) {
            if (!type.equals((Object)id.getType()) || !projectId.equals(id.getIdeProjectId())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ExternalSystemTask findTask(@NotNull ExternalSystemTaskType type, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        for (ExternalSystemTask task : this.myTasksDetails.values()) {
            AbstractExternalSystemTask externalSystemTask;
            if (!(task instanceof AbstractExternalSystemTask) || (externalSystemTask = (AbstractExternalSystemTask)task).getId().getType() != type || !externalSystemTask.getExternalSystemId().getId().equals(projectSystemId.getId()) || !externalSystemTask.getExternalProjectPath().equals(externalProjectPath)) continue;
            return task;
        }
        return null;
    }

    @NotNull
    public List<ExternalSystemTask> findTasksOfState(@NotNull ProjectSystemId projectSystemId, ExternalSystemTaskState ... taskStates) {
        SmartList result = new SmartList();
        for (ExternalSystemTask task : this.myTasksDetails.values()) {
            AbstractExternalSystemTask externalSystemTask;
            if (!(task instanceof AbstractExternalSystemTask) || !(externalSystemTask = (AbstractExternalSystemTask)task).getExternalSystemId().getId().equals(projectSystemId.getId()) || !ArrayUtil.contains((Object)externalSystemTask.getState(), (Object[])taskStates)) continue;
            result.add(task);
        }
        return result;
    }

    public void add(@NotNull ExternalSystemTask task) {
        this.myTasksDetails.put(task.getId(), task);
    }

    public void release(@NotNull ExternalSystemTaskId id) {
        this.myTasksDetails.remove(id);
    }

    public void onQueued(@NotNull ExternalSystemTaskId id, String workingDir) {
        this.onStart(id, workingDir);
    }

    public void onStart(@NotNull ExternalSystemTaskId id, String workingDir) {
        this.myTasksInProgress.put(id, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
        if (this.myAlarm.getActiveRequestCount() <= 0) {
            this.myAlarm.addRequest(() -> this.update(), TOO_LONG_EXECUTION_MS);
        }
    }

    public void onStart(@NotNull ExternalSystemTaskId id) {
        this.myTasksInProgress.put(id, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
        this.myTasksInProgress.put(event.getId(), System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
        this.myTasksInProgress.put(id, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onEnd(@NotNull ExternalSystemTaskId id) {
        this.myTasksInProgress.remove(id);
        if (this.myTasksInProgress.isEmpty()) {
            this.myAlarm.cancelAllRequests();
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId id) {
    }

    public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
    }

    public void beforeCancel(@NotNull ExternalSystemTaskId id) {
    }

    public void onCancel(@NotNull ExternalSystemTaskId id) {
    }

    public void update() {
        long delay = TOO_LONG_EXECUTION_MS;
        HashMap newState = ContainerUtilRt.newHashMap();
        HashMap currentState = ContainerUtilRt.newHashMap(this.myTasksInProgress);
        if (currentState.isEmpty()) {
            return;
        }
        for (Map.Entry entry : currentState.entrySet()) {
            long diff = System.currentTimeMillis() - (Long)entry.getValue();
            if (diff > 0L) {
                delay = Math.min(delay, diff);
                newState.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!this.myFacadeManager.isTaskActive((ExternalSystemTaskId)entry.getKey())) continue;
            newState.put(entry.getKey(), System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
        }
        this.myTasksInProgress.clear();
        this.myTasksInProgress.putAll(newState);
        if (!newState.isEmpty()) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.update(), delay);
        }
    }
}

