/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationData
implements Disposable {
    @NotNull
    private String myTitle;
    @NotNull
    private String myMessage;
    @NotNull
    private NotificationCategory myNotificationCategory;
    @NotNull
    private final NotificationSource myNotificationSource;
    @NotNull
    private final NotificationListener myListener;
    @Nullable
    private String myFilePath;
    @Nullable
    private Navigatable navigatable;
    private int myLine;
    private int myColumn;
    private boolean myBalloonNotification;
    @Nullable
    private String myBalloonGroup;
    private final Map<String, NotificationListener> myListenerMap;

    public NotificationData(@NotNull String title, @NotNull String message, @NotNull NotificationCategory notificationCategory, @NotNull NotificationSource notificationSource) {
        this(title, message, notificationCategory, notificationSource, null, -1, -1, false);
    }

    public NotificationData(@NotNull String title, @NotNull String message, @NotNull NotificationCategory notificationCategory, @NotNull NotificationSource notificationSource, @Nullable String filePath, int line, int column, boolean balloonNotification) {
        this.myTitle = title;
        this.myMessage = message;
        this.myNotificationCategory = notificationCategory;
        this.myNotificationSource = notificationSource;
        this.myListenerMap = ContainerUtil.newHashMap();
        this.myListener = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                NotificationListener notificationListener = (NotificationListener)NotificationData.this.myListenerMap.get(event.getDescription());
                if (notificationListener != null) {
                    notificationListener.hyperlinkUpdate(notification, event);
                }
            }
        };
        this.myFilePath = filePath;
        this.myLine = line;
        this.myColumn = column;
        this.myBalloonNotification = balloonNotification;
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(@NotNull String title) {
        this.myTitle = title;
    }

    @NotNull
    public String getMessage() {
        return this.myMessage;
    }

    public void setMessage(@NotNull String message) {
        this.myMessage = message;
    }

    @NotNull
    public NotificationCategory getNotificationCategory() {
        return this.myNotificationCategory;
    }

    public void setNotificationCategory(@NotNull NotificationCategory notificationCategory) {
        this.myNotificationCategory = notificationCategory;
    }

    @NotNull
    public NotificationSource getNotificationSource() {
        return this.myNotificationSource;
    }

    @NotNull
    public NotificationListener getListener() {
        return this.myListener;
    }

    @Nullable
    public String getFilePath() {
        return this.myFilePath;
    }

    public void setFilePath(@Nullable String filePath) {
        this.myFilePath = filePath;
    }

    @NotNull
    public Integer getLine() {
        return this.myLine;
    }

    public void setLine(int line) {
        this.myLine = line;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public void setColumn(int column) {
        this.myColumn = column;
    }

    public boolean isBalloonNotification() {
        return this.myBalloonNotification;
    }

    public void setBalloonNotification(boolean balloonNotification) {
        this.myBalloonNotification = balloonNotification;
    }

    public void setListener(@NotNull String listenerId, @NotNull NotificationListener listener) {
        this.myListenerMap.put(listenerId, listener);
    }

    boolean hasLinks() {
        return !this.myListenerMap.isEmpty();
    }

    public List<String> getRegisteredListenerIds() {
        return ContainerUtil.newArrayList(this.myListenerMap.keySet());
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.navigatable;
    }

    public void setNavigatable(@Nullable Navigatable navigatable) {
        this.navigatable = navigatable;
    }

    @Nullable
    public String getBalloonGroup() {
        return this.myBalloonGroup;
    }

    public void setBalloonGroup(@Nullable String balloonGroup) {
        this.myBalloonGroup = balloonGroup;
    }

    public void dispose() {
        this.myListenerMap.clear();
    }
}

