/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporter;
import com.intellij.openapi.externalSystem.service.project.ArtifactExternalDependenciesImporterImpl;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectsWorkspaceImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ModifiableWorkspace;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.TestModuleProperties;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.DefaultManifestFileProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIdeModifiableModelsProvider
extends IdeModelsProviderImpl
implements IdeModifiableModelsProvider {
    private static final Logger LOG = Logger.getInstance(AbstractIdeModifiableModelsProvider.class);
    private ModifiableModuleModel myModifiableModuleModel;
    private final Map<Module, ModifiableRootModel> myModifiableRootModels = new THashMap();
    private final Map<Module, ModifiableFacetModel> myModifiableFacetModels = new THashMap();
    private final Map<Module, String> myProductionModulesForTestModules = new THashMap();
    private final Map<Library, Library.ModifiableModel> myModifiableLibraryModels = new IdentityHashMap<Library, Library.ModifiableModel>();
    private ModifiableArtifactModel myModifiableArtifactModel;
    private MyPackagingElementResolvingContext myPackagingElementResolvingContext;
    private final ArtifactExternalDependenciesImporter myArtifactExternalDependenciesImporter;
    @Nullable
    private ModifiableWorkspace myModifiableWorkspace;
    private final MyUserDataHolderBase myUserData = new MyUserDataHolderBase();
    private volatile boolean myDisposed;

    public AbstractIdeModifiableModelsProvider(@NotNull Project project) {
        super(project);
        this.myArtifactExternalDependenciesImporter = new ArtifactExternalDependenciesImporterImpl();
    }

    protected abstract ModifiableArtifactModel doGetModifiableArtifactModel();

    protected abstract ModifiableModuleModel doGetModifiableModuleModel();

    protected abstract ModifiableRootModel doGetModifiableRootModel(Module var1);

    protected abstract ModifiableFacetModel doGetModifiableFacetModel(Module var1);

    protected abstract Library.ModifiableModel doGetModifiableLibraryModel(Library var1);

    @NotNull
    public abstract LibraryTable.ModifiableModel getModifiableProjectLibrariesModel();

    @Override
    @NotNull
    public Module[] getModules() {
        return this.getModifiableModuleModel().getModules();
    }

    protected void processExternalArtifactDependencies() {
        this.myArtifactExternalDependenciesImporter.applyChanges(this.getModifiableArtifactModel(), this.getPackagingElementResolvingContext());
    }

    public PackagingElementResolvingContext getPackagingElementResolvingContext() {
        if (this.myPackagingElementResolvingContext == null) {
            this.myPackagingElementResolvingContext = new MyPackagingElementResolvingContext();
        }
        return this.myPackagingElementResolvingContext;
    }

    @Override
    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull Module module) {
        return this.getRootModel(module).getOrderEntries();
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        Module module = this.getModifiableModuleModel().newModule(filePath, moduleTypeId);
        String moduleName = FileUtil.getNameWithoutExtension((File)new File(filePath));
        if (!module.getName().equals(moduleName)) {
            try {
                this.getModifiableModuleModel().renameModule(module, moduleName);
            }
            catch (ModuleWithNameAlreadyExists exists) {
                LOG.warn((Throwable)exists);
            }
        }
        module.setModuleType(moduleTypeId);
        return module;
    }

    @NotNull
    public Module newModule(@NotNull ModuleData moduleData) {
        String imlName = null;
        for (String candidate : this.suggestModuleNameCandidates(moduleData)) {
            Module module = this.findIdeModule(candidate);
            if (module != null) continue;
            imlName = candidate;
            break;
        }
        assert (imlName != null) : "Too many duplicated module names";
        String filePath = ExternalSystemApiUtil.toCanonicalPath((String)(moduleData.getModuleFileDirectoryPath() + "/" + imlName + ".iml"));
        return this.newModule(filePath, moduleData.getModuleTypeId());
    }

    @Override
    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        Module module = this.getModifiableModuleModel().findModuleByName(ideModuleName);
        return module == null ? this.getModifiableModuleModel().getModuleToBeRenamed(ideModuleName) : module;
    }

    @Override
    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        LibraryTable.ModifiableModel libraryTable = this.getModifiableProjectLibrariesModel();
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Override
    @NotNull
    public VirtualFile[] getContentRoots(Module module) {
        return this.getRootModel(module).getContentRoots();
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots(Module module) {
        return this.getRootModel(module).getSourceRoots();
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceRoots(Module module, boolean includingTests) {
        return this.getRootModel(module).getSourceRoots(includingTests);
    }

    @NotNull
    public ModifiableModuleModel getModifiableModuleModel() {
        if (this.myModifiableModuleModel == null) {
            this.myModifiableModuleModel = this.doGetModifiableModuleModel();
        }
        return this.myModifiableModuleModel;
    }

    @NotNull
    public ModifiableRootModel getModifiableRootModel(Module module) {
        return (ModifiableRootModel)this.getRootModel(module);
    }

    @NotNull
    private ModuleRootModel getRootModel(Module module) {
        return (ModuleRootModel)this.myModifiableRootModels.computeIfAbsent(module, k -> this.doGetModifiableRootModel(module));
    }

    @NotNull
    public ModifiableFacetModel getModifiableFacetModel(Module module) {
        return this.myModifiableFacetModels.computeIfAbsent(module, k -> this.doGetModifiableFacetModel(module));
    }

    @NotNull
    public ModifiableArtifactModel getModifiableArtifactModel() {
        if (this.myModifiableArtifactModel == null) {
            this.myModifiableArtifactModel = this.doGetModifiableArtifactModel();
        }
        return this.myModifiableArtifactModel;
    }

    @Override
    @NotNull
    public Library[] getAllLibraries() {
        return this.getModifiableProjectLibrariesModel().getLibraries();
    }

    @Override
    @Nullable
    public Library getLibraryByName(String name) {
        return this.getModifiableProjectLibrariesModel().getLibraryByName(name);
    }

    public Library createLibrary(String name) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name);
    }

    public Library createLibrary(String name, @Nullable ProjectModelExternalSource externalSource) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name, null, externalSource);
    }

    public void removeLibrary(Library library) {
        this.getModifiableProjectLibrariesModel().removeLibrary(library);
    }

    public Library.ModifiableModel getModifiableLibraryModel(Library library) {
        return this.myModifiableLibraryModels.computeIfAbsent(library, k -> this.doGetModifiableLibraryModel(library));
    }

    @Nullable
    public ModifiableWorkspace getModifiableWorkspace() {
        if (this.myModifiableWorkspace == null && ExternalProjectsWorkspaceImpl.isDependencySubstitutionEnabled()) {
            this.myModifiableWorkspace = this.doGetModifiableWorkspace();
        }
        return this.myModifiableWorkspace;
    }

    @Override
    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        Library.ModifiableModel model = this.myModifiableLibraryModels.get(library);
        if (model != null) {
            return model.getUrls(type);
        }
        return library.getUrls(type);
    }

    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.NON_MODAL;
    }

    public ArtifactExternalDependenciesImporter getArtifactExternalDependenciesImporter() {
        return this.myArtifactExternalDependenciesImporter;
    }

    @Override
    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module) {
        ArrayList<Module> list = new ArrayList<Module>();
        Graph<Module> graph = this.getModuleGraph();
        Iterator i = graph.getOut((Object)module);
        while (i.hasNext()) {
            list.add((Module)i.next());
        }
        return list;
    }

    private ModifiableWorkspace doGetModifiableWorkspace() {
        return (ModifiableWorkspace)ReadAction.compute(() -> ((ExternalProjectsWorkspaceImpl)ServiceManager.getService((Project)this.myProject, ExternalProjectsWorkspaceImpl.class)).createModifiableWorkspace(this));
    }

    private Graph<Module> getModuleGraph() {
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

            @NotNull
            public Collection<Module> getNodes() {
                return ContainerUtil.list((Object[])AbstractIdeModifiableModelsProvider.this.getModules());
            }

            @NotNull
            public Iterator<Module> getIn(Module m) {
                Module[] dependentModules = AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(m).getModuleDependencies(true);
                return Arrays.asList(dependentModules).iterator();
            }
        }));
    }

    public void commit() {
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            if (ExternalProjectsWorkspaceImpl.isDependencySubstitutionEnabled()) {
                this.updateSubstitutions();
            }
            this.processExternalArtifactDependencies();
            for (Map.Entry<Library, Library.ModifiableModel> entry : this.myModifiableLibraryModels.entrySet()) {
                Library fromLibrary = entry.getKey();
                Library.ModifiableModel modifiableModel = entry.getValue();
                if (fromLibrary instanceof LibraryEx && ((LibraryEx)fromLibrary).isDisposed()) {
                    Disposer.dispose((Disposable)modifiableModel);
                    continue;
                }
                modifiableModel.commit();
            }
            this.getModifiableProjectLibrariesModel().commit();
            Collection<ModifiableRootModel> rootModels = this.myModifiableRootModels.values();
            ModifiableRootModel[] rootModels1 = rootModels.toArray(new ModifiableRootModel[0]);
            for (Object model : rootModels1) {
                assert (!model.isDisposed()) : "Already disposed: " + model;
            }
            if (this.myModifiableModuleModel != null) {
                ModifiableModelCommitter.multiCommit((ModifiableRootModel[])rootModels1, (ModifiableModuleModel)this.myModifiableModuleModel);
            } else {
                for (Object model : rootModels1) {
                    model.commit();
                }
            }
            for (Map.Entry entry : this.myProductionModulesForTestModules.entrySet()) {
                TestModuleProperties.getInstance((Module)((Module)entry.getKey())).setProductionModuleName((String)entry.getValue());
            }
            for (Map.Entry entry : this.myModifiableFacetModels.entrySet()) {
                if (((Module)entry.getKey()).isDisposed()) continue;
                ((ModifiableFacetModel)entry.getValue()).commit();
            }
            if (this.myModifiableArtifactModel != null) {
                this.myModifiableArtifactModel.commit();
            }
        });
        this.myUserData.clear();
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!this.myDisposed) : "Already disposed!";
        this.myDisposed = true;
        for (ModifiableRootModel modifiableRootModel : this.myModifiableRootModels.values()) {
            if (modifiableRootModel.isDisposed()) continue;
            modifiableRootModel.dispose();
        }
        Disposer.dispose((Disposable)this.getModifiableProjectLibrariesModel());
        for (Library.ModifiableModel modifiableModel : this.myModifiableLibraryModels.values()) {
            if (modifiableModel instanceof LibraryEx && ((LibraryEx)modifiableModel).isDisposed()) continue;
            Disposer.dispose((Disposable)modifiableModel);
        }
        if (this.myModifiableModuleModel != null && this.myModifiableModuleModel.isChanged()) {
            this.myModifiableModuleModel.dispose();
        }
        if (this.myModifiableArtifactModel != null) {
            this.myModifiableArtifactModel.dispose();
        }
        this.myModifiableRootModels.clear();
        this.myModifiableFacetModels.clear();
        this.myModifiableLibraryModels.clear();
        this.myUserData.clear();
    }

    public void setTestModuleProperties(Module testModule, String productionModuleName) {
        this.myProductionModulesForTestModules.put(testModule, productionModuleName);
    }

    @Nullable
    public String getProductionModuleName(Module module) {
        return this.myProductionModulesForTestModules.get(module);
    }

    public ModuleOrderEntry trySubstitute(Module ownerModule, LibraryOrderEntry libraryOrderEntry, ProjectCoordinate publicationId) {
        Module workspaceModule;
        String workspaceModuleCandidate = this.findModuleByPublication(publicationId);
        Module module = workspaceModule = workspaceModuleCandidate == null ? null : this.findIdeModule(workspaceModuleCandidate);
        if (workspaceModule == null) {
            return null;
        }
        ModifiableRootModel modifiableRootModel = this.getModifiableRootModel(ownerModule);
        ModuleOrderEntry moduleOrderEntry = modifiableRootModel.addModuleOrderEntry(workspaceModule);
        moduleOrderEntry.setScope(libraryOrderEntry.getScope());
        moduleOrderEntry.setExported(libraryOrderEntry.isExported());
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        assert (workspace != null);
        workspace.addSubstitution(ownerModule.getName(), workspaceModule.getName(), libraryOrderEntry.getLibraryName(), libraryOrderEntry.getScope());
        modifiableRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
        return moduleOrderEntry;
    }

    public void registerModulePublication(Module module, ProjectCoordinate modulePublication) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace != null) {
            workspace.register(modulePublication, module);
        }
    }

    public boolean isSubstituted(String libraryName) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace == null) {
            return false;
        }
        return workspace.isSubstituted(libraryName);
    }

    @Nullable
    public <T> T getUserData(@NotNull com.intellij.openapi.util.Key<T> key) {
        return (T)this.myUserData.getUserData(key);
    }

    public <T> void putUserData(@NotNull com.intellij.openapi.util.Key<T> key, @Nullable T value) {
        this.myUserData.putUserData(key, value);
    }

    @Nullable
    public String findModuleByPublication(ProjectCoordinate publicationId) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        return workspace == null ? null : workspace.findModule(publicationId);
    }

    private void updateSubstitutions() {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace == null) {
            return;
        }
        List oldModules = ContainerUtil.map((Object[])ModuleManager.getInstance((Project)this.myProject).getModules(), module -> module.getName());
        List newModules = ContainerUtil.map((Object[])this.myModifiableModuleModel.getModules(), module -> module.getName());
        THashSet removedModules = new THashSet((Collection)oldModules);
        removedModules.removeAll(newModules);
        HashMap toSubstitute = ContainerUtil.newHashMap();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(this.myProject, manager.getSystemId());
            for (ExternalProjectInfo projectInfo : projectsData) {
                if (projectInfo.getExternalProjectStructure() == null) continue;
                Collection libraryNodes = ExternalSystemApiUtil.findAll((DataNode)projectInfo.getExternalProjectStructure(), (Key)ProjectKeys.LIBRARY);
                for (DataNode libraryNode : libraryNodes) {
                    String substitutionModuleCandidate = this.findModuleByPublication((ProjectCoordinate)libraryNode.getData());
                    if (substitutionModuleCandidate == null) continue;
                    toSubstitute.put(((LibraryData)libraryNode.getData()).getInternalName(), substitutionModuleCandidate);
                }
            }
        }
        for (Module module2 : this.getModules()) {
            ModifiableRootModel modifiableRootModel = this.getModifiableRootModel(module2);
            boolean changed = false;
            OrderEntry[] entries = modifiableRootModel.getOrderEntries();
            int length = entries.length;
            for (int i = 0; i < length; ++i) {
                Module ideModule;
                String workspaceModule;
                LibraryOrderEntry libraryOrderEntry;
                String workspaceModule2;
                OrderEntry orderEntry = entries[i];
                if (orderEntry instanceof ModuleOrderEntry && removedModules.contains(workspaceModule2 = ((ModuleOrderEntry)orderEntry).getModuleName())) {
                    Library library;
                    String libraryName;
                    DependencyScope scope = ((ModuleOrderEntry)orderEntry).getScope();
                    if (workspace.isSubstitution(module2.getName(), workspaceModule2, scope) && (libraryName = workspace.getSubstitutedLibrary(workspaceModule2)) != null && (library = this.getLibraryByName(libraryName)) != null) {
                        modifiableRootModel.removeOrderEntry(orderEntry);
                        entries[i] = modifiableRootModel.addLibraryEntry(library);
                        changed = true;
                        workspace.removeSubstitution(module2.getName(), workspaceModule2, libraryName, scope);
                    }
                }
                if (!(orderEntry instanceof LibraryOrderEntry) || (libraryOrderEntry = (LibraryOrderEntry)orderEntry).isModuleLevel() || libraryOrderEntry.getLibraryName() == null || (workspaceModule = (String)toSubstitute.get(libraryOrderEntry.getLibraryName())) == null || (ideModule = this.findIdeModule(workspaceModule)) == null) continue;
                ModuleOrderEntry moduleOrderEntry = modifiableRootModel.addModuleOrderEntry(ideModule);
                moduleOrderEntry.setScope(libraryOrderEntry.getScope());
                modifiableRootModel.removeOrderEntry(orderEntry);
                entries[i] = moduleOrderEntry;
                changed = true;
                workspace.addSubstitution(module2.getName(), workspaceModule, libraryOrderEntry.getLibraryName(), libraryOrderEntry.getScope());
            }
            if (!changed) continue;
            modifiableRootModel.rearrangeOrderEntries(entries);
        }
        workspace.commit();
    }

    private class MyFacetsProvider
    implements FacetsProvider {
        private MyFacetsProvider() {
        }

        @NotNull
        public Facet[] getAllFacets(Module module) {
            return AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module).getAllFacets();
        }

        @NotNull
        public <F extends Facet> Collection<F> getFacetsByType(Module module, FacetTypeId<F> type) {
            return AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module).getFacetsByType(type);
        }

        public <F extends Facet> F findFacet(Module module, FacetTypeId<F> type, String name) {
            return (F)AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module).findFacet(type, name);
        }
    }

    private class MyModulesProvider
    implements ModulesProvider {
        private MyModulesProvider() {
        }

        @NotNull
        public Module[] getModules() {
            return AbstractIdeModifiableModelsProvider.this.getModules();
        }

        public Module getModule(@NotNull String name) {
            return AbstractIdeModifiableModelsProvider.this.findIdeModule(name);
        }

        public ModuleRootModel getRootModel(@NotNull Module module) {
            return AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(module);
        }

        @NotNull
        public FacetModel getFacetModel(@NotNull Module module) {
            return AbstractIdeModifiableModelsProvider.this.getModifiableFacetModel(module);
        }
    }

    private class MyPackagingElementResolvingContext
    implements PackagingElementResolvingContext {
        private final ModulesProvider myModulesProvider;
        private final MyFacetsProvider myFacetsProvider;
        private final ManifestFileProvider myManifestFileProvider;

        private MyPackagingElementResolvingContext() {
            this.myModulesProvider = new MyModulesProvider();
            this.myFacetsProvider = new MyFacetsProvider();
            this.myManifestFileProvider = new DefaultManifestFileProvider((PackagingElementResolvingContext)this);
        }

        @NotNull
        public Project getProject() {
            return AbstractIdeModifiableModelsProvider.this.myProject;
        }

        @NotNull
        public ArtifactModel getArtifactModel() {
            return AbstractIdeModifiableModelsProvider.this.getModifiableArtifactModel();
        }

        @NotNull
        public ModulesProvider getModulesProvider() {
            return this.myModulesProvider;
        }

        @NotNull
        public FacetsProvider getFacetsProvider() {
            return this.myFacetsProvider;
        }

        public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
            if (level.equals("project")) {
                return AbstractIdeModifiableModelsProvider.this.getLibraryByName(libraryName);
            }
            LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, AbstractIdeModifiableModelsProvider.this.myProject);
            return table != null ? table.getLibraryByName(libraryName) : null;
        }

        @NotNull
        public ManifestFileProvider getManifestFileProvider() {
            return this.myManifestFileProvider;
        }
    }

    private static class MyUserDataHolderBase
    extends UserDataHolderBase {
        private MyUserDataHolderBase() {
        }

        void clear() {
            this.clearUserData();
        }
    }
}

