/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.configurationStore.SettingsSavingComponentJavaAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExternalProjectsData", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExternalProjectsDataStorage
implements SettingsSavingComponentJavaAdapter,
PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(ExternalProjectsDataStorage.class);
    private static final String STORAGE_VERSION = ExternalProjectsDataStorage.class.getSimpleName() + ".2";
    @NotNull
    private final Project myProject;
    private final Alarm myAlarm;
    @NotNull
    private final Map<Pair<ProjectSystemId, File>, InternalExternalProjectInfo> myExternalRootProjects = ConcurrentCollectionFactory.createMap(ExternalSystemUtil.HASHING_STRATEGY);
    private final AtomicBoolean changed = new AtomicBoolean();
    private State myState = new State();

    public static ExternalProjectsDataStorage getInstance(@NotNull Project project) {
        return (ExternalProjectsDataStorage)ServiceManager.getService((Project)project, ExternalProjectsDataStorage.class);
    }

    public ExternalProjectsDataStorage(@NotNull Project project) {
        this.myProject = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
    }

    public ExternalProjectsDataStorage(@NotNull Project project, @NotNull Alarm alarm) {
        this.myProject = project;
        this.myAlarm = alarm;
    }

    public synchronized void load() {
        this.myExternalRootProjects.clear();
        long startTs = System.currentTimeMillis();
        try {
            Collection<InternalExternalProjectInfo> projectInfos = ExternalProjectsDataStorage.load(this.myProject);
            if (projectInfos.isEmpty() && this.myProject.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) != Boolean.TRUE && this.hasLinkedExternalProjects()) {
                this.markDirtyAllExternalProjects();
            }
            for (InternalExternalProjectInfo projectInfo : projectInfos) {
                if (ExternalProjectsDataStorage.validate(projectInfo)) {
                    this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)Pair.create((Object)projectInfo.getProjectSystemId(), (Object)new File(projectInfo.getExternalProjectPath())), projectInfo);
                    if (projectInfo.getLastImportTimestamp() == projectInfo.getLastSuccessfulImportTimestamp()) continue;
                    this.markDirty(projectInfo.getExternalProjectPath());
                    continue;
                }
                String projectPath = projectInfo.getNullSafeExternalProjectPath();
                if (projectPath == null) continue;
                this.markDirty(projectPath);
            }
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            this.markDirtyAllExternalProjects();
        }
        this.mergeLocalSettings();
        long finishTs = System.currentTimeMillis();
        LOG.info("Loaded external projects data in " + (finishTs - startTs) + " millis");
    }

    private boolean hasLinkedExternalProjects() {
        return ExternalSystemApiUtil.getAllManagers().stream().anyMatch(manager -> !((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectsSettings().isEmpty());
    }

    private void markDirtyAllExternalProjects() {
        ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirtyAllExternalProjects();
    }

    private void markDirty(String projectPath) {
        ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirty(projectPath);
    }

    private static boolean validate(InternalExternalProjectInfo externalProjectInfo) {
        try {
            DataNode<ProjectData> projectStructure = externalProjectInfo.getExternalProjectStructure();
            if (projectStructure == null) {
                return false;
            }
            ProjectDataManagerImpl.getInstance().ensureTheDataIsReadyToUse(projectStructure);
            return externalProjectInfo.getExternalProjectPath().equals(((ProjectData)projectStructure.getData()).getLinkedExternalProjectPath());
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public synchronized void doSave() {
        if (!this.changed.compareAndSet(true, false)) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest((Runnable)new MySaveTask(this.myProject, this.myExternalRootProjects.values()), 0);
    }

    public synchronized void saveAndWait() throws Exception {
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode(), (Object)"This method is available for tests only");
        this.doSave();
        this.myAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
    }

    synchronized void update(@NotNull ExternalProjectInfo externalProjectInfo) {
        this.restoreInclusionSettings((DataNode<ProjectData>)externalProjectInfo.getExternalProjectStructure());
        ProjectSystemId projectSystemId = externalProjectInfo.getProjectSystemId();
        String projectPath = externalProjectInfo.getExternalProjectPath();
        DataNode externalProjectStructure = externalProjectInfo.getExternalProjectStructure();
        long lastSuccessfulImportTimestamp = externalProjectInfo.getLastSuccessfulImportTimestamp();
        long lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
        Pair key = Pair.create((Object)projectSystemId, (Object)new File(projectPath));
        InternalExternalProjectInfo old = this.myExternalRootProjects.get(key);
        if (old != null) {
            lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
            if (lastSuccessfulImportTimestamp == -1L) {
                lastSuccessfulImportTimestamp = old.getLastSuccessfulImportTimestamp();
            }
            externalProjectStructure = externalProjectInfo.getExternalProjectStructure() == null ? old.getExternalProjectStructure() : externalProjectInfo.getExternalProjectStructure().graphCopy();
        } else {
            externalProjectStructure = externalProjectStructure != null ? externalProjectStructure.graphCopy() : null;
        }
        InternalExternalProjectInfo merged = new InternalExternalProjectInfo(projectSystemId, projectPath, (DataNode<ProjectData>)externalProjectStructure);
        merged.setLastImportTimestamp(lastImportTimestamp);
        merged.setLastSuccessfulImportTimestamp(lastSuccessfulImportTimestamp);
        this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)key, merged);
        this.changed.set(true);
    }

    synchronized void restoreInclusionSettings(@Nullable DataNode<ProjectData> projectDataNode) {
        if (projectDataNode == null) {
            return;
        }
        String rootProjectPath = ((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath();
        ProjectState projectState = this.myState.map.get(rootProjectPath);
        if (projectState == null) {
            return;
        }
        ExternalSystemApiUtil.visit(projectDataNode, node -> {
            DataNode<ExternalConfigPathAware> projectOrModuleNode = ExternalProjectsDataStorage.resolveProjectNode(node);
            assert (projectOrModuleNode != null);
            ModuleState moduleState = projectState.map.get(((ExternalConfigPathAware)projectOrModuleNode.getData()).getLinkedExternalProjectPath());
            node.setIgnored(ExternalProjectsDataStorage.isIgnored(projectState, moduleState, node.getKey()));
        });
    }

    synchronized void saveInclusionSettings(@Nullable DataNode<ProjectData> projectDataNode) {
        MultiMap map;
        if (projectDataNode == null) {
            return;
        }
        MultiMap inclusionMap = MultiMap.create();
        MultiMap exclusionMap = MultiMap.create();
        ExternalSystemApiUtil.visit(projectDataNode, dataNode -> {
            DataNode<ExternalConfigPathAware> projectNode = ExternalProjectsDataStorage.resolveProjectNode(dataNode);
            if (projectNode != null) {
                String projectPath = ((ExternalConfigPathAware)projectNode.getData()).getLinkedExternalProjectPath();
                if (projectNode.isIgnored() || dataNode.isIgnored()) {
                    exclusionMap.putValue((Object)projectPath, (Object)dataNode.getKey().getDataType());
                } else {
                    inclusionMap.putValue((Object)projectPath, (Object)dataNode.getKey().getDataType());
                }
            }
        });
        ProjectState projectState = new ProjectState();
        if (inclusionMap.size() < exclusionMap.size()) {
            projectState.isInclusion = true;
            map = inclusionMap;
        } else {
            projectState.isInclusion = false;
            map = exclusionMap;
        }
        for (String path : map.keySet()) {
            projectState.map.put(path, new ModuleState(map.get((Object)path)));
        }
        this.myState.map.put(((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath(), projectState);
        this.changed.set(true);
    }

    @Nullable
    synchronized ExternalProjectInfo get(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        return this.myExternalRootProjects.get(Pair.create((Object)projectSystemId, (Object)new File(externalProjectPath)));
    }

    synchronized void remove(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        InternalExternalProjectInfo removed = this.myExternalRootProjects.remove(Pair.create((Object)projectSystemId, (Object)new File(externalProjectPath)));
        if (removed != null) {
            this.changed.set(true);
        }
    }

    @NotNull
    synchronized Collection<ExternalProjectInfo> list(@NotNull ProjectSystemId projectSystemId) {
        return ContainerUtil.mapNotNull(this.myExternalRootProjects.values(), info -> projectSystemId.equals((Object)info.getProjectSystemId()) ? info : null);
    }

    private void mergeLocalSettings() {
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            ProjectSystemId systemId = manager.getSystemId();
            AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject);
            Map availableProjects = settings.getAvailableProjects();
            for (Map.Entry entry : availableProjects.entrySet()) {
                ExternalProjectSettings linkedProjectSettings;
                ExternalProjectPojo projectPojo = (ExternalProjectPojo)entry.getKey();
                String externalProjectPath = projectPojo.getPath();
                Pair key = Pair.create((Object)systemId, (Object)new File(externalProjectPath));
                InternalExternalProjectInfo externalProjectInfo = this.myExternalRootProjects.get(key);
                if (externalProjectInfo == null) {
                    DataNode<ProjectData> dataNode = ExternalProjectsDataStorage.convert(systemId, projectPojo, (Collection)entry.getValue());
                    externalProjectInfo = new InternalExternalProjectInfo(systemId, externalProjectPath, dataNode);
                    this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)key, externalProjectInfo);
                    ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirty(externalProjectPath);
                    this.changed.set(true);
                }
                if ((linkedProjectSettings = ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectSettings(externalProjectPath)) == null || !ContainerUtil.isEmpty((Collection)linkedProjectSettings.getModules())) continue;
                Set modulePaths = ContainerUtil.map2Set((Collection)ExternalSystemApiUtil.findAllRecursively(externalProjectInfo.getExternalProjectStructure(), (Key)ProjectKeys.MODULE), node -> ((ModuleData)node.getData()).getLinkedExternalProjectPath());
                linkedProjectSettings.setModules(modulePaths);
            }
        }
    }

    private static DataNode<ProjectData> convert(@NotNull ProjectSystemId systemId, @NotNull ExternalProjectPojo rootProject, @NotNull Collection<? extends ExternalProjectPojo> childProjects) {
        ProjectData projectData = new ProjectData(systemId, rootProject.getName(), rootProject.getPath(), rootProject.getPath());
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        for (ExternalProjectPojo externalProjectPojo : childProjects) {
            String moduleConfigPath = externalProjectPojo.getPath();
            ModuleData moduleData = new ModuleData(externalProjectPojo.getName(), systemId, "JAVA_MODULE", externalProjectPojo.getName(), moduleConfigPath, moduleConfigPath);
            projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
        }
        return projectDataNode;
    }

    private static void doSave(@NotNull Project project, @NotNull Collection<InternalExternalProjectInfo> externalProjects) throws IOException {
        Path projectConfigurationFile = ExternalProjectsDataStorage.getProjectConfigurationFile(project);
        if (!FileUtil.createParentDirs((File)projectConfigurationFile.toFile())) {
            throw new IOException("Unable to save " + projectConfigurationFile);
        }
        Iterator<InternalExternalProjectInfo> iterator = externalProjects.iterator();
        while (iterator.hasNext()) {
            InternalExternalProjectInfo externalProject = iterator.next();
            if (!ExternalProjectsDataStorage.validate(externalProject)) {
                iterator.remove();
                continue;
            }
            ExternalSystemApiUtil.visit(externalProject.getExternalProjectStructure(), dataNode -> {
                try {
                    dataNode.checkIsSerializable();
                }
                catch (IOException e) {
                    dataNode.clear(true);
                }
            });
        }
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(projectConfigurationFile, new OpenOption[0])));){
            out.writeUTF(STORAGE_VERSION);
            out.writeInt(externalProjects.size());
            try (ObjectOutputStream os = new ObjectOutputStream(out);){
                for (InternalExternalProjectInfo externalProject : externalProjects) {
                    os.writeObject(externalProject);
                }
            }
        }
    }

    @Nullable
    private static DataNode<ExternalConfigPathAware> resolveProjectNode(@NotNull DataNode node) {
        if ((ProjectKeys.MODULE.equals((Object)node.getKey()) || ProjectKeys.PROJECT.equals((Object)node.getKey())) && node.getData() instanceof ExternalConfigPathAware) {
            return node;
        }
        DataNode parent = ExternalSystemApiUtil.findParent((DataNode)node, (Key)ProjectKeys.MODULE);
        if (parent == null) {
            parent = ExternalSystemApiUtil.findParent((DataNode)node, (Key)ProjectKeys.PROJECT);
        }
        return parent;
    }

    @NotNull
    private static Collection<InternalExternalProjectInfo> load(@NotNull Project project) throws IOException {
        SmartList projects = new SmartList();
        Path configurationFile = ExternalProjectsDataStorage.getProjectConfigurationFile(project);
        if (!configurationFile.toFile().isFile()) {
            return projects;
        }
        if (ExternalProjectsDataStorage.isInvalidated(configurationFile)) {
            throw new IOException("External projects data storage was invalidated");
        }
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(configurationFile, new OpenOption[0])));){
            String storage_version = in.readUTF();
            if (!STORAGE_VERSION.equals(storage_version)) {
                SmartList smartList = projects;
                return smartList;
            }
            int size = in.readInt();
            try (ObjectInputStream os = new ObjectInputStream(in);){
                for (int i = 0; i < size; ++i) {
                    InternalExternalProjectInfo projectDataDataNode = (InternalExternalProjectInfo)os.readObject();
                    projects.add((Object)projectDataDataNode);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return projects;
    }

    private static boolean isInvalidated(@NotNull Path configurationFile) {
        if (!Registry.is((String)"external.system.invalidate.storage", (boolean)true)) {
            return false;
        }
        long lastModified = configurationFile.toFile().lastModified();
        if (lastModified == 0L) {
            return true;
        }
        File brokenMarkerFile = ExternalProjectsDataStorage.getBrokenMarkerFile();
        if (brokenMarkerFile.exists() && lastModified < brokenMarkerFile.lastModified()) {
            if (!FileUtil.delete((File)configurationFile.toFile())) {
                LOG.warn("Cannot delete invalidated external project cache file");
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static Path getProjectConfigurationFile(@NotNull Project project) {
        return ExternalProjectsDataStorage.getProjectConfigurationDir(project).resolve("project.dat");
    }

    @NotNull
    public static Path getProjectConfigurationDir(@NotNull Project project) {
        return ProjectUtil.getExternalConfigurationDir((Project)project);
    }

    @Nullable
    public synchronized State getState() {
        return this.myState;
    }

    public synchronized void loadState(@NotNull State state) {
        this.myState = state == null ? new State() : state;
    }

    synchronized void setIgnored(@NotNull DataNode<?> dataNode, boolean isIgnored) {
        DataNode projectDataNode;
        DataNode dataNode2 = projectDataNode = ProjectKeys.PROJECT.equals((Object)dataNode.getKey()) ? dataNode : ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.PROJECT);
        if (projectDataNode == null) {
            return;
        }
        ExternalSystemApiUtil.visit((DataNode)dataNode, node -> node.setIgnored(isIgnored));
        this.saveInclusionSettings((DataNode<ProjectData>)projectDataNode);
    }

    synchronized boolean isIgnored(@NotNull String rootProjectPath, @NotNull String modulePath, @NotNull Key key) {
        ProjectState projectState = this.myState.map.get(rootProjectPath);
        if (projectState == null) {
            return false;
        }
        ModuleState moduleState = projectState.map.get(modulePath);
        return ExternalProjectsDataStorage.isIgnored(projectState, moduleState, key);
    }

    private static boolean isIgnored(@NotNull ProjectState projectState, @Nullable ModuleState moduleState, @NotNull Key<?> key) {
        return projectState.isInclusion ^ (moduleState != null && moduleState.set.contains(key.getDataType()));
    }

    public static synchronized void invalidateCaches() {
        if (!Registry.is((String)"external.system.invalidate.storage", (boolean)true)) {
            return;
        }
        File markerFile = ExternalProjectsDataStorage.getBrokenMarkerFile();
        try {
            FileUtil.writeToFile((File)markerFile, (String)String.valueOf(System.currentTimeMillis()));
        }
        catch (IOException e) {
            LOG.warn("Cannot update the invalidation marker file", (Throwable)e);
        }
    }

    @NotNull
    private static File getBrokenMarkerFile() {
        return PathManagerEx.getAppSystemDir().resolve("external_build_system").resolve(".broken").toFile();
    }

    private static class MySaveTask
    implements Runnable {
        private final Project myProject;
        private final Collection<InternalExternalProjectInfo> myExternalProjects;

        MySaveTask(Project project, Collection<InternalExternalProjectInfo> externalProjects) {
            this.myProject = project;
            this.myExternalProjects = ContainerUtil.map(externalProjects, info -> (InternalExternalProjectInfo)info.copy());
        }

        @Override
        public void run() {
            try {
                ExternalProjectsDataStorage.doSave(this.myProject, this.myExternalProjects);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    static class ModuleState {
        @Property(surroundWithTag=false)
        @XCollection(elementName="id")
        public final Set<String> set = ContainerUtil.newConcurrentSet();

        ModuleState() {
        }

        ModuleState(Collection<String> values) {
            this.set.addAll(values);
        }
    }

    static class ProjectState {
        @Property(surroundWithTag=false)
        @XMap(keyAttributeName="path", entryTagName="dataType")
        public final Map<String, ModuleState> map = ContainerUtil.newConcurrentMap();
        public boolean isInclusion;

        ProjectState() {
        }
    }

    static class State {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundValueWithTag=false, surroundKeyWithTag=false, keyAttributeName="path", entryTagName="projectState")
        public final Map<String, ProjectState> map = ContainerUtil.newConcurrentMap();

        State() {
        }
    }
}

