/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ExternalSystemRunManagerListener
implements RunManagerListener {
    private Disposable eventDisposable;
    private final ExternalProjectsManagerImpl myManager;
    private final ConcurrentIntObjectMap<Pair<String, RunnerAndConfigurationSettings>> myMap;

    ExternalSystemRunManagerListener(ExternalProjectsManager manager) {
        this.myManager = (ExternalProjectsManagerImpl)manager;
        this.myMap = ContainerUtil.createConcurrentIntObjectMap();
    }

    public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
        ExternalSystemRunManagerListener.add(this.myMap, settings);
    }

    public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings.getConfiguration() instanceof ExternalSystemRunConfiguration) {
            Pair pair = (Pair)this.myMap.remove(System.identityHashCode(settings));
            if (pair == null) {
                return;
            }
            ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = this.myManager.getStateProvider();
            ExternalSystemTaskExecutionSettings taskExecutionSettings = ((ExternalSystemRunConfiguration)settings.getConfiguration()).getSettings();
            if (taskExecutionSettings.getExternalProjectPath() == null) {
                return;
            }
            TaskActivationState activation = stateProvider.getTasksActivation(taskExecutionSettings.getExternalSystemId(), taskExecutionSettings.getExternalProjectPath());
            block0: for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
                Iterator<String> iterator = activation.getTasks(phase).iterator();
                while (iterator.hasNext()) {
                    String task = iterator.next();
                    if (!((String)pair.first).equals(task)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        }
    }

    public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
        Pair pair;
        if (settings.getConfiguration() instanceof ExternalSystemRunConfiguration && (pair = (Pair)this.myMap.get(System.identityHashCode(settings))) != null) {
            ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = this.myManager.getStateProvider();
            ExternalSystemTaskExecutionSettings taskExecutionSettings = ((ExternalSystemRunConfiguration)settings.getConfiguration()).getSettings();
            if (taskExecutionSettings.getExternalProjectPath() == null) {
                return;
            }
            TaskActivationState activation = stateProvider.getTasksActivation(taskExecutionSettings.getExternalSystemId(), taskExecutionSettings.getExternalProjectPath());
            block0: for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
                List<String> modifiableActivationTasks = activation.getTasks(phase);
                for (String task : ContainerUtil.newArrayList(modifiableActivationTasks)) {
                    if (!((String)pair.first).equals(task)) continue;
                    modifiableActivationTasks.remove(task);
                    String runConfigurationActivationTaskName = ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(settings);
                    modifiableActivationTasks.add(runConfigurationActivationTaskName);
                    this.myMap.put(System.identityHashCode(settings), (Object)Pair.create((Object)runConfigurationActivationTaskName, (Object)settings));
                    continue block0;
                }
            }
        }
    }

    public void attach() {
        this.eventDisposable = Disposer.newDisposable();
        this.myManager.getProject().getMessageBus().connect(this.eventDisposable).subscribe(RunManagerListener.TOPIC, (Object)this);
    }

    public void stateLoaded(@NotNull RunManager runManager, boolean isFirstLoadState) {
        this.myMap.clear();
        for (ExternalSystemManager systemManager : ExternalSystemApiUtil.getAllManagers()) {
            AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(systemManager.getSystemId());
            if (configurationType == null) continue;
            for (RunnerAndConfigurationSettings configurationSettings : runManager.getConfigurationSettingsList((ConfigurationType)configurationType)) {
                ExternalSystemRunManagerListener.add(this.myMap, configurationSettings);
            }
        }
    }

    public void detach() {
        this.myMap.clear();
        Disposable disposable = this.eventDisposable;
        if (disposable != null) {
            this.eventDisposable = null;
            Disposer.dispose((Disposable)disposable);
        }
    }

    private static void add(@NotNull ConcurrentIntObjectMap<Pair<String, RunnerAndConfigurationSettings>> map, @NotNull RunnerAndConfigurationSettings settings) {
        if (settings.getConfiguration() instanceof ExternalSystemRunConfiguration) {
            map.put(System.identityHashCode(settings), (Object)Pair.create((Object)ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(settings), (Object)settings));
        }
    }
}

