/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemShortcutsManager
implements Disposable {
    private static final String ACTION_ID_PREFIX = "ExternalSystem_";
    @NotNull
    private final Project myProject;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public ExternalSystemShortcutsManager(@NotNull Project project) {
        this.myProject = project;
    }

    public void init() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(){

            public void activeKeymapChanged(Keymap keymap) {
                ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
            }

            public void shortcutChanged(@NotNull Keymap keymap, @NotNull String actionId) {
                ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
            }
        });
    }

    public String getActionId(@Nullable String projectPath, @Nullable String taskName) {
        StringBuilder result = new StringBuilder(ACTION_ID_PREFIX);
        result.append(this.myProject.getLocationHash());
        if (projectPath != null) {
            String portablePath = FileUtil.toSystemIndependentName((String)projectPath);
            File file = new File(portablePath);
            result.append(file.isFile() && file.getParentFile() != null ? file.getParentFile().getName() : file.getName());
            result.append(Integer.toHexString(portablePath.hashCode()));
            if (taskName != null) {
                result.append(taskName);
            }
        }
        return result.toString();
    }

    public String getDescription(@Nullable String projectPath, @Nullable String taskName) {
        Shortcut[] shortcuts = this.getShortcuts(projectPath, taskName);
        if (shortcuts.length == 0) {
            return "";
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    public boolean hasShortcuts(@Nullable String projectPath, @Nullable String taskName) {
        return this.getShortcuts(projectPath, taskName).length > 0;
    }

    public boolean hasShortcuts(@NotNull String actionId) {
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        return activeKeymap.getShortcuts(actionId).length > 0;
    }

    @NotNull
    private Shortcut[] getShortcuts(@Nullable String projectPath, @Nullable String taskName) {
        String actionId = this.getActionId(projectPath, taskName);
        if (actionId == null) {
            return Shortcut.EMPTY_ARRAY;
        }
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        return activeKeymap.getShortcuts(actionId);
    }

    private void fireShortcutsUpdated() {
        for (Listener listener : this.myListeners) {
            listener.shortcutsUpdated();
        }
    }

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void scheduleKeymapUpdate(Collection<DataNode<TaskData>> taskData) {
        ExternalSystemKeymapExtension.updateActions(this.myProject, taskData);
    }

    public void scheduleRunConfigurationKeymapUpdate(@NotNull ProjectSystemId externalSystemId) {
        ExternalSystemKeymapExtension.updateRunConfigurationActions(this.myProject, externalSystemId);
    }

    public void dispose() {
        ExternalSystemKeymapExtension.clearActions(this.myProject);
    }

    public static interface Listener {
        public void shortcutsUpdated();
    }
}

