/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskActivator {
    private static final Logger LOG = Logger.getInstance(ExternalSystemTaskActivator.class);
    public static final String RUN_CONFIGURATION_TASK_PREFIX = "run: ";
    @NotNull
    private final Project myProject;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public ExternalSystemTaskActivator(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public static String getRunConfigurationActivationTaskName(@NotNull RunnerAndConfigurationSettings settings) {
        return RUN_CONFIGURATION_TASK_PREFIX + settings.getName();
    }

    public void init() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        if (compilerManager == null) {
            return;
        }
        class MyCompileTask
        implements CompileTask {
            private final boolean myBefore;

            MyCompileTask(boolean before) {
                this.myBefore = before;
            }

            public boolean execute(CompileContext context) {
                return ExternalSystemTaskActivator.this.doExecuteCompileTasks(this.myBefore, context);
            }
        }
        compilerManager.addBeforeTask((CompileTask)new MyCompileTask(true));
        compilerManager.addAfterTask((CompileTask)new MyCompileTask(false));
        this.fireTasksChanged();
    }

    public String getDescription(ProjectSystemId systemId, String projectPath, String taskName) {
        ArrayList<String> result = new ArrayList<String>();
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        TaskActivationState taskActivationState = stateProvider.getTasksActivation(systemId, projectPath);
        if (taskActivationState == null) {
            return null;
        }
        for (Phase phase : Phase.values()) {
            if (!taskActivationState.getTasks(phase).contains(taskName)) continue;
            result.add(phase.toString());
        }
        return StringUtil.join(result, (String)", ");
    }

    private boolean doExecuteCompileTasks(boolean myBefore, @NotNull CompileContext context) {
        List modules = (List)ReadAction.compute(() -> ContainerUtil.mapNotNull((Object[])context.getCompileScope().getAffectedModules(), module -> ExternalSystemApiUtil.getExternalProjectPath((Module)module)));
        ArrayList phases = ContainerUtil.newArrayList();
        if (myBefore) {
            if (context.isRebuild()) {
                phases.add(Phase.BEFORE_REBUILD);
            }
            phases.add(Phase.BEFORE_COMPILE);
        } else {
            phases.add(Phase.AFTER_COMPILE);
            if (context.isRebuild()) {
                phases.add(Phase.AFTER_REBUILD);
            }
        }
        return this.runTasks(modules, phases.toArray(new Phase[0]));
    }

    public boolean runTasks(@NotNull String modulePath, Phase ... phases) {
        return this.runTasks(Collections.singleton(modulePath), phases);
    }

    public boolean runTasks(@NotNull Collection<String> modules, Phase ... phases) {
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        LinkedList<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>> tasksQueue = new LinkedList<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>>();
        Map lazyConfigurationsMap = FactoryMap.create(key -> {
            AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(key);
            if (configurationType == null) {
                return null;
            }
            return ContainerUtil.map2Map((Collection)RunManager.getInstance((Project)this.myProject).getConfigurationSettingsList((ConfigurationType)configurationType), configurationSettings1 -> Pair.create((Object)configurationSettings1.getName(), (Object)configurationSettings1));
        });
        for (ExternalProjectsManagerImpl.ExternalProjectsStateProvider.TasksActivation activation : stateProvider.getAllTasksActivation()) {
            boolean hashPath = modules.contains(activation.projectPath);
            LinkedHashSet tasks = ContainerUtil.newLinkedHashSet();
            for (Phase phase : phases) {
                List<String> activationTasks = activation.state.getTasks(phase);
                if (!hashPath && (!phase.isSyncPhase() || activationTasks.isEmpty() || !this.isShareSameRootPath(modules, activation))) continue;
                ContainerUtil.addAll((Collection)tasks, activationTasks);
            }
            if (tasks.isEmpty()) continue;
            Iterator iterator = tasks.iterator();
            while (iterator.hasNext()) {
                RunnerAndConfigurationSettings configurationSettings;
                String task = (String)iterator.next();
                if (task.length() <= RUN_CONFIGURATION_TASK_PREFIX.length() || !task.startsWith(RUN_CONFIGURATION_TASK_PREFIX)) continue;
                iterator.remove();
                String configurationName = task.substring(RUN_CONFIGURATION_TASK_PREFIX.length());
                Map settings = (Map)lazyConfigurationsMap.get(activation.systemId);
                if (settings == null || (configurationSettings = (RunnerAndConfigurationSettings)settings.get(configurationName)) == null) continue;
                RunConfiguration runConfiguration = configurationSettings.getConfiguration();
                if (!configurationName.equals(configurationSettings.getName()) || !(runConfiguration instanceof ExternalSystemRunConfiguration)) continue;
                tasksQueue.add((Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>)Pair.create((Object)activation.systemId, (Object)((ExternalSystemRunConfiguration)runConfiguration).getSettings()));
            }
            if (tasks.isEmpty() || ExternalProjectsManager.getInstance((Project)this.myProject).isIgnored(activation.systemId, activation.projectPath)) continue;
            ExternalSystemTaskExecutionSettings executionSettings = new ExternalSystemTaskExecutionSettings();
            executionSettings.setExternalSystemIdString(activation.systemId.toString());
            executionSettings.setExternalProjectPath(activation.projectPath);
            executionSettings.getTaskNames().addAll(tasks);
            tasksQueue.add((Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>)Pair.create((Object)activation.systemId, (Object)executionSettings));
        }
        return this.runTasksQueue(tasksQueue);
    }

    private boolean isShareSameRootPath(@NotNull Collection<String> modules, @NotNull ExternalProjectsManagerImpl.ExternalProjectsStateProvider.TasksActivation activation) {
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)activation.systemId);
        String rootProjectPath = ExternalSystemTaskActivator.getRootProjectPath(systemSettings, activation.projectPath);
        List rootPath = ContainerUtil.mapNotNull(modules, path -> ExternalSystemTaskActivator.getRootProjectPath(systemSettings, path));
        return rootPath.contains(rootProjectPath);
    }

    @Nullable
    private static String getRootProjectPath(@NotNull AbstractExternalSystemSettings systemSettings, @NotNull String projectPath) {
        ExternalProjectSettings projectSettings = systemSettings.getLinkedProjectSettings(projectPath);
        return projectSettings != null ? projectSettings.getExternalProjectPath() : null;
    }

    private boolean runTasksQueue(final Queue<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>> tasksQueue) {
        Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings> pair = tasksQueue.poll();
        if (pair == null) {
            return true;
        }
        ProjectSystemId systemId = (ProjectSystemId)pair.first;
        ExternalSystemTaskExecutionSettings executionSettings = (ExternalSystemTaskExecutionSettings)pair.getSecond();
        final Semaphore targetDone = new Semaphore();
        targetDone.down();
        final Ref result = new Ref((Object)false);
        ExternalSystemUtil.runTask(executionSettings, DefaultRunExecutor.EXECUTOR_ID, this.myProject, systemId, new TaskCallback(){

            public void onSuccess() {
                result.set((Object)ExternalSystemTaskActivator.this.runTasksQueue(tasksQueue));
                targetDone.up();
            }

            public void onFailure() {
                targetDone.up();
            }
        }, ProgressExecutionMode.IN_BACKGROUND_ASYNC, false);
        targetDone.waitFor();
        return (Boolean)result.get();
    }

    public void addListener(@NotNull Listener l) {
        this.myListeners.add(l);
    }

    public boolean isTaskOfPhase(@NotNull TaskData taskData, @NotNull Phase phase) {
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        TaskActivationState taskActivationState = stateProvider.getTasksActivation(taskData.getOwner(), taskData.getLinkedExternalProjectPath());
        if (taskActivationState == null) {
            return false;
        }
        return taskActivationState.getTasks(phase).contains(taskData.getName());
    }

    public void addTasks(@NotNull Collection<TaskData> tasks, @NotNull Phase phase) {
        if (tasks.isEmpty()) {
            return;
        }
        this.addTasks(ContainerUtil.map(tasks, data -> new TaskActivationEntry(data.getOwner(), phase, data.getLinkedExternalProjectPath(), data.getName())));
        this.fireTasksChanged();
    }

    public void addTasks(@NotNull Collection<TaskActivationEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        for (TaskActivationEntry entry : entries) {
            TaskActivationState taskActivationState = stateProvider.getTasksActivation(entry.systemId, entry.projectPath);
            taskActivationState.getTasks(entry.phase).add(entry.taskName);
        }
        this.fireTasksChanged();
    }

    public void removeTasks(@NotNull Collection<TaskData> tasks, @NotNull Phase phase) {
        if (tasks.isEmpty()) {
            return;
        }
        this.removeTasks(ContainerUtil.map(tasks, data -> new TaskActivationEntry(data.getOwner(), phase, data.getLinkedExternalProjectPath(), data.getName())));
    }

    public void removeTasks(@NotNull Collection<TaskActivationEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        for (TaskActivationEntry activationEntry : entries) {
            TaskActivationState taskActivationState = stateProvider.getTasksActivation(activationEntry.systemId, activationEntry.projectPath);
            taskActivationState.getTasks(activationEntry.phase).remove(activationEntry.taskName);
        }
        this.fireTasksChanged();
    }

    public void addTask(@NotNull TaskActivationEntry entry) {
        this.addTasks(Collections.singleton(entry));
    }

    public void removeTask(@NotNull TaskActivationEntry entry) {
        this.removeTasks(Collections.singleton(entry));
    }

    public void moveTasks(@NotNull Collection<TaskActivationEntry> entries, int increment) {
        LOG.assertTrue(increment == -1 || increment == 1);
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        for (TaskActivationEntry activationEntry : entries) {
            TaskActivationState taskActivationState = stateProvider.getTasksActivation(activationEntry.systemId, activationEntry.projectPath);
            List<String> tasks = taskActivationState.getTasks(activationEntry.phase);
            int i1 = tasks.indexOf(activationEntry.taskName);
            int i2 = i1 + increment;
            if (i1 == -1 || tasks.size() <= i2 || i2 < 0) continue;
            Collections.swap(tasks, i1, i2);
        }
    }

    public void moveProjects(@NotNull ProjectSystemId systemId, @NotNull List<String> projectsPathsToMove, @Nullable Collection<String> pathsGroup, int increment) {
        LOG.assertTrue(increment == -1 || increment == 1);
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        Map<String, TaskActivationState> activationMap = stateProvider.getProjectsTasksActivationMap(systemId);
        ArrayList currentPaths = ContainerUtil.newArrayList(activationMap.keySet());
        if (pathsGroup != null) {
            currentPaths.retainAll(pathsGroup);
        }
        for (String path : projectsPathsToMove) {
            int i1 = currentPaths.indexOf(path);
            int i2 = i1 + increment;
            if (i1 == -1 || currentPaths.size() <= i2 || i2 < 0) continue;
            Collections.swap(currentPaths, i1, i2);
        }
        LinkedHashMap rearrangedMap = ContainerUtil.newLinkedHashMap();
        for (String path : currentPaths) {
            rearrangedMap.put(path, activationMap.get(path));
            activationMap.remove(path);
        }
        activationMap.putAll(rearrangedMap);
    }

    public void fireTasksChanged() {
        for (Listener each : this.myListeners) {
            each.tasksActivationChanged();
        }
    }

    public static class TaskActivationEntry {
        @NotNull
        private final ProjectSystemId systemId;
        @NotNull
        private final Phase phase;
        @NotNull
        private final String projectPath;
        @NotNull
        private final String taskName;

        public TaskActivationEntry(@NotNull ProjectSystemId systemId, @NotNull Phase phase, @NotNull String projectPath, @NotNull String taskName) {
            this.systemId = systemId;
            this.phase = phase;
            this.projectPath = projectPath;
            this.taskName = taskName;
        }

        @NotNull
        public ProjectSystemId getSystemId() {
            return this.systemId;
        }

        @NotNull
        public Phase getPhase() {
            return this.phase;
        }

        @NotNull
        public String getProjectPath() {
            return this.projectPath;
        }

        @NotNull
        public String getTaskName() {
            return this.taskName;
        }
    }

    public static interface Listener {
        public void tasksActivationChanged();
    }

    public static enum Phase {
        BEFORE_RUN("external.system.task.before.run"),
        BEFORE_SYNC("external.system.task.before.sync"),
        AFTER_SYNC("external.system.task.after.sync"),
        BEFORE_COMPILE("external.system.task.before.compile"),
        AFTER_COMPILE("external.system.task.after.compile"),
        BEFORE_REBUILD("external.system.task.before.rebuild"),
        AFTER_REBUILD("external.system.task.after.rebuild");

        public final String myMessageKey;

        private Phase(String messageKey) {
            this.myMessageKey = messageKey;
        }

        public boolean isSyncPhase() {
            return this == BEFORE_SYNC || this == AFTER_SYNC;
        }

        public String toString() {
            return ExternalSystemBundle.message((String)this.myMessageKey, (Object[])new Object[0]);
        }
    }
}

