/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationDataService;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483618)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J6\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J6\u0010\u0012\u001a\u00020\b2\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "onSuccessImport", "imported", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
public final class ConfigurationDataService
extends AbstractProjectDataService<ConfigurationData, Void> {
    private static final Logger LOG;
    @NotNull
    public static final String EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED = "external.system.configuration.import.enabled";
    public static final Companion Companion;

    @NotNull
    public Key<ConfigurationData> getTargetDataKey() {
        return ProjectKeys.CONFIGURATION;
    }

    public void importData(@NotNull Collection<? extends DataNode<ConfigurationData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        ConfigurationDataService.Companion.withConfigurationData(toImport, projectData, project, (IdeModelsProvider)modelsProvider, importData.1.INSTANCE, importData.2.INSTANCE);
    }

    public void onSuccessImport(@NotNull Collection<? extends DataNode<ConfigurationData>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        ConfigurationDataService.Companion.withConfigurationData(imported, projectData, project, modelsProvider, onSuccessImport.1.INSTANCE, onSuccessImport.2.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(ConfigurationDataService.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u00a3\u0001\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u0002H\t21\u0010\u0014\u001a-\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0015\u00a2\u0006\u0002\b\u00172)\u0010\u0018\u001a%\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u0019\u00a2\u0006\u0002\b\u0017H\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationDataService$Companion;", "", "()V", "EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "withConfigurationData", "", "ModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "configurationData", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "acceptProject", "Lkotlin/Function5;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "Lkotlin/ExtensionFunctionType;", "acceptModule", "Lkotlin/Function4;", "Lcom/intellij/openapi/module/Module;", "(Ljava/util/Collection;Lcom/intellij/openapi/externalSystem/model/project/ProjectData;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;Lkotlin/jvm/functions/Function5;Lkotlin/jvm/functions/Function4;)V", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private final <ModelsProvider extends IdeModelsProvider> void withConfigurationData(Collection<? extends DataNode<ConfigurationData>> configurationData, ProjectData projectData, Project project, ModelsProvider modelsProvider, Function5<? super ConfigurationHandler, ? super Project, ? super ProjectData, ? super ModelsProvider, ? super ConfigurationData, Unit> acceptProject, Function4<? super ConfigurationHandler, ? super Module, ? super ModelsProvider, ? super ConfigurationData, Unit> acceptModule) {
            DataNode projectDataNode;
            DataNode projectConfigurationNode;
            if (configurationData.isEmpty() || !Registry.is((String)ConfigurationDataService.EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED)) {
                LOG.debug("Configuration data is" + (!configurationData.isEmpty() ? " not " : " ") + "empty, Registry flag is " + Registry.is((String)ConfigurationDataService.EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED));
                return;
            }
            DataNode<ConfigurationData> javaProjectDataNode = configurationData.iterator().next();
            DataNode dataNode = ExternalSystemApiUtil.findParent(javaProjectDataNode, (Key)ProjectKeys.PROJECT);
            if (dataNode == null) {
                Intrinsics.throwNpe();
            }
            if ((projectConfigurationNode = ExternalSystemApiUtil.find((DataNode)(projectDataNode = dataNode), (Key)ProjectKeys.CONFIGURATION)) != null) {
                ConfigurationData configurationData2 = (ConfigurationData)projectConfigurationNode.getData();
                if (LOG.isDebugEnabled() && configurationData2 instanceof ConfigurationDataImpl) {
                    LOG.debug("Importing project configuration: " + ((ConfigurationDataImpl)configurationData2).getJsonString());
                }
                if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project, (ProjectData)((ProjectData)projectDataNode.getData()))) {
                    LOG.warn("This external project are not the only project in the current IDE workspace, found project level configuration can override the configuration came from other external projects.");
                }
                for (ConfigurationHandler handler : (ConfigurationHandler[])ConfigurationHandler.EP_NAME.getExtensions()) {
                    acceptProject.invoke((Object)handler, (Object)project, (Object)projectData, modelsProvider, (Object)configurationData2);
                }
            }
            for (DataNode<ConfigurationData> dataNode2 : configurationData) {
                DataNode moduleDataNode;
                if (dataNode2 == projectConfigurationNode || (moduleDataNode = ExternalSystemApiUtil.findParent(dataNode2, (Key)ProjectKeys.MODULE)) == null) continue;
                Module module = (Module)moduleDataNode.getUserData(AbstractModuleDataService.MODULE_KEY);
                Module module2 = module;
                if (module2 == null) {
                    module2 = module = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
                }
                if (module == null) {
                    String string;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "Can't import module level configuration. Reason: target module (%s) is not found at the ide";
                    Object[] objectArray = new Object[]{moduleDataNode};
                    Logger logger = LOG;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    logger.warn(string);
                    continue;
                }
                ConfigurationData data = (ConfigurationData)dataNode2.getData();
                if (LOG.isDebugEnabled() && data instanceof ConfigurationDataImpl) {
                    LOG.debug("Importing module configuration: " + ((ConfigurationDataImpl)data).getJsonString());
                }
                for (ConfigurationHandler handler : (ConfigurationHandler[])ConfigurationHandler.EP_NAME.getExtensions()) {
                    acceptModule.invoke((Object)handler, (Object)module, modelsProvider, (Object)data);
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

